/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config;

import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.DocumentLocation;
import com.ibm.ws.st.core.internal.config.ExtendedConfigFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;

public class Bootstrap
extends ExtendedConfigFile {
    private static final String KEY_INCLUDE = "bootstrap.include";
    private static final String KEY_MESSAGES_FILE = "com.ibm.ws.logging.message.file.name";
    private static final String KEY_LOG_DIR = "com.ibm.ws.logging.log.directory";
    private static final String KEY_TRACE_FILE = "com.ibm.ws.logging.trace.file.name";
    public static final Set<String> NON_VAR_KEYS = new HashSet<String>(5);
    protected HashMap<String, String> properties = new HashMap();
    protected long lastModified = -1L;

    public Bootstrap(File file, IFile ifile) throws IOException {
        super(file, ifile);
        this.lastModified = file.lastModified();
        this.load();
    }

    public boolean hasChanged() {
        long timestamp = this.file.lastModified();
        return timestamp != this.lastModified;
    }

    private void load() throws IOException {
        this.mergeProperties(this.properties, this.file.toURI().toURL(), null);
    }

    private void mergeProperties(Map<String, String> target, URL baseURL, String urlStr) throws IOException {
        String includes = null;
        URL url = baseURL != null && urlStr == null ? baseURL : new URL(baseURL, urlStr);
        Properties props = Bootstrap.getProperties(url.openStream());
        Properties p = new Properties();
        Enumeration<?> propsKeys = props.propertyNames();
        while (propsKeys.hasMoreElements()) {
            String propKey = (String)propsKeys.nextElement();
            String propValue = props.getProperty(propKey);
            propValue = propValue.trim();
            p.put(propKey, propValue);
        }
        includes = (String)p.remove(KEY_INCLUDE);
        this.addMissingProperties(p, target);
        if (includes != null) {
            this.processIncludes(target, url, includes);
        }
    }

    private void addMissingProperties(Properties source, Map<String, String> target) {
        if (source == null || source.isEmpty() || target == null) {
            return;
        }
        for (String key : source.stringPropertyNames()) {
            if (target.containsKey(key)) continue;
            String value = source.getProperty(key);
            target.put(key, value);
            System.setProperty(key, value);
        }
    }

    private void processIncludes(Map<String, String> mergeProps, URL rootURL, String includeProps) throws IOException {
        String[] props;
        if (includeProps == null) {
            return;
        }
        for (String pname : props = includeProps.trim().split("\\s*,\\s*")) {
            this.mergeProperties(mergeProps, rootURL, pname);
        }
    }

    public Set<Map.Entry<String, String>> getVariables(ConfigVars vars) {
        vars.startContext();
        DocumentLocation location = DocumentLocation.createDocumentLocation(this.file.toURI(), DocumentLocation.Type.BOOTSTRAP);
        Set<Map.Entry<String, String>> entries = this.properties.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String key = entry.getKey();
            if (NON_VAR_KEYS.contains(key)) continue;
            vars.add(key, entry.getValue(), location);
        }
        vars.endContext();
        return entries;
    }

    public String getMessagesFile() {
        return this.properties.get(KEY_MESSAGES_FILE);
    }

    public String getTraceFile() {
        return this.properties.get(KEY_TRACE_FILE);
    }

    public String getLogDir() {
        return this.properties.get(KEY_LOG_DIR);
    }

    public static Properties getProperties(InputStream is) throws IOException {
        Properties p = new Properties();
        try {
            if (is != null && is.available() > 0) {
                p.load(is);
            }
        }
        catch (Throwable e) {
            throw new IOException("Unable to load properties from InputStream", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return p;
    }

    @Override
    public String toString() {
        return "Bootstrap [" + this.file + "]";
    }

    static {
        NON_VAR_KEYS.add(KEY_INCLUDE);
    }
}

