/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLWriter
extends PrintWriter {
    private static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private final String lineSeparator;
    private int tab = 0;

    public XMLWriter(OutputStream stream, IProject project) {
        this((Writer)new PrintWriter(stream), project);
    }

    public XMLWriter(Writer writer, IProject project) {
        super(writer);
        this.lineSeparator = XMLWriter.getLineSeparator(project);
        this.print(XML_VERSION);
        this.print(this.lineSeparator);
    }

    private static String encode(String s) {
        StringBuilder sb = new StringBuilder(s.length() + 10);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            String replacement = XMLWriter.getEntity(c);
            if (replacement != null) {
                sb.append('&');
                sb.append(replacement);
                sb.append(';');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String getEntity(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }

    private static String getLineSeparator(IProject project) {
        String lineSeparator = null;
        if (Platform.isRunning()) {
            IScopeContext[] scopeContext;
            if (project != null) {
                scopeContext = new IScopeContext[]{new ProjectScope(project)};
                lineSeparator = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
                if (lineSeparator != null) {
                    return lineSeparator;
                }
            }
            scopeContext = new IScopeContext[]{new InstanceScope()};
            lineSeparator = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineSeparator != null) {
                return lineSeparator;
            }
        }
        return System.getProperty("line.separator");
    }

    private void printTab() {
        for (int i = 0; i < this.tab; ++i) {
            this.print("    ");
        }
    }

    public void print(Document d) {
        this.print(d.getDocumentElement());
    }

    public void print(Node e) {
        NodeList nodeList;
        int childSize;
        this.printTab();
        this.print('<');
        this.print(e.getNodeName());
        NamedNodeMap nnm = e.getAttributes();
        int attrSize = nnm.getLength();
        if (attrSize > 0) {
            int i;
            Node[] attr = new Node[attrSize];
            for (i = 0; i < attrSize; ++i) {
                attr[i] = nnm.item(i);
            }
            Arrays.sort(attr, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    Node n1 = (Node)o1;
                    Node n2 = (Node)o2;
                    return n1.getNodeName().compareTo(n2.getNodeName());
                }
            });
            for (i = 0; i < attrSize; ++i) {
                this.print(' ');
                this.print(attr[i].getNodeName());
                this.print("=\"");
                this.print(XMLWriter.encode(attr[i].getNodeValue()));
                this.print('\"');
            }
        }
        if ((childSize = (nodeList = e.getChildNodes()).getLength()) == 0) {
            this.print("/>");
            this.print(this.lineSeparator);
            return;
        }
        this.print(">");
        ++this.tab;
        this.print(this.lineSeparator);
        for (int i = 0; i < childSize; ++i) {
            Node n = nodeList.item(i);
            if (n.getNodeType() != 1) continue;
            this.print(n);
        }
        --this.tab;
        this.printTab();
        this.print("</");
        this.print(e.getNodeName());
        this.print(">");
        this.print(this.lineSeparator);
    }
}

