/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.ExcludeSyncModuleInfo;
import com.ibm.ws.st.core.internal.OutOfSyncModuleInfo;
import com.ibm.ws.st.core.internal.ServerExtensionWrapper;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;

public abstract class ServerExtension {
    private ServerExtensionWrapper wrapper;

    protected final void init(ServerExtensionWrapper wrapper) {
        this.wrapper = wrapper;
    }

    protected final IServer getServer() {
        return this.wrapper.getWebSphereServer().getServer();
    }

    protected final WebSphereServer getWebSphereServer() {
        return this.wrapper.getWebSphereServer();
    }

    protected final WebSphereServerInfo getWebSphereServerInfo() {
        return this.wrapper.getWebSphereServerInfo();
    }

    protected final ConfigurationFile getConfiguration() {
        return this.wrapper.getWebSphereServer().getConfiguration();
    }

    protected String getServerBaseWebURL() {
        return this.getWebSphereServer().getServerWebURL();
    }

    public abstract IModule[] getChildModules(IModule[] var1);

    public abstract IModule[] getRootModules(IModule var1) throws CoreException;

    public IStatus canAddModule(IModule module) {
        return null;
    }

    public boolean modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) {
        return false;
    }

    public URL getModuleRootURL(IModule module) {
        return null;
    }

    public boolean isPublishRequired(IModule[] modules, IResourceDelta delta) {
        return false;
    }

    public String toString() {
        return "ServerExtension [" + this.getClass().toString() + "]";
    }

    public boolean canRestartModule(IModule[] module) {
        return true;
    }

    public OutOfSyncModuleInfo checkModuleConfigOutOfSync(IModule module) {
        ConfigurationFile.Application[] apps;
        ConfigurationFile configFile = this.getConfiguration();
        for (ConfigurationFile.Application app : apps = configFile.getApplications()) {
            if (!app.getName().equals(module.getName())) continue;
            return null;
        }
        return new OutOfSyncModuleInfo(OutOfSyncModuleInfo.Type.APP_ENTRY_MISSING);
    }

    protected void handleExistingAppEntryInConfigAndDropins(IModule module, ConfigurationFile.Application[] appsInConfig) {
        if (module != null && module.getName() != null) {
            String appName = module.getName();
            WebSphereServerBehaviour serverBehaviour = this.getWebSphereServer().getWebSphereServerBehaviour();
            if (serverBehaviour == null) {
                return;
            }
            HashSet<String> ignoredConfigFileModuleNames = new HashSet<String>();
            HashMap<IModule, ExcludeSyncModuleInfo> sync = serverBehaviour.getExcludeSyncModules();
            Set<IModule> keys = sync.keySet();
            for (IModule key : keys) {
                String name;
                if (key == null || (name = key.getName()) == null) continue;
                ignoredConfigFileModuleNames.add(name);
            }
            for (ConfigurationFile.Application application : appsInConfig) {
                if (!appName.equals(application.getName())) continue;
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "Application, " + appName + " is in the configuration before add it. ");
                }
                if (ignoredConfigFileModuleNames.contains(appName)) continue;
                List<String> apps = serverBehaviour.getOverriddenAppsInServerXML();
                if (!apps.contains(appName)) {
                    apps.add(appName);
                }
                return;
            }
            for (ConfigurationFile.Application application : this.getServer().getModules()) {
                if (!application.isExternal() || !appName.equals(application.getName()) || ignoredConfigFileModuleNames.contains(appName)) continue;
                List<String> apps = serverBehaviour.getOverriddenDropinsApps();
                if (!apps.contains(appName)) {
                    apps.add(appName);
                }
                return;
            }
        }
    }

    protected boolean shouldExcludeAddingModuleToConfig(IModule module) {
        ConfigurationFile config;
        if (("LibertyMaven".equals(this.getWebSphereServer().getServerType()) || "LibertyGradle".equals(this.getWebSphereServer().getServerType())) && (config = this.getWebSphereServer().getConfiguration()) != null) {
            HashMap<String, String> map;
            HashMap<IModule, ExcludeSyncModuleInfo> excluded;
            ExcludeSyncModuleInfo info;
            ConfigurationFile.Application[] app = config.getApplications();
            for (int i = 0; i < app.length; ++i) {
                if (app[i] == null || !module.getName().equals(app[i].getName())) continue;
                return true;
            }
            WebSphereServerBehaviour behaviour = (WebSphereServerBehaviour)((Object)this.getServer().loadAdapter(WebSphereServerBehaviour.class, null));
            if (behaviour != null && (info = (excluded = behaviour.getExcludeSyncModules()).get(module)) != null && (map = info.getProperties()) != null && "dropins".equals(map.get("appsDir"))) {
                return true;
            }
        }
        return false;
    }
}

