/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.FeatureConflictHandler;
import com.ibm.ws.st.core.internal.FeatureResolverFeature;
import com.ibm.ws.st.core.internal.FeatureSet;
import com.ibm.ws.st.core.internal.IPromptActionHandler;
import com.ibm.ws.st.core.internal.IPromptIssue;
import com.ibm.ws.st.core.internal.IPromptResponse;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.ProjectPrefs;
import com.ibm.ws.st.core.internal.PromptAction;
import com.ibm.ws.st.core.internal.PromptHandler;
import com.ibm.ws.st.core.internal.PublishHelper;
import com.ibm.ws.st.core.internal.RequiredFeatureMap;
import com.ibm.ws.st.core.internal.RuntimeFeatureResolver;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;

public class RequiredFeaturePrompt
extends PromptHandler.AbstractPrompt
implements IPromptActionHandler {
    private final HashMap<String, List<String>> featureMap = new HashMap();
    private final String FEATURE_LOCAL_JMX_NO_VERSION = "localConnector";
    Map<String, RequiredFeatureIssue> issueMap = new HashMap<String, RequiredFeatureIssue>();

    @Override
    public boolean isActive() {
        return !this.issueMap.isEmpty();
    }

    @Override
    public IPromptActionHandler getActionHandler() {
        return this;
    }

    @Override
    public boolean getApplyAlways() {
        return false;
    }

    @Override
    public void prePromptAction(List<IModule[]> publishedModules, PublishHelper helper, IProgressMonitor monitor) {
        HashMap<String, List<String>> alwaysAdd;
        ConfigurationFile configFile;
        block25: {
            FeatureSet fs;
            if (publishedModules == null || publishedModules.isEmpty()) {
                return;
            }
            WebSphereServer server = helper.getWebSphereServer();
            configFile = server.getConfiguration();
            alwaysAdd = new HashMap<String, List<String>>();
            this.issueMap.clear();
            if (!this.featureMap.isEmpty()) {
                this.featureMap.clear();
            }
            if ((fs = new FeatureSet(server.getWebSphereRuntime(), configFile.getAllFeatures())).resolve("localConnector-1.0") == null) {
                configFile.addFeature("localConnector-1.0");
            }
            ArrayList<IModuleResourceDelta[]> publishedDelta = new ArrayList<IModuleResourceDelta[]>(publishedModules.size());
            for (IModule[] module : publishedModules) {
                publishedDelta.add(server.getWebSphereServerBehaviour().getPublishedResourceDelta(module));
            }
            try {
                RequiredFeatureMap rfm = server.getRequiredFeatures(configFile, publishedModules, publishedDelta, monitor);
                if (rfm == null) break block25;
                FeatureResolverFeature[] requiredFeatures = rfm.getFeatures();
                HashMap<IProject, ProjectPrefs> prefsMap = new HashMap<IProject, ProjectPrefs>();
                for (FeatureResolverFeature rf : requiredFeatures) {
                    String s = rf.getName();
                    if (s.toLowerCase().startsWith("localConnector".toLowerCase())) continue;
                    List<IModule[]> modules = rfm.getModules(rf);
                    boolean isPrefsMatched = false;
                    boolean isAlwaysPrompt = false;
                    for (IModule[] module : modules) {
                        IProject project = module[module.length - 1].getProject();
                        if (project == null) continue;
                        ProjectPrefs prefs = (ProjectPrefs)prefsMap.get(project);
                        if (prefs == null) {
                            prefs = new ProjectPrefs(project);
                            prefsMap.put(project, prefs);
                        }
                        int featurePrompt = prefs.getFeaturePrompt(s);
                        switch (featurePrompt) {
                            case 1: {
                                ArrayList<String> appList = (ArrayList<String>)alwaysAdd.get(s);
                                if (appList == null) {
                                    appList = new ArrayList<String>();
                                    alwaysAdd.put(s, appList);
                                }
                                appList.add(module[0].getName());
                            }
                            case 0: {
                                isAlwaysPrompt = !alwaysAdd.containsKey(s);
                            }
                            case 2: {
                                isPrefsMatched = true;
                            }
                        }
                    }
                    if (!isAlwaysPrompt) {
                        if (isPrefsMatched) continue;
                        ArrayList<String> appList = (ArrayList<String>)alwaysAdd.get(s);
                        if (appList == null) {
                            appList = new ArrayList<String>();
                            alwaysAdd.put(s, appList);
                        }
                        for (IModule[] module : modules) {
                            appList.add(module[0].getName());
                        }
                        continue;
                    }
                    RequiredFeatureIssue issue = this.issueMap.get(rf.getName());
                    if (issue == null) {
                        issue = new RequiredFeatureIssue(rf.getName());
                        this.issueMap.put(rf.getName(), issue);
                    }
                    for (IModule[] module : modules) {
                        issue.addApp(module[0].getName());
                    }
                }
            }
            catch (CoreException ce) {
                Trace.logError("Error getting required features", ce);
            }
        }
        if (this.issueMap.isEmpty()) {
            WebSphereServer ws = helper.getWebSphereServer();
            List<String> allFeatures = configFile.getAllFeatures();
            ArrayList<String> combinedFeatures = new ArrayList<String>(allFeatures);
            for (String feature : alwaysAdd.keySet()) {
                if (combinedFeatures.contains(feature)) continue;
                combinedFeatures.add(feature);
            }
            RuntimeFeatureResolver.ResolverResult result = RuntimeFeatureResolver.resolve(ws.getWebSphereRuntime(), combinedFeatures);
            Set<RuntimeFeatureResolver.FeatureConflict> conflicts = result.getFeatureConflicts();
            boolean ignoreConflicts = ws.shouldIgnoreConflicts(conflicts);
            FeatureConflictHandler featureConflictHandler = Activator.getFeatureConflictHandler();
            if (conflicts != null && !conflicts.isEmpty() && featureConflictHandler != null && !ignoreConflicts) {
                if (featureConflictHandler.handleFeatureConflicts(ws.getServerInfo(), alwaysAdd, conflicts, false)) {
                    helper.setConfigChanged(true);
                }
                return;
            }
        }
        for (String s : alwaysAdd.keySet()) {
            if (configFile.hasFeature(s)) continue;
            configFile.addFeature(s);
            helper.setConfigChanged(true);
        }
    }

    @Override
    public void postPromptAction(IPromptResponse response, PublishHelper helper) {
        Collection<RequiredFeatureIssue> issues = this.issueMap.values();
        HashMap<String, List<String>> featureList = new HashMap<String, List<String>>();
        for (RequiredFeatureIssue issue : issues) {
            PromptAction action = response.getSelectedAction(issue);
            if (action != PromptAction.UPDATE_SERVER_CONFIG) continue;
            featureList.put(issue.getFeatureName(), issue.getApps());
        }
        if (!featureList.isEmpty()) {
            WebSphereServer ws = helper.getWebSphereServer();
            ConfigurationFile configFile = ws.getConfiguration();
            List<String> configFeatures = configFile.getAllFeatures();
            ArrayList<String> combinedFeatures = new ArrayList<String>(configFeatures);
            for (String feature : featureList.keySet()) {
                if (combinedFeatures.contains(feature)) continue;
                combinedFeatures.add(feature);
            }
            RuntimeFeatureResolver.ResolverResult result = RuntimeFeatureResolver.resolve(ws.getWebSphereRuntime(), combinedFeatures);
            Set<RuntimeFeatureResolver.FeatureConflict> conflicts = result.getFeatureConflicts();
            boolean ignoreConflicts = ws.shouldIgnoreConflicts(conflicts);
            FeatureConflictHandler featureConflictHandler = Activator.getFeatureConflictHandler();
            if (conflicts != null && !conflicts.isEmpty() && featureConflictHandler != null && !ignoreConflicts) {
                if (featureConflictHandler.handleFeatureConflicts(ws.getServerInfo(), featureList, conflicts, false)) {
                    helper.setConfigChanged(true);
                }
            } else {
                for (String s : featureList.keySet()) {
                    if (configFile.hasFeature(s)) continue;
                    configFile.addFeature(s);
                    helper.setConfigChanged(true);
                }
            }
        }
    }

    @Override
    public IPromptIssue[] getIssues() {
        Collection<RequiredFeatureIssue> values = this.issueMap.values();
        IPromptIssue[] issues = new IPromptIssue[values.size()];
        return values.toArray(issues);
    }

    private static class RequiredFeatureIssue
    implements IPromptIssue {
        private final String featureName;
        private final List<String> appList = new ArrayList<String>(2);

        RequiredFeatureIssue(String featureName) {
            this.featureName = featureName;
        }

        @Override
        public String getType() {
            return Messages.requiredFeatureIssue;
        }

        @Override
        public String getSummary() {
            return NLS.bind((String)Messages.requiredFeatureSummary, (Object)this.featureName);
        }

        @Override
        public String getDetails() {
            StringBuilder sb = new StringBuilder();
            for (String app : this.appList) {
                sb.append("\n - ");
                sb.append(app);
            }
            return NLS.bind((String)Messages.requiredFeatureDetails, (Object[])new String[]{this.featureName, sb.toString()});
        }

        @Override
        public PromptAction[] getPossibleActions() {
            return new PromptAction[]{PromptAction.UPDATE_SERVER_CONFIG, PromptAction.IGNORE};
        }

        @Override
        public PromptAction getDefaultAction() {
            return PromptAction.UPDATE_SERVER_CONFIG;
        }

        public boolean equals(Object other) {
            if (!(other instanceof RequiredFeatureIssue)) {
                return false;
            }
            if (other == this) {
                return true;
            }
            RequiredFeatureIssue otherIssue = (RequiredFeatureIssue)other;
            return this.featureName.equals(otherIssue.featureName);
        }

        public int hashCode() {
            return this.featureName.hashCode();
        }

        public String toString() {
            return "Required feature " + this.featureName;
        }

        void addApp(String appName) {
            if (!this.appList.contains(appName)) {
                this.appList.add(appName);
            }
        }

        List<String> getApps() {
            return new ArrayList<String>(this.appList);
        }

        String getFeatureName() {
            return this.featureName;
        }
    }
}

