/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.LaunchUtil;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.UtilityLaunchFactory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.osgi.util.NLS;

public class LibertyServerDumpUtility {
    public ILaunch dumpServer(WebSphereRuntime runtime, WebSphereServerInfo server, File archiveFile, String include, IProgressMonitor monitor) throws CoreException {
        IProgressMonitor monitor2 = monitor;
        if (monitor2 == null) {
            monitor2 = new NullProgressMonitor();
        }
        this.verifyServerExists(runtime, server);
        if (archiveFile != null && archiveFile.isDirectory()) {
            throw new IllegalArgumentException(Messages.invalidZipFile);
        }
        String serverName = server.getServerName();
        monitor2.beginTask(NLS.bind((String)Messages.taskDumpServer, (Object)serverName), 200);
        WebSphereServer wsServer = WebSphereUtil.getWebSphereServer(server);
        if (wsServer == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Could not find server");
            }
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.errorPromptServerNotFound));
        }
        ILaunchConfiguration lc = null;
        try {
            ArrayList<String> command = new ArrayList<String>();
            if (wsServer.isLocalSetup()) {
                command.add("server");
                command.add("dump");
                command.add(server.getServerName());
                if (archiveFile != null) {
                    command.add("--archive=" + archiveFile.getAbsolutePath());
                }
                if (include != null && !include.trim().isEmpty()) {
                    command.add("--include=" + include);
                }
                lc = this.createUtilityLaunchConfig(runtime, server, null, command.toArray(new String[command.size()]));
            } else {
                HashMap<String, String> commandVariables = new HashMap<String, String>();
                commandVariables.put("utilityType", "dump");
                if (archiveFile != null) {
                    commandVariables.put("--archive=", archiveFile.getAbsolutePath());
                }
                if (include != null && !include.trim().isEmpty()) {
                    commandVariables.put("--include=", include);
                }
                lc = this.createRemoteUtilityLaunchConfig(runtime, server, commandVariables);
            }
            ILaunch iLaunch = lc.launch("run", monitor2);
            return iLaunch;
        }
        catch (Throwable t) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorDumpServer, (Object)t.getLocalizedMessage())));
        }
        finally {
            monitor2.done();
        }
    }

    public ILaunch javadumpServer(WebSphereRuntime runtime, WebSphereServerInfo server, String include, IProgressMonitor monitor) throws CoreException {
        IProgressMonitor monitor2 = monitor;
        if (monitor2 == null) {
            monitor2 = new NullProgressMonitor();
        }
        this.verifyServerExists(runtime, server);
        String serverName = server.getServerName();
        monitor2.beginTask(NLS.bind((String)Messages.taskDumpServer, (Object)serverName), 200);
        WebSphereServer ws = WebSphereUtil.getWebSphereServer(server);
        ILaunchConfiguration lc = null;
        try {
            ILaunch commandVariables;
            if (ws != null && ws.isLocalSetup()) {
                ArrayList<String> command = new ArrayList<String>();
                command.add("server");
                command.add("javadump");
                command.add(server.getServerName());
                if (include != null && !include.trim().isEmpty()) {
                    command.add("--include=" + include);
                }
                lc = this.createUtilityLaunchConfig(runtime, server, null, command.toArray(new String[command.size()]));
            } else {
                commandVariables = new HashMap();
                commandVariables.put("utilityType", "javadump");
                if (include != null && !include.trim().isEmpty()) {
                    commandVariables.put((String)"--include=", (String)include);
                }
                lc = this.createRemoteUtilityLaunchConfig(runtime, server, (Map<String, String>)commandVariables);
            }
            commandVariables = lc.launch("run", monitor2);
            return commandVariables;
        }
        catch (Throwable t) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorDumpServer, (Object)t.getLocalizedMessage())));
        }
        finally {
            monitor2.done();
        }
    }

    protected ILaunchConfiguration createUtilityLaunchConfig(WebSphereRuntime runtime, WebSphereServerInfo serverInfo, String jvmArgs, String ... command) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        WebSphereServer wsServer = WebSphereUtil.getWebSphereServer(serverInfo);
        String serverID = wsServer.getServer().getId();
        String launchConfigType = UtilityLaunchFactory.getLaunchConfigurationType(wsServer.getServerType());
        ILaunchConfigurationType lct = launchManager.getLaunchConfigurationType(launchConfigType);
        ILaunchConfigurationWorkingCopy wc = lct.newInstance(null, runtime.getRuntime().getName());
        wc.setAttribute("runtime", runtime.getRuntime().getId());
        wc.setAttribute("workDir", serverInfo.getServerOutputPath().toOSString());
        wc.setAttribute("userDir", runtime.getUserDirectories().indexOf(serverInfo.getUserDirectory()));
        wc.setAttribute("label", LaunchUtil.getProcessLabelAttr(serverInfo.getWebSphereRuntime().getRuntime().getName(), serverInfo.getServerName()));
        if (jvmArgs != null) {
            wc.setAttribute("jvmArgs", jvmArgs);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String s : command) {
            list.add(s);
        }
        wc.setAttribute("command", list);
        wc.setAttribute("serverID", serverID);
        return wc.doSave();
    }

    protected ILaunchConfiguration createRemoteUtilityLaunchConfig(WebSphereRuntime runtime, WebSphereServerInfo serverInfo, Map<String, String> commandVariables) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        WebSphereServer wsServer = WebSphereUtil.getWebSphereServer(serverInfo);
        String serverID = wsServer.getServer().getId();
        String launchConfigType = UtilityLaunchFactory.getLaunchConfigurationType(wsServer.getServerType());
        ILaunchConfigurationType lct = launchManager.getLaunchConfigurationType(launchConfigType);
        ILaunchConfigurationWorkingCopy wc = lct.newInstance(null, runtime.getRuntime().getName());
        wc.setAttribute("command", commandVariables);
        wc.setAttribute("serverID", serverID);
        return wc.doSave();
    }

    private void verifyServerExists(WebSphereRuntime runtime, WebSphereServerInfo server) {
        if (server == null || server.getServerName() == null) {
            throw new IllegalArgumentException("Server cannot be null");
        }
        IPath path = runtime.getRuntime().getLocation();
        if (path == null) {
            throw new IllegalArgumentException("Runtime does not exist");
        }
        if (!server.getServerPath().toFile().exists()) {
            throw new IllegalArgumentException("Server does not exist");
        }
    }
}

