/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import java.util.EnumSet;
import java.util.Properties;

public enum APIVisibility {
    API,
    IBM_API,
    SPEC,
    STABLE,
    THIRD_PARTY;


    public static EnumSet<APIVisibility> getDefaults() {
        return EnumSet.of(API, IBM_API, SPEC, STABLE);
    }

    public static EnumSet<APIVisibility> parseFromAttribute(String value) {
        EnumSet<APIVisibility> apiVisibility = EnumSet.noneOf(APIVisibility.class);
        if (value != null && value.length() > 0) {
            String[] values = value.split(",");
            for (int i = 0; i < values.length; ++i) {
                if (values[i].trim().toLowerCase().equals("api")) {
                    apiVisibility.add(API);
                }
                if (values[i].trim().toLowerCase().equals("ibm-api")) {
                    apiVisibility.add(IBM_API);
                }
                if (values[i].trim().toLowerCase().equals("spec")) {
                    apiVisibility.add(SPEC);
                }
                if (values[i].trim().toLowerCase().equals("stable")) {
                    apiVisibility.add(STABLE);
                }
                if (!values[i].trim().toLowerCase().equals("third-party")) continue;
                apiVisibility.add(THIRD_PARTY);
            }
        }
        return apiVisibility;
    }

    public static String generateAttributeValue(EnumSet<APIVisibility> apiVisibility) {
        StringBuilder stringBuilder = new StringBuilder();
        if (apiVisibility.contains((Object)API)) {
            stringBuilder.append("api");
        }
        if (apiVisibility.contains((Object)IBM_API)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append("ibm-api");
        }
        if (apiVisibility.contains((Object)SPEC)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append("spec");
        }
        if (apiVisibility.contains((Object)STABLE)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append("stable");
        }
        if (apiVisibility.contains((Object)THIRD_PARTY)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append("third-party");
        }
        return stringBuilder.toString();
    }

    public static EnumSet<APIVisibility> getAPIVisibilityFromProperties(Properties properties) {
        EnumSet<APIVisibility> apiVisibility = EnumSet.noneOf(APIVisibility.class);
        if (Boolean.parseBoolean(properties.getProperty("com.ibm.ws.st.core.api.visibility.api"))) {
            apiVisibility.add(API);
        }
        if (Boolean.parseBoolean(properties.getProperty("com.ibm.ws.st.core.api.visibility.ibmapi"))) {
            apiVisibility.add(IBM_API);
        }
        if (Boolean.parseBoolean(properties.getProperty("com.ibm.ws.st.core.api.visibility.spec"))) {
            apiVisibility.add(SPEC);
        }
        if (Boolean.parseBoolean(properties.getProperty("com.ibm.ws.st.core.api.visibility.stable"))) {
            apiVisibility.add(STABLE);
        }
        if (Boolean.parseBoolean(properties.getProperty("com.ibm.ws.st.core.api.visibility.thirdparty"))) {
            apiVisibility.add(THIRD_PARTY);
        }
        if (apiVisibility.size() == 0) {
            apiVisibility = APIVisibility.getDefaults();
        }
        return apiVisibility;
    }
}

