/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xwt.dde.internal.viewers;

import com.ibm.xwt.dde.DDEPlugin;
import com.ibm.xwt.dde.customization.ICustomIconObject;
import com.ibm.xwt.dde.internal.customization.CustomizationManager;
import com.ibm.xwt.dde.internal.customization.DetailItemCustomization;
import com.ibm.xwt.dde.internal.util.ModelUtil;
import com.ibm.xwt.dde.internal.validation.ValidationManager;
import com.ibm.xwt.dde.internal.viewers.DDEViewer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TreeLabelProvider
extends LabelProvider
implements IFontProvider {
    private static final Image DEFAULT_ELEMENT_ICON = DDEPlugin.getDefault().getImageDescriptor("icons/parameters.gif").createImage();
    private CustomizationManager.Customization customization;
    private IResource resource;
    private DDEViewer.TreeFilterProcessor treeFilterProcessor;
    private ValidationManager validationManager;

    public TreeLabelProvider(CustomizationManager.Customization customization, DDEViewer.TreeFilterProcessor treeFilterProcessor, ValidationManager validationManager, IResource resource) {
        this.customization = customization;
        this.resource = resource;
        this.treeFilterProcessor = treeFilterProcessor;
        this.validationManager = validationManager;
    }

    public Image getImage(Object element) {
        return this.getImage(element, false);
    }

    public Image getImage(Object element, boolean ignoreDecoration) {
        Image result = null;
        if (element instanceof Element) {
            Element domElement = (Element)element;
            DetailItemCustomization detailItemCustomization = this.getDetailItemCustomization(domElement);
            if (detailItemCustomization != null && detailItemCustomization.getIcon() != null) {
                result = detailItemCustomization.getIcon();
            } else if (detailItemCustomization != null && detailItemCustomization.getIconClass() != null) {
                try {
                    Object object = detailItemCustomization.getIconClass().newInstance();
                    if (object instanceof ICustomIconObject) {
                        ICustomIconObject customLabelObject = (ICustomIconObject)object;
                        result = customLabelObject.getIcon((Element)element, this.resource);
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
            } else if (this.customization != null && this.customization.getIconClass() != null) {
                try {
                    Object object = this.customization.getIconClass().newInstance();
                    if (object instanceof ICustomIconObject) {
                        ICustomIconObject customLabelObject = (ICustomIconObject)object;
                        result = customLabelObject.getIcon((Element)element, this.resource);
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
            } else {
                result = DEFAULT_ELEMENT_ICON;
            }
            if (!ignoreDecoration) {
                result = this.decorateImage(result, domElement);
            }
        }
        return result;
    }

    public String getText(Object input) {
        if (input instanceof Element) {
            Element treeNodeElement = (Element)input;
            return ModelUtil.getTreeNodeLabel(treeNodeElement, this.customization, this.resource);
        }
        return "";
    }

    private DetailItemCustomization getDetailItemCustomization(Element element) {
        DetailItemCustomization itemCustomization = null;
        if (this.customization != null) {
            ModelQuery modelQuery;
            String path = ModelUtil.getElementFullPath(element);
            String elementNamespace = ModelUtil.getNodeNamespace(element);
            itemCustomization = this.customization.getItemCustomization(elementNamespace, path);
            if (itemCustomization == null && (modelQuery = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument())) != null) {
                CMElementDeclaration cmElementDeclaration = modelQuery.getCMElementDeclaration(element);
                itemCustomization = this.customization.getTypeCustomizationConsideringUnions((CMNode)cmElementDeclaration, path);
            }
        }
        return itemCustomization;
    }

    public Font getFont(Object element) {
        Element domElement;
        if (element instanceof Element && this.treeFilterProcessor.isMatchedElement(domElement = (Element)element)) {
            return DDEPlugin.getDefault().FONT_DEFAULT_BOLD;
        }
        return null;
    }

    private Image decorateImage(Image image, Element element) {
        ImageDescriptor decoratorImageDescriptor = null;
        int decoration = 0;
        if (this.validationManager.getMessageManager().getTreeNodeMessageCount(element, 1, false) > 0) {
            decoration = 3;
        } else if (this.validationManager.getMessageManager().getTreeNodeMessageCount(element, 0, false) > 0) {
            decoration = 2;
        }
        switch (decoration) {
            case 0: {
                return image;
            }
            case 2: {
                decoratorImageDescriptor = DDEPlugin.getDefault().getImageDescriptor("icons/warning_overlay.gif");
                break;
            }
            case 3: {
                decoratorImageDescriptor = DDEPlugin.getDefault().getImageDescriptor("icons/error_overlay.gif");
                break;
            }
            case 4: {
                decoratorImageDescriptor = DDEPlugin.getDefault().getImageDescriptor("icons/error_fix_overlay.gif");
            }
        }
        String imageCode = image.hashCode() + "-" + decoration;
        Image decoratedImage = DDEPlugin.getDefault().getImageFromRegistry(imageCode);
        if (decoratedImage == null) {
            DecorationOverlayIcon decorationOverlayIcon = new DecorationOverlayIcon(image, decoratorImageDescriptor, 2);
            decoratedImage = decorationOverlayIcon.createImage();
            DDEPlugin.getDefault().getImageRegistry().put(imageCode, decoratedImage);
        }
        return decoratedImage;
    }
}

