/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.docker.ui.internal.wizard;

import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.docker.ui.internal.Trace;
import com.ibm.ws.st.docker.ui.internal.wizard.LibertyDockerComposite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.util.SocketUtil;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class LibertyRemoteDockerWizardFragment
extends WizardFragment {
    protected LibertyDockerComposite comp;

    public boolean hasComposite() {
        boolean isDockerType = "LibertyDocker".equals(this.getTaskModel().getObject("com.ibm.ws.st.ui.serverTypeData"));
        return isDockerType && !this.isLocalhost();
    }

    public Composite createComposite(Composite parent, IWizardHandle wizard) {
        this.comp = new LibertyDockerComposite(parent, wizard, this.getTaskModel());
        return this.comp;
    }

    public void enter() {
        if (!this.hasComposite()) {
            return;
        }
        if (this.comp != null) {
            this.comp.setup(this.getTaskModel());
            this.comp.clearMessage();
            this.comp.initialValidate();
        } else {
            IServerWorkingCopy wc = (IServerWorkingCopy)this.getTaskModel().getObject("server");
            WebSphereServer server = (WebSphereServer)wc.getAdapter(WebSphereServer.class);
            server.setDefaults((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void exit() {
        if (!this.hasComposite()) {
            return;
        }
        if (this.comp != null) {
            this.comp.clearContainers();
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        if (this.hasComposite() && this.comp != null && !this.comp.isDisposed()) {
            this.comp.performFinish(monitor);
        }
    }

    public void performCancel(IProgressMonitor monitor) {
        if (this.hasComposite() && this.comp != null && !this.comp.isDisposed()) {
            this.comp.performCancel();
        }
    }

    public boolean isComplete() {
        boolean isComplete = true;
        isComplete = this.hasComposite() && this.comp != null && !this.comp.isDisposed() ? this.comp.isComplete() : !this.hasComposite();
        return isComplete && super.isComplete();
    }

    protected boolean isLocalhost() {
        IServerWorkingCopy swc = (IServerWorkingCopy)this.getTaskModel().getObject("server");
        String host = swc.getHost();
        if (host != null) {
            return SocketUtil.isLocalhost((String)host);
        }
        Trace.logError("The value for host in the server task model is null", new Exception("Host value is null"));
        return true;
    }
}

