/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.docker.ui.internal;

import com.ibm.ws.st.docker.ui.internal.Trace;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.ws.st.docker.ui";
    private static Activator instance;
    protected Map<String, ImageDescriptor> imageDescriptors = new HashMap<String, ImageDescriptor>();
    private static URL ICON_BASE_URL;
    private static final String URL_WIZBAN = "wizban/";
    public static final String IMG_WIZ_SERVER = "wizServer";
    public static final String SERVER_TYPE = "LibertyDocker";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        Trace.ENABLED = this.isDebugging();
        Hashtable<String, String> props = new Hashtable<String, String>(4);
        props.put("listener.symbolic.name", PLUGIN_ID);
        context.registerService(DebugOptionsListener.class.getName(), (Object)Trace.TS, props);
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        super.stop(context);
    }

    public static Activator getInstance() {
        return instance;
    }

    private void registerImage(ImageRegistry registry, String key, String partialURL) {
        block2: {
            try {
                ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(ICON_BASE_URL, partialURL));
                registry.put(key, id);
                this.imageDescriptors.put(key, id);
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block2;
                Trace.trace((byte)1, "Error registering image", e);
            }
        }
    }

    protected ImageRegistry createImageRegistry() {
        ImageRegistry registry = new ImageRegistry();
        if (ICON_BASE_URL == null) {
            ICON_BASE_URL = instance.getBundle().getEntry("icons/");
        }
        this.registerImage(registry, IMG_WIZ_SERVER, "wizban/liberty-server-banner.png");
        return registry;
    }

    public static Image getImage(String key) {
        return Activator.getInstance().getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        try {
            Activator.getInstance().getImageRegistry();
            return Activator.getInstance().imageDescriptors.get(key);
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Missing image", e);
            }
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }
}

