/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.utility;

import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.SWTUtil;
import com.ibm.ws.st.ui.internal.utility.UtilityWizardPage;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DumpWizardPage
extends UtilityWizardPage {
    private static final String PREF_DUMP_TYPE = "dump.type";
    public static final String PREF_SERVER_PATH = "dump.server.path";
    private static final String PREF_SERVER_OVERWRITE = "dump.server.overwrite";
    private static final String PREF_SERVER_INCLUDE = "dump.server.include";
    private static final String PREF_JVM_INCLUDE = "dump.jvm.include";
    private static final String[] INCLUDE_OPTIONS = new String[]{"heap", "system", "thread"};
    private static final int SERVER_NUM_INCLUDE_OPTIONS = 3;
    private static final int JVM_NUM_INCLUDE_OPTIONS = 2;
    protected boolean isServerDump = true;
    protected String serverExportPath;
    protected boolean serverOverwrite;
    protected boolean[] serverInclude;
    protected boolean[] jvmInclude;

    public DumpWizardPage(WebSphereServerInfo server) {
        super(server);
        this.setTitle(Messages.wizDumpTitle);
        this.setDescription(Messages.wizDumpDescription);
    }

    @Override
    public void createUtilityControl(Composite comp) {
        if ("8.5.0.0".equals(this.wsRuntime.getRuntimeVersion())) {
            return;
        }
        final Button serverDumpButton = new Button(comp, 16);
        serverDumpButton.setText(Messages.wizDumpServer);
        GridData data = new GridData(1, 0x1000000, false, false);
        data.horizontalSpan = 3;
        data.verticalIndent = 5;
        serverDumpButton.setLayoutData((Object)data);
        int INDENT = 18;
        final Label serverIncludeLabel = new Label(comp, 0);
        serverIncludeLabel.setText(Messages.wizDumpInclude);
        data = new GridData(1, 0x1000000, false, false);
        data.horizontalIndent = INDENT;
        serverIncludeLabel.setLayoutData((Object)data);
        Composite serverIncludeComp = new Composite(comp, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 15;
        layout.horizontalSpacing = 8;
        serverIncludeComp.setLayout((Layout)layout);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        serverIncludeComp.setLayoutData((Object)data);
        this.serverInclude = new boolean[3];
        String[] serverIncludeLabels = new String[]{Messages.wizDumpServerIncludeHeap, Messages.wizDumpServerIncludeSystem, Messages.wizDumpServerIncludeThread};
        String serverIncludePref = Activator.getPreference(PREF_SERVER_INCLUDE, null);
        final Button[] serverIncludeButtons = new Button[3];
        for (int i = 0; i < 3; ++i) {
            serverIncludeButtons[i] = new Button(serverIncludeComp, 32);
            serverIncludeButtons[i].setText(serverIncludeLabels[i]);
            serverIncludeButtons[i].setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            if (serverIncludePref != null && serverIncludePref.contains(INCLUDE_OPTIONS[i])) {
                this.serverInclude[i] = true;
                serverIncludeButtons[i].setSelection(true);
            }
            final int ii = i;
            serverIncludeButtons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    DumpWizardPage.this.serverInclude[ii] = serverIncludeButtons[ii].getSelection();
                }
            });
        }
        final Group serverArchiveGroup = new Group(comp, 0);
        serverArchiveGroup.setText(Messages.wizPackageExport);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        serverArchiveGroup.setLayout((Layout)layout);
        data = new GridData(4, 128, true, false);
        data.horizontalSpan = 3;
        data.horizontalIndent = INDENT;
        serverArchiveGroup.setLayoutData((Object)data);
        final Combo serverFolder = new Combo((Composite)serverArchiveGroup, 0);
        data = new GridData(4, 0x1000000, true, false);
        serverFolder.setLayoutData((Object)data);
        List<String> previousLocations = Activator.getPreferenceList(PREF_SERVER_PATH);
        if (previousLocations != null && previousLocations.size() > 0) {
            serverFolder.setItems(previousLocations.toArray(new String[previousLocations.size()]));
            serverFolder.select(0);
            this.serverExportPath = previousLocations.get(0);
        }
        serverFolder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DumpWizardPage.this.serverExportPath = serverFolder.getText();
                DumpWizardPage.this.setPageComplete(DumpWizardPage.this.validate());
            }
        });
        final Button serverBrowse = SWTUtil.createButton((Composite)serverArchiveGroup, Messages.browse);
        serverBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                FileDialog dialog = new FileDialog(DumpWizardPage.this.getShell(), 8196);
                dialog.setFilterExtensions(new String[]{"*.zip"});
                dialog.setFileName(serverFolder.getText());
                String file = dialog.open();
                if (file != null) {
                    serverFolder.setText(file);
                }
            }
        });
        final Button serverOverwriteButton = new Button((Composite)serverArchiveGroup, 32);
        serverOverwriteButton.setText(Messages.wizPackageOverwrite);
        data = new GridData(1, 0x1000000, false, false);
        data.horizontalSpan = 2;
        serverOverwriteButton.setLayoutData((Object)data);
        String serverOverwritePref = Activator.getPreference(PREF_SERVER_OVERWRITE, null);
        if ("true".equals(serverOverwritePref)) {
            serverOverwriteButton.setSelection(true);
            this.serverOverwrite = true;
        }
        serverOverwriteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DumpWizardPage.this.serverOverwrite = serverOverwriteButton.getSelection();
            }
        });
        Button jvmDumpButton = new Button(comp, 16);
        jvmDumpButton.setText(Messages.wizDumpJVM);
        data = new GridData(1, 0x1000000, false, false);
        data.horizontalSpan = 3;
        data.verticalIndent = 5;
        jvmDumpButton.setLayoutData((Object)data);
        final Label jvmIncludeLabel = new Label(comp, 0);
        jvmIncludeLabel.setText(Messages.wizDumpInclude);
        data = new GridData(1, 0x1000000, false, false);
        data.horizontalIndent = INDENT;
        jvmIncludeLabel.setLayoutData((Object)data);
        Composite jvmIncludeComp = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 15;
        layout.horizontalSpacing = 8;
        jvmIncludeComp.setLayout((Layout)layout);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        jvmIncludeComp.setLayoutData((Object)data);
        String jvmIncludePref = Activator.getPreference(PREF_JVM_INCLUDE, null);
        this.jvmInclude = new boolean[2];
        String[] jvmIncludeOptionsText = new String[]{Messages.wizDumpJVMIncludeHeap, Messages.wizDumpJVMIncludeSystem};
        final Button[] jvmIncludeButtons = new Button[2];
        for (int i = 0; i < 2; ++i) {
            jvmIncludeButtons[i] = new Button(jvmIncludeComp, 32);
            jvmIncludeButtons[i].setText(jvmIncludeOptionsText[i]);
            jvmIncludeButtons[i].setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            if (jvmIncludePref != null && jvmIncludePref.contains(INCLUDE_OPTIONS[i])) {
                this.jvmInclude[i] = true;
                jvmIncludeButtons[i].setSelection(true);
            }
            final int ii = i;
            jvmIncludeButtons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    DumpWizardPage.this.jvmInclude[ii] = jvmIncludeButtons[ii].getSelection();
                }
            });
        }
        String prefDumpType = Activator.getPreference(PREF_DUMP_TYPE, null);
        if (prefDumpType != null && "false".equals(prefDumpType)) {
            serverDumpButton.setSelection(false);
            jvmDumpButton.setSelection(true);
        }
        this.isServerDump = serverDumpButton.getSelection();
        serverIncludeLabel.setEnabled(this.isServerDump);
        serverIncludeButtons[0].setEnabled(this.isServerDump);
        serverIncludeButtons[1].setEnabled(this.isServerDump);
        serverIncludeButtons[2].setEnabled(this.isServerDump);
        serverArchiveGroup.setEnabled(this.isServerDump);
        serverFolder.setEnabled(this.isServerDump);
        serverBrowse.setEnabled(this.isServerDump);
        serverOverwriteButton.setEnabled(this.isServerDump);
        jvmIncludeLabel.setEnabled(!this.isServerDump);
        jvmIncludeButtons[0].setEnabled(!this.isServerDump);
        jvmIncludeButtons[1].setEnabled(!this.isServerDump);
        serverDumpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DumpWizardPage.this.isServerDump = serverDumpButton.getSelection();
                serverIncludeLabel.setEnabled(DumpWizardPage.this.isServerDump);
                serverIncludeButtons[0].setEnabled(DumpWizardPage.this.isServerDump);
                serverIncludeButtons[1].setEnabled(DumpWizardPage.this.isServerDump);
                serverIncludeButtons[2].setEnabled(DumpWizardPage.this.isServerDump);
                serverArchiveGroup.setEnabled(DumpWizardPage.this.isServerDump);
                serverFolder.setEnabled(DumpWizardPage.this.isServerDump);
                serverBrowse.setEnabled(DumpWizardPage.this.isServerDump);
                serverOverwriteButton.setEnabled(DumpWizardPage.this.isServerDump);
                jvmIncludeLabel.setEnabled(!DumpWizardPage.this.isServerDump);
                jvmIncludeButtons[0].setEnabled(!DumpWizardPage.this.isServerDump);
                jvmIncludeButtons[1].setEnabled(!DumpWizardPage.this.isServerDump);
            }
        });
    }

    @Override
    protected String getUserMessage() {
        return Messages.wizDumpMessage;
    }

    @Override
    public boolean preFinish() {
        File f;
        if (!this.isServerDump) {
            return true;
        }
        if (this.serverExportPath == null || this.serverExportPath.trim().isEmpty()) {
            return true;
        }
        if (!this.serverExportPath.endsWith(".zip") && !this.serverExportPath.endsWith(".jar")) {
            this.serverExportPath = this.serverExportPath + ".zip";
        }
        return !(f = new File(this.serverExportPath)).exists() || this.serverOverwrite || MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.wizPackageTitle, (String)NLS.bind((String)Messages.wizPackageFileExists, (Object)this.serverExportPath));
    }

    @Override
    public void finish(IProgressMonitor monitor) throws Exception {
        String serverIncludeStr = null;
        String jvmIncludeStr = null;
        if (this.serverInclude != null) {
            int i;
            Activator.setPreference(PREF_DUMP_TYPE, String.valueOf(this.isServerDump));
            Activator.addToPreferenceList(PREF_SERVER_PATH, this.serverExportPath);
            Activator.setPreference(PREF_SERVER_OVERWRITE, this.serverOverwrite ? "true" : "false");
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < 3; ++i) {
                if (!this.serverInclude[i]) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(INCLUDE_OPTIONS[i]);
            }
            if (sb.length() > 0) {
                serverIncludeStr = sb.toString();
            }
            Activator.setPreference(PREF_SERVER_INCLUDE, serverIncludeStr);
            sb = new StringBuilder();
            for (i = 0; i < 2; ++i) {
                if (!this.jvmInclude[i]) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(INCLUDE_OPTIONS[i]);
            }
            if (sb.length() > 0) {
                jvmIncludeStr = sb.toString();
            }
            Activator.setPreference(PREF_JVM_INCLUDE, jvmIncludeStr);
        }
        if (this.isServerDump) {
            File archiveFile = null;
            if (this.serverExportPath != null && !this.serverExportPath.trim().isEmpty()) {
                archiveFile = new File(this.serverExportPath);
            }
            this.wsRuntime.dumpServer(this.server, archiveFile, serverIncludeStr, monitor);
        } else {
            this.wsRuntime.javadumpServer(this.server, jvmIncludeStr, monitor);
        }
    }
}

