/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SearchPattern;

public class FileSelectorDialog
extends TitleAreaDialog {
    private static final String SEPARATOR = ", ";
    protected String dialogTitle;
    protected String dialogLabel;
    protected String dialogMessage;
    protected String path;
    protected String filter = "";
    protected SearchPattern pattern = new SearchPattern(35);
    protected Table table;
    protected String fileList;
    protected boolean isOK = false;

    public FileSelectorDialog(Shell parent, String path, String title, String label, String message) {
        super(parent);
        this.path = path;
        this.dialogTitle = title;
        this.dialogLabel = label;
        this.dialogMessage = message;
    }

    public void setInitialFilter(String filter) {
        this.filter = filter;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.dialogTitle);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.dialogLabel);
        this.setTitleImage(Activator.getImage("wizServer"));
        this.setMessage(this.dialogMessage);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.table = new Table(composite, 2818);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        data.widthHint = data.heightHint = 256;
        this.table.setLayoutData((Object)data);
        this.table.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FileSelectorDialog.this.updateOKButton();
            }
        });
        this.table.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                FileSelectorDialog.this.okPressed();
                FileSelectorDialog.this.close();
            }
        });
        Label entryLabel = new Label(composite, 0);
        entryLabel.setText(Messages.fileSelectorFilter);
        data = new GridData(4, 2, false, false);
        entryLabel.setLayoutData((Object)data);
        final Text entryText = new Text(composite, 2048);
        data = new GridData(4, 4, true, false);
        entryText.setText(this.filter);
        entryText.setLayoutData((Object)data);
        entryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String text = entryText.getText();
                FileSelectorDialog.this.filter = text == null ? "" : text;
                FileSelectorDialog.this.initTableItems();
                FileSelectorDialog.this.updateOKButton();
            }
        });
        this.initTableItems();
        return composite;
    }

    protected void initTableItems() {
        this.table.removeAll();
        File[] files = null;
        if (this.path != null) {
            File file = new File(this.path);
            this.pattern.setPattern(this.filter);
            files = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return !file.isDirectory() && FileSelectorDialog.this.pattern.matches(file.getName());
                }
            });
        }
        if (files == null) {
            return;
        }
        Arrays.sort(files);
        for (void var5_5 : files) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(var5_5.getName());
            item.setData((Object)var5_5);
        }
    }

    protected void saveFileList() {
        StringBuilder builder = new StringBuilder();
        boolean start = true;
        for (TableItem item : this.table.getSelection()) {
            if (!start) {
                builder.append(SEPARATOR);
            } else {
                start = false;
            }
            builder.append(item.getText());
        }
        this.fileList = start ? null : builder.toString();
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.updateOKButton();
        return control;
    }

    protected void updateOKButton() {
        this.getButton(0).setEnabled(this.table.getSelectionCount() > 0);
    }

    protected void okPressed() {
        this.saveFileList();
        this.isOK = true;
        super.okPressed();
    }

    public boolean isOK() {
        return this.isOK;
    }

    public String getFileList() {
        return this.fileList;
    }
}

