/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.config.FeatureList;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.config.FeatureUI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FeatureSelectionDialog
extends TitleAreaDialog {
    protected WebSphereRuntime wsRuntime;
    protected String elemName;
    protected List<String> possibleFeatures;
    protected Table featureTable;
    protected Text descriptionLabel;
    protected Text enablesLabel;
    protected Text enabledByLabel;
    protected List<String> selectedFeatures;
    protected String title;
    protected String message;
    protected String explanation;

    public FeatureSelectionDialog(Shell parent, WebSphereRuntime wsRuntime, String elemName, List<String> possibleFeatures, String title, String message, String explanation) {
        super(parent);
        this.elemName = elemName;
        this.possibleFeatures = possibleFeatures;
        this.wsRuntime = wsRuntime;
        this.title = title;
        this.message = message;
        this.explanation = explanation;
        this.setTitleImage(Activator.getImage("wizServer"));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.title);
        this.setMessage(this.message);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 64);
        label.setText(NLS.bind((String)this.explanation, (Object)this.elemName));
        data = new GridData(1, 2, true, false);
        label.setLayoutData((Object)data);
        this.featureTable = new Table(composite, 68128);
        data = new GridData(4, 4, true, true);
        data.heightHint = 100;
        this.featureTable.setLayoutData((Object)data);
        FeatureUI.createColumns(this.featureTable);
        for (String s : this.possibleFeatures) {
            TableItem item = new TableItem(this.featureTable, 0);
            item.setText(0, s);
            String name = FeatureList.getFeatureDisplayName((String)s, (WebSphereRuntime)this.wsRuntime);
            if (name != null) {
                item.setText(1, name);
            }
            item.setImage(Activator.getImage("featureElement"));
        }
        if (this.possibleFeatures.size() == 1) {
            this.featureTable.getItem(0).setChecked(true);
        }
        FeatureUI.resizeColumns(this.featureTable);
        ScrolledComposite descriptionScroll = new ScrolledComposite(composite, 512);
        this.descriptionLabel = new Text((Composite)descriptionScroll, 72);
        this.descriptionLabel.setText(NLS.bind((String)Messages.featureDescription, (Object)""));
        this.descriptionLabel.setBackground(parent.getBackground());
        descriptionScroll.setContent((Control)this.descriptionLabel);
        this.enablesLabel = new Text(composite, 8);
        this.enablesLabel.setText(NLS.bind((String)Messages.featureEnables, (Object)""));
        this.enablesLabel.setBackground(parent.getBackground());
        this.enablesLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        data = new GridData(4, 4, true, false);
        int lineHeight = this.enablesLabel.computeSize((int)-1, (int)-1).y;
        data.heightHint = lineHeight * 4;
        this.descriptionLabel.setSize(300, lineHeight);
        this.descriptionLabel.setEnabled(false);
        descriptionScroll.setLayoutData((Object)data);
        descriptionScroll.getVerticalBar().setPageIncrement(lineHeight);
        descriptionScroll.getVerticalBar().setIncrement(lineHeight);
        this.enabledByLabel = new Text(composite, 8);
        this.enabledByLabel.setText(NLS.bind((String)Messages.featureEnabledBy, (Object)""));
        this.enabledByLabel.setBackground(parent.getBackground());
        this.enabledByLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        this.featureTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FeatureSelectionDialog.this.enableOKButton();
                FeatureUI.updateInfo(FeatureSelectionDialog.this.enablesLabel, FeatureSelectionDialog.this.enabledByLabel, FeatureSelectionDialog.this.descriptionLabel, FeatureSelectionDialog.this.featureTable, null, FeatureSelectionDialog.this.wsRuntime);
            }
        });
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.featureTable.setFocus();
        this.enableOKButton();
        return control;
    }

    public void create() {
        super.create();
        FeatureUI.updateInfo(this.enablesLabel, this.enabledByLabel, this.descriptionLabel, this.featureTable, null, this.wsRuntime);
        this.descriptionLabel.setSize(this.descriptionLabel.computeSize(-1, -1));
    }

    protected void enableOKButton() {
        boolean enable = false;
        for (TableItem item : this.featureTable.getItems()) {
            if (!item.getChecked()) continue;
            enable = true;
            break;
        }
        this.getButton(0).setEnabled(enable);
    }

    protected void okPressed() {
        this.selectedFeatures = new ArrayList<String>();
        for (TableItem item : this.featureTable.getItems()) {
            if (!item.getChecked()) continue;
            this.selectedFeatures.add(item.getText());
        }
        super.okPressed();
    }

    public List<String> getSelectedFeatures() {
        return this.selectedFeatures;
    }
}

