/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.IWebSphereMetadataListener;
import com.ibm.ws.st.core.internal.ServerListenerUtil;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.core.internal.config.FeatureList;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.config.BaseCustomObject;
import com.ibm.ws.st.ui.internal.config.ConfigUIUtils;
import com.ibm.ws.st.ui.internal.config.FeatureUI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.server.core.IRuntime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FeatureCustomObject
extends BaseCustomObject {
    protected static final String GRAYED = "grayed_table_item";
    protected static final String SAVE_SHOW_IMPLICIT = "save_show_implicit_features";
    protected static final String PREFERENCES_IMPLICIT_FEATURES = "ImplicitFeatures";
    protected WebSphereRuntime wsRuntime;

    public void createCustomControl(final Element input, String itemName, Composite parent, IEditorPart editorPart, EventListener listener) {
        assert (itemName.equals("feature"));
        this.wsRuntime = ConfigUIUtils.getRuntime(editorPart);
        final Shell shell = parent.getShell();
        boolean showImplicit = false;
        Object obj = input.getUserData(SAVE_SHOW_IMPLICIT);
        showImplicit = obj != null && obj instanceof Boolean ? (Boolean)obj : Activator.getPreferenceBoolean(PREFERENCES_IMPLICIT_FEATURES, false);
        final HashMap<String, Node> featureMap = new HashMap<String, Node>();
        NodeList featureNodes = input.getElementsByTagName("feature");
        for (int i = 0; i < featureNodes.getLength(); ++i) {
            Node node = featureNodes.item(i);
            String name = DOMUtils.getTextContent((Node)node);
            if (name == null) continue;
            featureMap.put(name, node);
        }
        TabbedPropertySheetWidgetFactory widgetFactory = new TabbedPropertySheetWidgetFactory();
        this.setLabelVerticalAlign(parent, 1);
        Composite composite = widgetFactory.createComposite(parent, 0x800000);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        final Table featureTable = widgetFactory.createTable(composite, 65538);
        data = new GridData(4, 4, true, false);
        data.heightHint = featureTable.getItemHeight() * 8;
        data.horizontalIndent = 1;
        data.verticalIndent = 2;
        data.verticalSpan = 2;
        featureTable.setLayoutData((Object)data);
        FeatureUI.createColumns(featureTable);
        this.createItems(featureTable, featureMap.keySet(), showImplicit);
        FeatureUI.resizeColumns(featureTable);
        Button addButton = widgetFactory.createButton(composite, Messages.addButton, 8);
        data = new GridData(4, 1, false, false);
        addButton.setLayoutData((Object)data);
        final Button removeButton = widgetFactory.createButton(composite, Messages.removeButton, 8);
        data = new GridData(4, 1, false, false);
        removeButton.setLayoutData((Object)data);
        int borderStyle = widgetFactory.getBorderStyle();
        widgetFactory.setBorderStyle(0);
        final Text descriptionLabel = widgetFactory.createText(composite, NLS.bind((String)Messages.featureDescription, (Object)""), 8);
        descriptionLabel.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
        data = new GridData(4, 1, true, false);
        data.horizontalSpan = 2;
        descriptionLabel.setLayoutData((Object)data);
        final Text enablesLabel = widgetFactory.createText(composite, NLS.bind((String)Messages.featureEnables, (Object)""), 8);
        enablesLabel.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
        data = new GridData(4, 1, true, false);
        data.horizontalSpan = 2;
        enablesLabel.setLayoutData((Object)data);
        final Text enabledByLabel = widgetFactory.createText(composite, NLS.bind((String)Messages.featureEnabledBy, (Object)""), 8);
        enabledByLabel.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
        data = new GridData(4, 1, true, false);
        data.horizontalSpan = 2;
        enabledByLabel.setLayoutData((Object)data);
        widgetFactory.setBorderStyle(borderStyle);
        final Button showImplicitButton = widgetFactory.createButton(composite, Messages.featureShowImplicit, 32);
        showImplicitButton.setForeground(widgetFactory.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        data = new GridData(4, 1, false, false);
        data.horizontalIndent = 2;
        data.horizontalSpan = 2;
        showImplicitButton.setLayoutData((Object)data);
        featureTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FeatureCustomObject.this.updateRemoveButton(removeButton, featureTable);
                FeatureUI.updateInfo(enablesLabel, enabledByLabel, descriptionLabel, featureTable, featureMap.keySet(), FeatureCustomObject.this.wsRuntime);
            }
        });
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeSet<String> runtimeFeatures = new TreeSet<String>(new Comparator<String>(){

                    @Override
                    public int compare(String str1, String str2) {
                        return str1.compareToIgnoreCase(str2);
                    }
                });
                runtimeFeatures.addAll(FeatureList.getRuntimeFeatureSet((WebSphereRuntime)FeatureCustomObject.this.wsRuntime));
                TreeSet<String> configuredFeatures = new TreeSet<String>(new Comparator<String>(){

                    @Override
                    public int compare(String str1, String str2) {
                        return str1.compareToIgnoreCase(str2);
                    }
                });
                configuredFeatures.addAll(featureMap.keySet());
                FeatureUI.AddDialog dialog = new FeatureUI.AddDialog(shell, runtimeFeatures, configuredFeatures, FeatureCustomObject.this.wsRuntime);
                if (dialog.open() == 0) {
                    Set<String> newFeatures = dialog.getFeatures();
                    for (String feature : newFeatures) {
                        FeatureCustomObject.this.addNode(feature, input, featureMap);
                    }
                    FeatureCustomObject.this.createItems(featureTable, featureMap.keySet(), showImplicitButton.getSelection());
                    FeatureCustomObject.this.updateRemoveButton(removeButton, featureTable);
                    FeatureUI.updateInfo(enablesLabel, enabledByLabel, descriptionLabel, featureTable, featureMap.keySet(), FeatureCustomObject.this.wsRuntime);
                }
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                for (TableItem item : items = featureTable.getSelection()) {
                    FeatureCustomObject.this.removeNode(item.getText(), input, featureMap);
                }
                FeatureCustomObject.this.createItems(featureTable, featureMap.keySet(), showImplicitButton.getSelection());
                FeatureCustomObject.this.updateRemoveButton(removeButton, featureTable);
                FeatureUI.updateInfo(enablesLabel, enabledByLabel, descriptionLabel, featureTable, featureMap.keySet(), FeatureCustomObject.this.wsRuntime);
            }
        });
        showImplicitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean showImplicit = showImplicitButton.getSelection();
                Activator.setPreferenceBoolean(FeatureCustomObject.PREFERENCES_IMPLICIT_FEATURES, showImplicit);
                FeatureCustomObject.this.createItems(featureTable, featureMap.keySet(), showImplicit);
                input.setUserData(FeatureCustomObject.SAVE_SHOW_IMPLICIT, showImplicit ? Boolean.TRUE : Boolean.FALSE, null);
                FeatureCustomObject.this.updateRemoveButton(removeButton, featureTable);
                FeatureUI.updateInfo(enablesLabel, enabledByLabel, descriptionLabel, featureTable, featureMap.keySet(), FeatureCustomObject.this.wsRuntime);
            }
        });
        final IEclipsePreferences.IPreferenceChangeListener prefListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                boolean newSelection;
                Object newValue;
                if (FeatureCustomObject.PREFERENCES_IMPLICIT_FEATURES.equals(event.getKey()) && (newValue = event.getNewValue()) != null && (newSelection = Boolean.parseBoolean((String)newValue)) != showImplicitButton.getSelection()) {
                    showImplicitButton.setSelection(newSelection);
                }
            }
        };
        Activator.addPreferenceChangeListener(prefListener);
        showImplicitButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                Activator.removePreferenceChangeListener(prefListener);
            }
        });
        final IWebSphereMetadataListener metadataListener = new IWebSphereMetadataListener(){

            public void runtimeMetadataChanged(IRuntime runtime) {
                if (FeatureCustomObject.this.wsRuntime == null || !runtime.equals(FeatureCustomObject.this.wsRuntime.getRuntime())) {
                    return;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        HashSet<String> features = new HashSet<String>();
                        for (TableItem item : featureTable.getSelection()) {
                            features.add(item.getText(0));
                        }
                        FeatureCustomObject.this.createItems(featureTable, featureMap.keySet(), showImplicitButton.getSelection());
                        ArrayList<TableItem> selectedItems = new ArrayList<TableItem>();
                        for (TableItem item : featureTable.getItems()) {
                            if (!features.contains(item.getText(0))) continue;
                            selectedItems.add(item);
                        }
                        featureTable.setSelection(selectedItems.toArray(new TableItem[selectedItems.size()]));
                        FeatureUI.updateInfo(enablesLabel, enabledByLabel, descriptionLabel, featureTable, featureMap.keySet(), FeatureCustomObject.this.wsRuntime);
                    }
                });
            }
        };
        ServerListenerUtil.getInstance().addMetadataListener(metadataListener);
        featureTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                ServerListenerUtil.getInstance().removeMetadataListener(metadataListener);
            }
        });
        addButton.setEnabled(!this.getReadOnly());
        removeButton.setEnabled(false);
        FeatureUI.updateInfo(enablesLabel, enabledByLabel, descriptionLabel, featureTable, featureMap.keySet(), this.wsRuntime);
        showImplicitButton.setSelection(showImplicit);
    }

    protected void createItems(Table table, Set<String> features, boolean showImplicit) {
        ArrayList<String> featureList = new ArrayList<String>(features.size());
        if (showImplicit) {
            Set<String> allFeatures = this.getAllFeatures(features);
            featureList.addAll(allFeatures);
        } else {
            featureList.addAll(features);
        }
        Collections.sort(featureList);
        table.removeAll();
        Color gray = table.getShell().getDisplay().getSystemColor(16);
        for (String feature : featureList) {
            TableItem item = new TableItem(table, 0);
            item.setText(0, feature);
            String name = FeatureList.getFeatureDisplayName((String)feature, (WebSphereRuntime)this.wsRuntime);
            if (name != null) {
                item.setText(1, name);
            }
            if (FeatureList.isValidFeature((String)feature, (WebSphereRuntime)this.wsRuntime)) {
                if (FeatureList.isFeatureSuperseded((String)feature, (WebSphereRuntime)this.wsRuntime)) {
                    item.setImage(Activator.getImage("featureSuperseded"));
                } else {
                    item.setImage(Activator.getImage("featureElement"));
                }
                if (FeatureList.containsIgnoreCase(features, (String)feature)) continue;
                item.setForeground(gray);
                item.setData(GRAYED, (Object)Boolean.TRUE);
                continue;
            }
            item.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        }
    }

    protected void updateRemoveButton(Button removeButton, Table featureTable) {
        TableItem[] items = featureTable.getSelection();
        removeButton.setEnabled(!this.getReadOnly() && items.length > 0 && !this.containsGrayed(items));
    }

    protected boolean containsGrayed(TableItem[] items) {
        for (TableItem item : items) {
            Object grayed = item.getData(GRAYED);
            if (grayed == null || !(grayed instanceof Boolean) || !((Boolean)grayed).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected Set<String> getAllFeatures(Set<String> explicitFeatures) {
        TreeSet<String> allFeatures = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                return str1.compareToIgnoreCase(str2);
            }
        });
        allFeatures.addAll(explicitFeatures);
        for (String feature : explicitFeatures) {
            allFeatures.addAll(FeatureList.getFeatureChildren((String)feature, (WebSphereRuntime)this.wsRuntime));
        }
        return allFeatures;
    }

    protected void addNode(String feature, Element parent, HashMap<String, Node> featureMap) {
        Document document = parent.getOwnerDocument();
        org.w3c.dom.Text beforeText = document.createTextNode(featureMap.isEmpty() ? "\n\t\t" : "\t");
        parent.appendChild(beforeText);
        Element elem = document.createElement("feature");
        org.w3c.dom.Text text = document.createTextNode(feature);
        elem.appendChild(text);
        parent.appendChild(elem);
        org.w3c.dom.Text afterText = document.createTextNode("\n\t");
        parent.appendChild(afterText);
        featureMap.put(feature, elem);
    }

    protected void removeNode(String feature, Element parent, HashMap<String, Node> featureMap) {
        Node node = featureMap.get(feature);
        featureMap.remove(feature);
        Node beforeText = node.getPreviousSibling();
        while (beforeText != null && beforeText.getNodeType() == 3) {
            Node tmpText = beforeText.getPreviousSibling();
            parent.removeChild(beforeText);
            beforeText = tmpText;
        }
        if (featureMap.isEmpty()) {
            Node afterText = node.getNextSibling();
            while (afterText != null && afterText.getNodeType() == 3) {
                Node tmpText = afterText.getNextSibling();
                parent.removeChild(afterText);
                afterText = tmpText;
            }
        }
        parent.removeChild(node);
    }
}

