/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.provisional.dialogs.PasswordDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Element;

public class AddSecurityElementsDialog
extends TitleAreaDialog {
    protected WebSphereRuntime wsRuntime;
    protected ConfigurationFile configFile;
    protected boolean appSecurityEnabled;
    protected Text keystorePassText;
    protected Button addUserRegistryButton;
    protected Text userNameText;
    protected Text userPasswordText;

    public AddSecurityElementsDialog(Shell parent, WebSphereRuntime wsRuntime, ConfigurationFile configFile, boolean appSecurityEnabled) {
        super(parent);
        this.wsRuntime = wsRuntime;
        this.configFile = configFile;
        this.appSecurityEnabled = appSecurityEnabled;
        this.setTitleImage(Activator.getImage("wizServer"));
    }

    public AddSecurityElementsDialog(Shell parent, WebSphereServerInfo serverInfo, boolean appSecurityEnabled) {
        super(parent);
        this.wsRuntime = serverInfo.getWebSphereRuntime();
        this.configFile = serverInfo.getConfigRoot();
        this.appSecurityEnabled = appSecurityEnabled;
        this.setTitleImage(Activator.getImage("wizServer"));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.addRequiredElementsLabel);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        if (this.appSecurityEnabled) {
            this.setTitle(Messages.addSecurityElementsTitle);
            this.setMessage(Messages.addSecurityElementsDescription);
        } else {
            this.setTitle(Messages.addKeystoreElementTitle);
            this.setMessage(Messages.addKeystoreElementDescription);
        }
        final Shell shell = parent.getShell();
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        label.setText(Messages.addKeystoreElementPasswordLabel);
        data = new GridData(1, 2, false, false);
        data.widthHint = 130;
        label.setLayoutData((Object)data);
        this.keystorePassText = new Text(composite, 0x400800);
        data = new GridData(4, 4, true, false);
        this.keystorePassText.setLayoutData((Object)data);
        Button keystorePasswordSetButton = new Button(composite, 8);
        keystorePasswordSetButton.setText(Messages.keyStorePasswordSetButton);
        data = new GridData(4, 4, false, false);
        keystorePasswordSetButton.setLayoutData((Object)data);
        this.keystorePassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AddSecurityElementsDialog.this.validate();
            }
        });
        keystorePasswordSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String password;
                PasswordDialog dialog = new PasswordDialog(shell, false, AddSecurityElementsDialog.this.wsRuntime);
                if (dialog.open() == 0 && (password = dialog.getEncodedPassword()) != null) {
                    AddSecurityElementsDialog.this.keystorePassText.setText(password);
                    AddSecurityElementsDialog.this.validate();
                }
            }
        });
        if (this.appSecurityEnabled) {
            this.addUserRegistryButton = new Button(composite, 32);
            this.addUserRegistryButton.setText(Messages.addUserRegistryButton);
            data = new GridData(1, 4, false, false);
            data.horizontalSpan = 3;
            data.verticalIndent = 5;
            this.addUserRegistryButton.setLayoutData((Object)data);
            final Composite userRegistryComposite = new Composite(composite, 0);
            layout = new GridLayout();
            layout.marginHeight = 11;
            layout.marginWidth = 0;
            layout.horizontalSpacing = 5;
            layout.verticalSpacing = 7;
            layout.numColumns = 3;
            userRegistryComposite.setLayout((Layout)layout);
            data = new GridData(4, 4, true, false);
            data.horizontalSpan = 3;
            data.horizontalIndent = 50;
            userRegistryComposite.setLayoutData((Object)data);
            userRegistryComposite.setFont(composite.getFont());
            label = new Label(userRegistryComposite, 0);
            label.setText(Messages.addUserRegistryName);
            data = new GridData(1, 2, false, false);
            data.widthHint = 80;
            label.setLayoutData((Object)data);
            this.userNameText = new Text(userRegistryComposite, 2048);
            data = new GridData(4, 4, true, false);
            this.userNameText.setLayoutData((Object)data);
            Label dummy = new Label(userRegistryComposite, 0);
            dummy.getAlignment();
            label = new Label(userRegistryComposite, 0);
            label.setText(Messages.addUserRegistryPassword);
            data.widthHint = 80;
            data = new GridData(1, 2, false, false);
            label.setLayoutData((Object)data);
            this.userPasswordText = new Text(userRegistryComposite, 0x400800);
            data = new GridData(4, 4, true, false);
            this.userPasswordText.setLayoutData((Object)data);
            Button userPasswordSetButton = new Button(userRegistryComposite, 8);
            userPasswordSetButton.setText(Messages.basicUserRegistrySetButton);
            data = new GridData(4, 4, false, false);
            userPasswordSetButton.setLayoutData((Object)data);
            this.addUserRegistryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AddSecurityElementsDialog.this.setCompositeEnabled(userRegistryComposite, AddSecurityElementsDialog.this.addUserRegistryButton.getSelection());
                    AddSecurityElementsDialog.this.validate();
                }
            });
            this.userNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    AddSecurityElementsDialog.this.validate();
                }
            });
            this.userPasswordText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    AddSecurityElementsDialog.this.validate();
                }
            });
            userPasswordSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String password;
                    PasswordDialog dialog = new PasswordDialog(shell, false, AddSecurityElementsDialog.this.wsRuntime);
                    if (dialog.open() == 0 && (password = dialog.getEncodedPassword()) != null) {
                        AddSecurityElementsDialog.this.userPasswordText.setText(password);
                        AddSecurityElementsDialog.this.validate();
                    }
                }
            });
            this.addUserRegistryButton.setSelection(true);
            this.setCompositeEnabled(userRegistryComposite, true);
        }
        this.keystorePassText.setFocus();
        return composite;
    }

    protected void setCompositeEnabled(Composite composite, boolean enabled) {
        for (Control control : composite.getChildren()) {
            if (control instanceof Composite) {
                this.setCompositeEnabled((Composite)control, enabled);
                continue;
            }
            control.setEnabled(enabled);
        }
        composite.setEnabled(enabled);
    }

    void validate() {
        Button okButton;
        boolean valid = true;
        String password = this.keystorePassText.getText();
        if (password == null || password.isEmpty()) {
            valid = false;
        }
        if (this.appSecurityEnabled && this.addUserRegistryButton.getSelection()) {
            String userName = this.userNameText.getText();
            String userPassword = this.userPasswordText.getText();
            if (userName == null || userName.isEmpty() || userPassword == null || userPassword.isEmpty()) {
                valid = false;
            }
        }
        if ((okButton = this.getButton(0)) != null) {
            okButton.setEnabled(valid);
        }
    }

    public void create() {
        super.create();
        this.validate();
    }

    protected void okPressed() {
        String password = this.keystorePassText.getText();
        Element elem = this.configFile.addElement("keyStore");
        elem.setAttribute("id", "defaultKeyStore");
        elem.setAttribute("password", password);
        if (this.appSecurityEnabled && this.addUserRegistryButton.getSelection()) {
            elem = this.configFile.addElement("basicRegistry");
            elem.setAttribute("id", "basic");
            elem.setAttribute("realm", "BasicRealm");
            Element userElem = this.configFile.addElement(elem, "user");
            userElem.setAttribute("name", this.userNameText.getText());
            userElem.setAttribute("password", this.userPasswordText.getText());
        }
        super.okPressed();
    }
}

