/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.RuntimeExplorer;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.wizard.NewServerNameWizardFragment;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class NewWebSphereServerAction
extends SelectionProviderAction {
    private final Shell shell;
    private IRuntime runtime;
    private UserDirectory userDirectory;

    public NewWebSphereServerAction(ISelectionProvider selectionProvider, Shell shell) {
        super(selectionProvider, Messages.actionNewWebSphereServer);
        this.shell = shell;
        this.setImageDescriptor(Activator.getImageDescriptor("server"));
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.size() != 1) {
            this.setEnabled(false);
            return;
        }
        for (Object obj : sel) {
            if (obj instanceof IRuntime) {
                this.runtime = (IRuntime)obj;
                this.userDirectory = null;
                continue;
            }
            if (obj instanceof UserDirectory) {
                this.userDirectory = (UserDirectory)obj;
                this.runtime = this.userDirectory.getWebSphereRuntime().getRuntime();
                continue;
            }
            if (obj instanceof RuntimeExplorer.Node) {
                RuntimeExplorer.Node node = (RuntimeExplorer.Node)obj;
                this.runtime = node.getRuntime();
                this.userDirectory = node.getUserDirectory();
                continue;
            }
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public void run() {
        if (this.runtime == null) {
            return;
        }
        try {
            WebSphereServerInfo server;
            TaskModel taskModel = new TaskModel();
            taskModel.putObject("runtime", (Object)this.runtime);
            taskModel.putObject("userDirectory", (Object)this.userDirectory);
            TaskWizard wizard = new TaskWizard(Messages.wizServerNameTitle, (WizardFragment)new NewServerNameWizardFragment(), taskModel);
            WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard);
            if (dialog.open() == 1) {
                return;
            }
            String newServerName = (String)taskModel.getObject("serverName");
            WebSphereRuntime wsRuntime = (WebSphereRuntime)this.runtime.loadAdapter(WebSphereRuntime.class, null);
            if (this.userDirectory == null) {
                List userDirs;
                this.userDirectory = wsRuntime.getDefaultUserDir();
                if (this.userDirectory == null && (userDirs = wsRuntime.getUserDirectories()).size() > 0) {
                    this.userDirectory = (UserDirectory)userDirs.get(0);
                }
            }
            if ((server = wsRuntime.getServerInfo(newServerName, this.userDirectory)) != null) {
                this.getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)server));
            }
        }
        catch (Exception e) {
            Trace.logError("Error creating WebSphere server", e);
        }
    }
}

