/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.repository.IProduct;
import com.ibm.ws.st.core.internal.repository.IRuntimeInfo;
import com.ibm.ws.st.core.internal.repository.License;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.download.AddonUtil;
import com.ibm.ws.st.ui.internal.download.DownloadHelper;
import com.ibm.ws.st.ui.internal.download.DownloadUI;
import com.ibm.ws.st.ui.internal.download.LocalProduct;
import com.ibm.ws.st.ui.internal.download.ProductHelper;
import com.ibm.ws.st.ui.internal.download.SiteHelper;
import com.ibm.ws.st.ui.internal.wizard.WebSphereRuntimeWizardFragment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class RuntimeDropAdapter
extends CommonDropAdapterAssistant {
    private static final String RUNTIME_MARKER = "wlp/lib/versions/WebSphereApplicationServer.properties";
    private static final String OPEN_RUNTIME_MARKER = "wlp/lib/versions/openliberty.properties";
    private String filename;
    private IRuntime runtime;

    public boolean isSupportedType(TransferData transferData) {
        return FileTransfer.getInstance().isSupportedType(transferData);
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferData) {
        Object obj;
        this.runtime = null;
        if (target instanceof IRuntime) {
            this.runtime = (IRuntime)target;
            IRuntimeType runtimeType = this.runtime.getRuntimeType();
            if (this.runtime.getLocation() == null || runtimeType == null || !runtimeType.getId().startsWith("com.ibm.ws.st.runtime")) {
                return Status.CANCEL_STATUS;
            }
        }
        if (this.isSupportedType(transferData) && (obj = FileTransfer.getInstance().nativeToJava(transferData)) != null && obj instanceof String[]) {
            String[] files = (String[])obj;
            if (files.length != 1) {
                return Status.CANCEL_STATUS;
            }
            this.filename = files[0];
            if (this.filename == null) {
                return Status.CANCEL_STATUS;
            }
            File f = new File(this.filename);
            if (f.isDirectory() ? this.runtime == null && WebSphereRuntime.isValidLocation((IPath)new Path(this.filename)) : this.filename.toLowerCase().endsWith(".jar") || this.filename.toLowerCase().endsWith(".zip") || this.filename.toLowerCase().endsWith(".esa")) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        final Shell shell = this.getShell();
        shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    RuntimeDropAdapter.this.handleDropImpl();
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)shell, (String)Messages.title, (String)e.getLocalizedMessage());
                }
            }
        });
        return Status.OK_STATUS;
    }

    public void handleDropImpl() {
        try {
            File f = new File(this.filename);
            if (f.isDirectory()) {
                this.handleRuntimeFolder();
                return;
            }
            IStatus status = this.handleFile();
            if (status != Status.OK_STATUS) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.title, (String)status.getMessage());
            }
        }
        catch (Exception e) {
            Trace.logError("Could not handle runtime/add-on drop", e);
        }
    }

    protected void openNewRuntimeWizard() throws CoreException {
        IRuntimeType rt = ServerCore.findRuntimeType((String)"com.ibm.ws.st.runtime.wlp");
        IRuntimeWorkingCopy wc = rt.createRuntime(null, null);
        TaskModel taskModel = new TaskModel();
        File f = new File(this.filename);
        if (f.isDirectory()) {
            wc.setLocation((IPath)new Path(this.filename));
        } else {
            taskModel.putObject("archive_source", (Object)this.filename);
        }
        taskModel.putObject("runtime", (Object)wc);
        WizardFragment fragment = new WizardFragment(){

            protected void createChildFragments(List<WizardFragment> list) {
                list.add(new WebSphereRuntimeWizardFragment());
                list.add(WizardTaskUtil.SaveRuntimeFragment);
            }
        };
        TaskWizard wizard = new TaskWizard(Messages.title, fragment, taskModel);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
    }

    protected void handleRuntimeFolder() throws CoreException {
        Path path = new Path(this.filename);
        WebSphereRuntime[] wrts = WebSphereUtil.getWebSphereRuntimes();
        if (wrts.length > 0) {
            for (WebSphereRuntime wrt : wrts) {
                IRuntime rt = wrt.getRuntime();
                if (rt == null || !path.toPortableString().equalsIgnoreCase(rt.getLocation().toPortableString())) continue;
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.title, (String)NLS.bind((String)Messages.errorRuntimeLocationMapped, (Object[])new String[]{path.toOSString(), rt.getName()}));
                return;
            }
        }
        this.openNewRuntimeWizard();
    }

    protected IStatus handleFile() throws CoreException {
        if (this.runtime == null) {
            if (RuntimeDropAdapter.isLibertyArchive(new File(this.filename))) {
                this.openNewRuntimeWizard();
                return Status.OK_STATUS;
            }
            if (SiteHelper.downloadAndInstallSupported() && RuntimeDropAdapter.isAddonArchive(this.filename)) {
                return new Status(4, "com.ibm.ws.st.ui", Messages.errorRuntimeRequired, null);
            }
            return new Status(4, "com.ibm.ws.st.ui", Messages.errorUnknownDrop, null);
        }
        if (SiteHelper.downloadAndInstallSupported() && RuntimeDropAdapter.isAddonArchive(this.filename)) {
            return this.handleAddOn();
        }
        return new Status(4, "com.ibm.ws.st.ui", Messages.errorUnknownDrop, null);
    }

    private IStatus handleAddOn() {
        HashMap<String, Object> map;
        block4: {
            IRuntimeInfo core = DownloadHelper.getRuntimeCore(this.runtime);
            LocalProduct product = LocalProduct.create(this.filename);
            IStatus status = ProductHelper.isApplicableTo(product, core);
            if (status != Status.OK_STATUS) {
                return status;
            }
            map = new HashMap<String, Object>();
            ArrayList<String> archiveList = new ArrayList<String>();
            ArrayList<LocalProduct> selectedList = new ArrayList<LocalProduct>(4);
            selectedList.add(product);
            archiveList.add(this.filename);
            map.put("folder", this.runtime.getLocation().toOSString());
            map.put("runtimeTypeId", this.runtime.getRuntimeType().getId());
            map.put("archives", archiveList);
            map.put("selectedDownloaders", selectedList);
            try {
                License license = product.getLicense(null);
                if (license != null) {
                    Map<IProduct, License> licenseMap = AddonUtil.createLicenseMap();
                    map.put("license", licenseMap);
                    licenseMap.put(product, license);
                }
            }
            catch (IOException e) {
                if (!Trace.ENABLED) break block4;
                Trace.trace((byte)1, "Could not get license", e);
            }
        }
        TaskModel taskModel = new TaskModel();
        taskModel.putObject("runtime", (Object)this.runtime);
        taskModel.putObject("addonMap", map);
        DownloadUI.launchAddonsDialog(this.getShell(), taskModel);
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isLibertyArchive(File archiveFile) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(archiveFile);
            boolean bl = RuntimeDropAdapter.getRuntimeMarker(zipFile) != null;
            return bl;
        }
        catch (IOException e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Problem reading archive: " + archiveFile, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static ZipEntry getRuntimeMarker(ZipFile zipFile) {
        ZipEntry entry = zipFile.getEntry(RUNTIME_MARKER);
        if (entry != null) {
            return entry;
        }
        entry = zipFile.getEntry(OPEN_RUNTIME_MARKER);
        return entry;
    }

    protected static boolean isAddonArchive(String filePath) {
        LocalProduct product = LocalProduct.create(filePath);
        if (product == null) {
            return false;
        }
        IProduct.Type type = product.getType();
        return type != IProduct.Type.UNKNOWN && type != IProduct.Type.INSTALL && type != IProduct.Type.CONFIG_SNIPPET && type != IProduct.Type.IFIX;
    }
}

