/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.core.internal.IPromptIssue;
import com.ibm.ws.st.core.internal.IPromptResponse;
import com.ibm.ws.st.core.internal.PromptAction;
import com.ibm.ws.st.core.internal.PromptHandler;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.PromptResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PromptDialog
extends TitleAreaDialog {
    protected String message;
    protected PromptHandler.AbstractPrompt[] prompts;
    protected PromptResponse response = new PromptResponse();
    protected boolean[] alwaysApply;
    protected int style;
    protected Table issueTable;
    protected Button alwaysButton;
    protected IPromptIssue currentIssue = null;
    private boolean isCancelPressed = false;
    protected boolean isUpdating = false;
    protected final List<TableEditor> editors = new ArrayList<TableEditor>(4);

    public PromptDialog(Shell parentShell, String message, PromptHandler.AbstractPrompt[] prompts, int style) {
        super(parentShell);
        this.message = message;
        this.prompts = prompts;
        this.setTitleImage(Activator.getImage("wizServer"));
        this.setHelpAvailable((style & 0x10) != 0);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.title);
        this.setShellStyle(16);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.wizPromptMessage);
        this.setMessage(this.message);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 7;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 64);
        label.setText(Messages.wizPromptLabel);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.issueTable = new Table(composite, 68096);
        data = new GridData(4, 1, true, false);
        data.heightHint = 200;
        data.verticalSpan = 3;
        data.horizontalSpan = 2;
        this.issueTable.setLayoutData((Object)data);
        this.issueTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PromptDialog.this.releaseEditors();
            }
        });
        final TableColumn issueColumn = new TableColumn(this.issueTable, 0);
        issueColumn.setText(Messages.wizPromptIssueColumn);
        issueColumn.setResizable(true);
        issueColumn.setWidth(200);
        issueColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PromptDialog.this.sortTable(PromptDialog.this.issueTable, issueColumn);
            }
        });
        final TableColumn descColumn = new TableColumn(this.issueTable, 64);
        descColumn.setText(Messages.wizPromptDescriptionColumn);
        descColumn.setResizable(true);
        descColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PromptDialog.this.sortTable(PromptDialog.this.issueTable, descColumn);
            }
        });
        TableColumn actionColumn = new TableColumn(this.issueTable, 0);
        actionColumn.setText(Messages.wizPromptActionColumn);
        actionColumn.setResizable(true);
        actionColumn.setWidth(180);
        this.issueTable.setHeaderVisible(true);
        this.issueTable.setLinesVisible(false);
        this.issueTable.setSortDirection(128);
        this.issueTable.setSortColumn(issueColumn);
        this.alwaysButton = new Button(composite, 32);
        this.alwaysButton.setText(Messages.wizPromptAlways);
        data = new GridData(36);
        this.alwaysButton.setLayoutData((Object)data);
        this.alwaysButton.setEnabled(false);
        this.alwaysButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!PromptDialog.this.isUpdating && PromptDialog.this.currentIssue != null) {
                    PromptDialog.this.response.putApplyAlways(PromptDialog.this.currentIssue, PromptDialog.this.alwaysButton.getSelection());
                }
            }
        });
        this.init();
        this.issueTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] ti = PromptDialog.this.issueTable.getSelection();
                if (ti == null || ti.length != 1) {
                    return;
                }
                PromptDialog.this.currentIssue = (IPromptIssue)ti[0].getData();
                PromptDialog.this.isUpdating = true;
                if (PromptDialog.this.response.isEnableApplyAlways(PromptDialog.this.currentIssue)) {
                    PromptDialog.this.alwaysButton.setEnabled(true);
                    PromptDialog.this.alwaysButton.setSelection(PromptDialog.this.response.getApplyAlways(PromptDialog.this.currentIssue));
                } else {
                    PromptDialog.this.alwaysButton.setEnabled(false);
                }
                PromptDialog.this.isUpdating = false;
            }
        });
        final Composite comp = composite;
        comp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = comp.getClientArea();
                Point preferredSize = PromptDialog.this.issueTable.computeSize(-1, 100);
                int width = area.width - 2 * PromptDialog.this.issueTable.getBorderWidth() - 15;
                if (preferredSize.y > area.height + PromptDialog.this.issueTable.getHeaderHeight()) {
                    Point vBarSize = PromptDialog.this.issueTable.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point actualSize = PromptDialog.this.issueTable.getSize();
                if (actualSize.x > area.width) {
                    if (width / 4 < 220) {
                        PromptDialog.this.issueTable.getColumn(0).setWidth(width / 4);
                        PromptDialog.this.issueTable.getColumn(2).setWidth(width / 4);
                    } else {
                        PromptDialog.this.issueTable.getColumn(0).setWidth(220);
                        PromptDialog.this.issueTable.getColumn(2).setWidth(180);
                    }
                    PromptDialog.this.issueTable.getColumn(1).setWidth(width - PromptDialog.this.issueTable.getColumn(0).getWidth() - PromptDialog.this.issueTable.getColumn(2).getWidth());
                    PromptDialog.this.issueTable.setSize(area.width, area.height);
                } else {
                    PromptDialog.this.issueTable.setSize(area.width, area.height);
                    if (width / 4 < 220) {
                        PromptDialog.this.issueTable.getColumn(0).setWidth(width / 4);
                        PromptDialog.this.issueTable.getColumn(2).setWidth(width / 4);
                    } else {
                        PromptDialog.this.issueTable.getColumn(0).setWidth(220);
                        PromptDialog.this.issueTable.getColumn(2).setWidth(180);
                    }
                    PromptDialog.this.issueTable.getColumn(1).setWidth(width - PromptDialog.this.issueTable.getColumn(0).getWidth() - PromptDialog.this.issueTable.getColumn(2).getWidth());
                }
            }
        });
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public IPromptResponse getResponses() {
        return this.isCancelPressed ? null : this.response;
    }

    void init() {
        if (this.prompts == null || this.prompts.length == 0) {
            return;
        }
        ArrayList<IPromptIssue> issueList = new ArrayList<IPromptIssue>();
        for (PromptHandler.AbstractPrompt prompt : this.prompts) {
            IPromptIssue[] issues = prompt.getIssues();
            if (issues == null || issues.length == 0) continue;
            for (IPromptIssue issue : issues) {
                issueList.add(issue);
                this.response.putSelectionAction(issue, issue.getDefaultAction());
                if (!prompt.getApplyAlways()) continue;
                this.response.putApplyAlways(issue, false);
            }
        }
        this.sortIssueList(issueList, 0, -1);
        this.initTable(issueList);
    }

    private void initTable(List<IPromptIssue> issues) {
        TableItem[] items;
        Control[] children = this.issueTable.getChildren();
        for (Control child : children) {
            child.dispose();
        }
        this.releaseEditors();
        this.issueTable.removeAll();
        for (IPromptIssue issue : issues) {
            TableItem item = new TableItem(this.issueTable, 0);
            item.setData((Object)issue);
            item.setText(0, issue.getType());
        }
        int descColWidth = 620;
        for (TableItem item : items = this.issueTable.getItems()) {
            final IPromptIssue issue = (IPromptIssue)item.getData();
            TableEditor editor = new TableEditor(this.issueTable);
            Composite composite = new Composite((Composite)this.issueTable, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setBackground(this.issueTable.getBackground());
            StyledText label = new StyledText(composite, 8);
            label.setText(issue.getSummary());
            label.setBackground(this.issueTable.getBackground());
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            label.pack();
            final Link link = new Link(composite, 0);
            link.setText("(<a>" + Messages.wizPromptDetailsLabel + "</a>)");
            link.setLayoutData((Object)new GridData(4, 1, false, false));
            link.setBackground(this.issueTable.getBackground());
            link.pack();
            final DefaultToolTip toolTipDelayed = new DefaultToolTip((Control)link, 1, true);
            toolTipDelayed.setText(issue.getDetails());
            toolTipDelayed.setHideDelay(5000);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Point size = link.getSize();
                    toolTipDelayed.show(new Point(30, size.y));
                }
            });
            editor.grabHorizontal = true;
            editor.setEditor((Control)composite, item, 1);
            descColWidth = Math.min(descColWidth, label.getSize().x + link.getSize().x + 5);
            this.editors.add(editor);
            editor = new TableEditor(this.issueTable);
            final CCombo combo = new CCombo((Composite)this.issueTable, 0x800008);
            combo.setBackground(this.issueTable.getBackground());
            final PromptAction[] actions = issue.getPossibleActions();
            PromptAction defaultAction = this.response.getSelectedAction(issue);
            int i = 0;
            int selectedActionIndex = 0;
            for (PromptAction action : actions) {
                combo.add(action.toString());
                if (action == defaultAction) {
                    selectedActionIndex = i;
                    continue;
                }
                ++i;
            }
            combo.select(selectedActionIndex);
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    int c = combo.getSelectionIndex();
                    PromptDialog.this.response.putSelectionAction(issue, actions[c]);
                    PromptDialog.this.currentIssue = issue;
                    PromptDialog.this.isUpdating = true;
                    if (PromptDialog.this.response.isEnableApplyAlways(issue)) {
                        PromptDialog.this.alwaysButton.setEnabled(true);
                        PromptDialog.this.alwaysButton.setSelection(PromptDialog.this.response.getApplyAlways(issue));
                    } else {
                        PromptDialog.this.alwaysButton.setEnabled(false);
                    }
                    PromptDialog.this.isUpdating = false;
                }
            });
            editor.grabHorizontal = true;
            editor.setEditor((Control)combo, item, 2);
            this.editors.add(editor);
        }
        this.issueTable.getColumn(1).setWidth(descColWidth);
    }

    void sortTable(Table table, TableColumn column) {
        TableItem[] items = table.getItems();
        ArrayList<IPromptIssue> issueList = new ArrayList<IPromptIssue>(items.length);
        int dir = table.getSortDirection() == 1024 ? 1 : -1;
        TableColumn currentColumn = table.getSortColumn();
        int columnNum = 0;
        for (int j = 0; j < table.getColumnCount(); ++j) {
            if (!table.getColumn(j).equals(column)) continue;
            columnNum = j;
            break;
        }
        dir = column.equals(currentColumn) ? -dir : 1;
        for (TableItem item : items) {
            issueList.add((IPromptIssue)item.getData());
        }
        this.sortIssueList(issueList, columnNum, dir);
        table.setSortDirection(dir == 1 ? 1024 : 128);
        table.setSortColumn(column);
        this.initTable(issueList);
    }

    protected void sortIssueList(List<IPromptIssue> issueList, final int columnNum, int dir) {
        if (dir == 1) {
            Collections.sort(issueList, new Comparator<IPromptIssue>(){

                @Override
                public int compare(IPromptIssue p1, IPromptIssue p2) {
                    if (columnNum == 0) {
                        return p2.getType().compareTo(p1.getType());
                    }
                    if (columnNum == 1) {
                        return p2.getSummary().compareTo(p1.getSummary());
                    }
                    return 0;
                }
            });
        } else {
            Collections.sort(issueList, new Comparator<IPromptIssue>(){

                @Override
                public int compare(IPromptIssue p1, IPromptIssue p2) {
                    if (columnNum == 0) {
                        return p1.getType().compareTo(p2.getType());
                    }
                    if (columnNum == 1) {
                        return p1.getSummary().compareTo(p2.getSummary());
                    }
                    return 0;
                }
            });
        }
    }

    protected void releaseEditors() {
        for (TableEditor editor : this.editors) {
            editor.dispose();
        }
        this.editors.clear();
    }

    protected void cancelPressed() {
        this.isCancelPressed = true;
        super.cancelPressed();
    }
}

