/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.docker.core.internal.launch;

import com.ibm.ws.st.common.core.ext.internal.UnsupportedServiceException;
import com.ibm.ws.st.common.core.ext.internal.servertype.AbstractServerExtension;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.IPlatformHandler;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.PlatformHandlerFactory;
import com.ibm.ws.st.common.core.ext.internal.util.BaseDockerContainer;
import com.ibm.ws.st.common.core.ext.internal.util.FileUtil;
import com.ibm.ws.st.core.internal.IPromptResponse;
import com.ibm.ws.st.core.internal.PromptAction;
import com.ibm.ws.st.core.internal.PromptHandler;
import com.ibm.ws.st.core.internal.PromptUtil;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.docker.core.internal.AbstractServerCleanupHandler;
import com.ibm.ws.st.docker.core.internal.Activator;
import com.ibm.ws.st.docker.core.internal.Messages;
import com.ibm.ws.st.docker.core.internal.NewContainerPrompt;
import com.ibm.ws.st.docker.core.internal.Trace;
import com.ibm.ws.st.docker.core.internal.launch.LibertyDockerRunUtility;
import com.ibm.ws.st.docker.core.internal.launch.LibertyDockerServerBehaviour;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.util.SocketUtil;

public class LibertyDockerServer
extends AbstractServerExtension {
    private static final String IS_USER_CONTAINER_KEY = "isUserContainer";
    private static final String CURRENT_MODE_KEY = "currentMode";
    private static final String CONTAINER_NAME_KEY = "containerName";
    private static final String CURRENT_LOOSE_CONFIG_MODE = "looseCfg";
    private static final String ADDITIONAL_VOLUMES = "additionalVolumes";
    private static final String MANDATORY_VOLUMES = "mandatoryVolumes";
    private static final String RUN_PROPERTIES_FILE = "dockerRun.properties";
    private Properties runProperties = null;
    private long runPropertiesTimestamp = 0L;

    public String[] getServiceInfoKeys() {
        return new String[]{"hostname", "osName", "dockerMachineType", "dockerMachine", "dockerContainer", "dockerImage", "LibertyRuntimeInstallPath", "libertyServerName", "libertyServerConfigPath", "logonMethod", CURRENT_LOOSE_CONFIG_MODE, "sshKey", "osUser", "osPassword", "debugPort"};
    }

    public void cleanup(IServer server) {
        WebSphereServer wsServer = this.getWebSphereServer(server);
        if (wsServer != null && !this.isUserContainer(wsServer)) {
            BaseDockerContainer container = null;
            String containerName = "unknown";
            try {
                container = this.getContainer(wsServer);
                if (container != null) {
                    containerName = container.getContainerName();
                    AbstractServerCleanupHandler handler = Activator.getServerCleanupHandler();
                    if (handler != null) {
                        handler.handleServerDelete(container, this.loadRunProperties(wsServer));
                    }
                }
            }
            catch (Exception e) {
                Trace.logError("Could not get base url for container: " + containerName, e);
            }
        }
        super.cleanup(server);
    }

    public String getServerDisplayName(IServer server) {
        WebSphereServer wsServer = this.getWebSphereServer(server);
        BaseDockerContainer container = null;
        String containerName = "unknown";
        if (wsServer != null) {
            try {
                container = this.getContainer(wsServer);
                if (container != null) {
                    containerName = container.getContainerName();
                    String machineName = container.getDockerMachine().getMachineName();
                    if (machineName != null) {
                        return NLS.bind((String)Messages.dockerServerDisplayName, (Object[])new String[]{container.getContainerName(), machineName});
                    }
                    return container.getContainerName();
                }
            }
            catch (Exception e) {
                Trace.logError("Could not display server name for container: " + containerName, e);
            }
            return wsServer.getServerName();
        }
        return null;
    }

    public String getBaseURL(IServer server, int port) {
        int mappedPort = -1;
        String mappedHost = null;
        BaseDockerContainer container = null;
        String containerName = "unknown";
        try {
            container = this.getContainer(server);
            if (container != null) {
                containerName = container.getContainerName();
                String portMapping = container.getPortMapping(Integer.toString(port));
                String portString = BaseDockerContainer.getPortFromMapping((String)portMapping);
                if (SocketUtil.isLocalhost((String)server.getHost()) && (mappedHost = BaseDockerContainer.getHostFromMapping((String)portMapping)) == null) {
                    mappedHost = container.getDockerMachine().getHost();
                }
                mappedPort = Integer.parseInt(portString);
            }
        }
        catch (Exception e) {
            Trace.logError("Could not get base url for container: " + containerName, e);
        }
        if (mappedHost == null) {
            mappedHost = server.getHost();
        }
        if (mappedPort == -1) {
            mappedPort = port;
        }
        if (Trace.ENABLED) {
            String name = container != null ? container.getContainerName() : "unknown";
            Trace.trace((byte)0, "The " + name + " container port  " + port + " mapped to host " + mappedHost + " and port " + mappedPort);
        }
        return super.getBaseURL(server, mappedHost, mappedPort);
    }

    public boolean requiresRemoteStartSettings(IServer server) {
        return false;
    }

    public boolean isUserContainer(WebSphereServer server) {
        Properties properties = this.loadRunProperties(server);
        String isUserContainer = properties.getProperty(IS_USER_CONTAINER_KEY);
        return Boolean.parseBoolean(isUserContainer);
    }

    public boolean getCurrentLooseConfigMode(WebSphereServer server) {
        Properties properties = this.loadRunProperties(server);
        String isLooseConfigContainer = properties.getProperty(CURRENT_LOOSE_CONFIG_MODE);
        return Boolean.parseBoolean(isLooseConfigContainer);
    }

    public String getCurrentMode(WebSphereServer server) {
        Properties properties = this.loadRunProperties(server);
        return properties.getProperty(CURRENT_MODE_KEY);
    }

    public String getContainerName(WebSphereServer server) {
        Properties properties = this.loadRunProperties(server);
        return properties.getProperty(CONTAINER_NAME_KEY);
    }

    public void setLooseConfigEnabled(boolean isLooseConfig, WebSphereServer server) {
        Properties properties = this.loadRunProperties(server);
        properties.setProperty(CURRENT_LOOSE_CONFIG_MODE, isLooseConfig ? "true" : "false");
        this.storeRunProperties(server);
    }

    public void setCurrentRunStatus(String containerName, String mode, boolean isUser, boolean isLooseConfig, WebSphereServer server) {
        Properties properties = this.loadRunProperties(server);
        properties.setProperty(CONTAINER_NAME_KEY, containerName);
        properties.setProperty(CURRENT_MODE_KEY, mode);
        properties.setProperty(IS_USER_CONTAINER_KEY, isUser ? "true" : "false");
        properties.setProperty(CURRENT_LOOSE_CONFIG_MODE, isLooseConfig ? "true" : "false");
        this.storeRunProperties(server);
    }

    public List<String> getAdditionalVolumes(WebSphereServer server) {
        Properties properties = this.loadRunProperties(server);
        String volumes = properties.getProperty(ADDITIONAL_VOLUMES);
        if (volumes == null || volumes.isEmpty()) {
            return Collections.emptyList();
        }
        String[] volumeArray = volumes.split(File.pathSeparator);
        return Arrays.asList(volumeArray);
    }

    public List<String> getMandatoryVolumes(WebSphereServer server) {
        Properties properties = this.loadRunProperties(server);
        String volumes = properties.getProperty(MANDATORY_VOLUMES);
        if (volumes == null || volumes.isEmpty()) {
            return Collections.emptyList();
        }
        String[] volumeArray = volumes.split(File.pathSeparator);
        return Arrays.asList(volumeArray);
    }

    public void addAdditionalVolume(WebSphereServer server, String newVolume) {
        Properties properties = this.loadRunProperties(server);
        String volumes = properties.getProperty(ADDITIONAL_VOLUMES);
        if (volumes == null || volumes.isEmpty()) {
            volumes = newVolume;
        } else {
            String[] volumeArray;
            for (String volume : volumeArray = volumes.split(File.pathSeparator)) {
                if (!newVolume.equals(volume)) continue;
                return;
            }
            volumes = volumes + File.pathSeparator + newVolume;
        }
        properties.setProperty(ADDITIONAL_VOLUMES, volumes);
        this.storeRunProperties(server);
    }

    public void setAdditionalVolumes(WebSphereServer server, Collection<IPath> newVolumes) {
        if (newVolumes == null || newVolumes.isEmpty()) {
            this.clearAdditionalVolumes(server);
            return;
        }
        Properties properties = this.loadRunProperties(server);
        String volumes = null;
        for (IPath newVolume : newVolumes) {
            if (volumes == null) {
                volumes = newVolume.toOSString();
                continue;
            }
            volumes = volumes + File.pathSeparator + newVolume.toOSString();
        }
        properties.setProperty(ADDITIONAL_VOLUMES, volumes);
        this.storeRunProperties(server);
    }

    public void addMandatoryVolumes(WebSphereServer server, Collection<IPath> newVolumes) {
        Properties properties = this.loadRunProperties(server);
        String volumes = null;
        for (IPath newVolume : newVolumes) {
            if (volumes == null) {
                volumes = newVolume.toOSString();
                continue;
            }
            volumes = volumes + File.pathSeparator + newVolume.toOSString();
        }
        properties.setProperty(MANDATORY_VOLUMES, volumes);
        this.storeRunProperties(server);
    }

    public void clearAdditionalVolumes(WebSphereServer server) {
        Properties properties = this.loadRunProperties(server);
        String volumes = properties.getProperty(ADDITIONAL_VOLUMES);
        if (volumes != null) {
            properties.remove(ADDITIONAL_VOLUMES);
            this.storeRunProperties(server);
        }
    }

    public String getConnectionPort(IServer server, String port) {
        String mappedPort;
        block3: {
            BaseDockerContainer container = null;
            mappedPort = null;
            try {
                container = this.getContainer(server);
                mappedPort = container.getHostMappedPort(port);
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block3;
                String name = container != null ? container.getContainerName() : "unknown";
                Trace.logError("Failed to get mapped port for the " + name + " container and port " + port, e);
            }
        }
        if (mappedPort == null) {
            mappedPort = port;
        }
        return mappedPort;
    }

    public String getConnectionHost(IServer server, String host, String port) {
        String mappedHost;
        block4: {
            if (!SocketUtil.isLocalhost((String)host)) {
                return host;
            }
            mappedHost = null;
            BaseDockerContainer container = null;
            try {
                container = this.getContainer(server);
                mappedHost = container.getHostMappedIP(port);
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block4;
                String name = container != null ? container.getContainerName() : "unknown";
                Trace.logError("Failed to get mapped IP for the " + name + " container and port " + port, e);
            }
        }
        if (mappedHost == null) {
            mappedHost = host;
        }
        return mappedHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadRunProperties(WebSphereServer server) {
        IPath path = this.getRunPropertiesPath(server);
        if (path == null) {
            if (this.runProperties == null) {
                Properties properties = new Properties();
                this.setDefaultProperties(properties, server);
                return properties;
            }
            Trace.logError("Could not calculate the Docker run properties path for server: " + server.getServerName(), null);
            return this.runProperties;
        }
        IServer iServer = server.getServer();
        synchronized (iServer) {
            File file;
            if (this.runProperties != null && (file = path.toFile()).exists() && file.lastModified() > this.runPropertiesTimestamp) {
                this.runProperties = null;
            }
            if (this.runProperties == null) {
                this.runProperties = new Properties();
                file = path.toFile();
                if (file.exists()) {
                    FileInputStream inputStream = null;
                    try {
                        inputStream = new FileInputStream(file);
                        this.runProperties.load(new FileInputStream(file));
                        this.runPropertiesTimestamp = file.lastModified();
                    }
                    catch (Exception e) {
                        Trace.logError("Could not load the properties file: " + file.getAbsolutePath(), e);
                        this.setDefaultProperties(this.runProperties, server);
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                ((InputStream)inputStream).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                } else {
                    this.setDefaultProperties(this.runProperties, server);
                }
            }
        }
        return this.runProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeRunProperties(WebSphereServer server) {
        if (this.runProperties == null) {
            return;
        }
        IPath path = this.getRunPropertiesPath(server);
        if (path == null) {
            Trace.logError("Could not calculate the Docker run properties path for server: " + server.getServerName(), null);
            return;
        }
        IServer iServer = server.getServer();
        synchronized (iServer) {
            block27: {
                OutputStream outputStream;
                block26: {
                    block25: {
                        File file = path.toFile();
                        outputStream = null;
                        try {
                            if (!path.toFile().exists()) {
                                IPath dir = path.removeLastSegments(1);
                                if (!dir.toFile().mkdirs()) {
                                    Trace.logError("Failed to create directory structure for run properties: " + path.toOSString(), null);
                                    break block25;
                                }
                                if (!file.createNewFile()) {
                                    Trace.logError("Failed to create file for persisting run properties: " + file.getAbsolutePath(), null);
                                    break block26;
                                }
                            }
                            outputStream = new FileOutputStream(file);
                            this.runProperties.store(outputStream, null);
                            break block27;
                        }
                        catch (Exception e) {
                            Trace.logError("Could not store the properties file: " + file.getAbsolutePath(), e);
                            break block27;
                        }
                    }
                    return;
                }
                return;
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return;
        }
    }

    private void setDefaultProperties(Properties properties, WebSphereServer server) {
        Map serviceInfo = server.getServiceInfo();
        properties.setProperty(CONTAINER_NAME_KEY, (String)serviceInfo.get("dockerContainer"));
        properties.setProperty(IS_USER_CONTAINER_KEY, "true");
        properties.setProperty(CURRENT_MODE_KEY, "run");
        properties.setProperty(CURRENT_LOOSE_CONFIG_MODE, "false");
    }

    private IPath getRunPropertiesPath(WebSphereServer server) {
        WebSphereServerInfo serverInfo = server.getServerInfo();
        if (serverInfo != null) {
            IPath path = serverInfo.buildMetadataDirectoryPath();
            return path.append(RUN_PROPERTIES_FILE);
        }
        return null;
    }

    public BaseDockerContainer getContainer(WebSphereServer server) throws UnsupportedServiceException {
        Map serviceInfo = server.getServiceInfo();
        if (serviceInfo != null) {
            IPlatformHandler handler;
            String containerName = this.getContainerName(server);
            if (containerName != null) {
                serviceInfo.put("dockerContainer", containerName);
            }
            if ((handler = PlatformHandlerFactory.getPlatformHandler((Map)serviceInfo, (PlatformHandlerFactory.PlatformType)PlatformHandlerFactory.PlatformType.DOCKER)) instanceof BaseDockerContainer) {
                return (BaseDockerContainer)handler;
            }
        }
        return null;
    }

    private WebSphereServer getWebSphereServer(IServer server) {
        return (WebSphereServer)server.getAdapter(WebSphereServer.class);
    }

    private BaseDockerContainer getContainer(IServer server) throws UnsupportedServiceException {
        WebSphereServer wsServer = this.getWebSphereServer(server);
        if (wsServer != null) {
            return this.getContainer(wsServer);
        }
        return null;
    }

    public IStatus preModifyModules(IServer server, IModule[] add, IModule[] remove, IProgressMonitor monitor) {
        LibertyDockerServerBehaviour extBehaviour;
        if (add == null || add.length == 0) {
            return Status.OK_STATUS;
        }
        WebSphereServer wsServer = (WebSphereServer)server.getAdapter(WebSphereServer.class);
        if (wsServer == null) {
            Trace.logError("Failed to adapt the " + server.getName() + " server to a WebSphereServer.", null);
            return Status.OK_STATUS;
        }
        if (!wsServer.isLooseConfigEnabled()) {
            return Status.OK_STATUS;
        }
        WebSphereServerBehaviour wsBehaviour = wsServer.getWebSphereServerBehaviour();
        if (wsBehaviour != null && (extBehaviour = (LibertyDockerServerBehaviour)((Object)wsBehaviour.getAdapter(LibertyDockerServerBehaviour.class))) != null) {
            try {
                BaseDockerContainer container = this.getContainer(server);
                Map<IPath, IPath> volumeHash = extBehaviour.getPathMappingHash((ServerBehaviourDelegate)wsBehaviour);
                if (container != null && volumeHash != null) {
                    HashSet<IModule> modulesNeedingVolumes = new HashSet<IModule>();
                    HashSet<IPath> newVolumes = new HashSet<IPath>();
                    for (IModule module : add) {
                        Set<IPath> locations = LibertyDockerRunUtility.getLocations(wsServer, module);
                        for (IPath location : locations) {
                            boolean found = false;
                            for (IPath existingPath : volumeHash.keySet()) {
                                IPath basePath = FileUtil.getCanonicalPath((IPath)existingPath);
                                if (!basePath.isPrefixOf(location)) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            if (Trace.ENABLED) {
                                Trace.trace((byte)0, "No existing volume on the " + container.getContainerName() + " container was found for: " + location);
                            }
                            modulesNeedingVolumes.add(module);
                            LibertyDockerRunUtility.mergeModuleLocation(newVolumes, location);
                        }
                    }
                    if (!newVolumes.isEmpty()) {
                        NewContainerPrompt prompt = new NewContainerPrompt(NLS.bind((String)Messages.dockerNewVolumesPromptDetails, (Object)this.formatModules(modulesNeedingVolumes)));
                        prompt.getActionHandler().prePromptAction(null, null, (IProgressMonitor)new NullProgressMonitor());
                        PromptHandler promptHandler = com.ibm.ws.st.core.internal.Activator.getPromptHandler();
                        if (promptHandler != null && !PromptUtil.isSuppressDialog()) {
                            IPromptResponse response = promptHandler.getResponse(Messages.dockerNewVolumesPromptTitle, new PromptHandler.AbstractPrompt[]{prompt}, 257);
                            if (response == null) {
                                return Status.CANCEL_STATUS;
                            }
                            if (response.getSelectedAction(prompt.getIssues()[0]) != PromptAction.YES) {
                                return new Status(4, "com.ibm.ws.st.docker.core", NLS.bind((String)Messages.dockerNewVolumesPromptError, (Object)this.formatModules(modulesNeedingVolumes)), null);
                            }
                        }
                        for (IPath path : newVolumes) {
                            this.addAdditionalVolume(wsServer, path.toOSString());
                        }
                        IStatus status = extBehaviour.restartServer((ServerBehaviourDelegate)wsBehaviour, Messages.dockerUpdateContainerVolumesMsg, monitor);
                        return status;
                    }
                }
            }
            catch (Exception e) {
                return Status.CANCEL_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    private String formatModules(Collection<IModule> modules) {
        Object[] names = new String[modules.size()];
        int i = 0;
        for (IModule module : modules) {
            names[i++] = module.getName();
        }
        Arrays.sort(names);
        StringBuilder builder = new StringBuilder();
        for (Object name : names) {
            builder.append("\n    ");
            builder.append((String)name);
        }
        return builder.toString();
    }
}

