/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.liberty.buildplugin.integration.ui.internal;

import com.ibm.ws.st.liberty.buildplugin.integration.internal.Activator;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.Messages;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.Trace;
import com.ibm.ws.st.ui.internal.RuntimeExplorerView;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class UIHelper {
    public static final String RUNTIME_EXPLORER_VIEW_ID = "com.ibm.ws.st.ui.runtime.view";

    public static void openRuntimeExplorerView() {
        IViewPart part;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (part = page.findView(RUNTIME_EXPLORER_VIEW_ID)) == null) {
            try {
                part = page.showView(RUNTIME_EXPLORER_VIEW_ID);
            }
            catch (PartInitException e) {
                Trace.logError("Could not open runtime explorer view", e);
            }
        }
    }

    public static void refreshRuntimeExplorerView() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IViewPart part = page.findView(RUNTIME_EXPLORER_VIEW_ID);
            if (part == null) {
                try {
                    part = page.showView(RUNTIME_EXPLORER_VIEW_ID);
                }
                catch (PartInitException e) {
                    Trace.logError("Could not open runtime explorer view", e);
                }
            }
            if (part != null && part instanceof RuntimeExplorerView) {
                RuntimeExplorerView v = (RuntimeExplorerView)part;
                v.getCommonViewer().refresh();
            }
        }
    }

    public static boolean handleGenerationPrompt(String promptPreferenceKey, String generationPromptMsg) {
        MessageDialogWithToggle dialog;
        int returnCode;
        IPreferenceStore store = Activator.getInstance().getPreferenceStore();
        String val = store.getString(promptPreferenceKey);
        if (!val.isEmpty()) {
            if (Messages.yesLabel.equals(val)) {
                return true;
            }
            if (Messages.noLabel.equals(val)) {
                return false;
            }
        }
        boolean result = (returnCode = (dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.libertyPromptTitle, (String)generationPromptMsg, (String)Messages.generationPromptToggle, (boolean)false, null, (String)promptPreferenceKey)).getReturnCode()) == 2;
        boolean rememberDecision = dialog.getToggleState();
        if (rememberDecision) {
            String value = result ? Messages.yesLabel : Messages.noLabel;
            store.setValue(promptPreferenceKey, value);
        }
        return result;
    }
}

