/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.wizard;

import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.wizard.NewUserDirProjectWizardPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class NewUserDirProjectWizard
extends Wizard {
    protected NewUserDirProjectWizardPage page;
    protected IProject createdProject;

    public NewUserDirProjectWizard() {
        this.setWindowTitle(Messages.wizNewUserProjectTitle);
        this.setDefaultPageImageDescriptor(Activator.getImageDescriptor("wizRuntime"));
        this.setNeedsProgressMonitor(true);
    }

    private String getProjectName() {
        return this.page.getProjectName();
    }

    private IPath getProjectLocation() {
        IPath location = this.page.getLocationPath();
        if (location != null && location.equals((Object)ResourcesPlugin.getWorkspace().getRoot().getLocation())) {
            location = null;
        }
        return location;
    }

    protected IProject getProject() {
        return this.createdProject;
    }

    public void addPages() {
        this.page = new NewUserDirProjectWizardPage();
        this.addPage((IWizardPage)this.page);
        super.addPages();
    }

    public boolean performFinish() {
        try {
            final String projectName = this.getProjectName();
            final IPath location = this.getProjectLocation();
            final IWorkingSet[] workingSets = this.page.getSelectedWorkingSets();
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        NewUserDirProjectWizard.this.createdProject = WebSphereUtil.createUserProject((String)projectName, (IPath)location, (IProgressMonitor)monitor);
                        PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)NewUserDirProjectWizard.this.createdProject, workingSets);
                    }
                    catch (CoreException ce) {
                        Trace.logError("Error creating user project: " + projectName, ce);
                        throw new InvocationTargetException(ce);
                    }
                }
            });
        }
        catch (Exception e) {
            Trace.logError("Error creating project: " + this.getProjectName(), e);
            return false;
        }
        return true;
    }
}

