/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.provisional.dialogs;

import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.crypto.CustomPasswordEncryptionInfo;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.config.PasswordComponent;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PasswordDialog
extends TitleAreaDialog {
    protected boolean isSupportHash;
    protected WebSphereRuntime wsRuntime;
    protected String encodedPassword;
    protected PasswordComponent password;
    protected IProgressMonitor monitor;
    protected Map<String, CustomPasswordEncryptionInfo> customEncryptionMap;
    protected String encodingMethod;

    public PasswordDialog(Shell parent, boolean curIsSupportHash, WebSphereRuntime wsRuntime, Map<String, CustomPasswordEncryptionInfo> customEncryptionList) {
        super(parent);
        this.isSupportHash = curIsSupportHash;
        this.wsRuntime = wsRuntime;
        this.customEncryptionMap = customEncryptionList;
    }

    public PasswordDialog(Shell parent, boolean curIsSupportHash, WebSphereRuntime wsRuntime) {
        super(parent);
        this.isSupportHash = curIsSupportHash;
        this.wsRuntime = wsRuntime;
        this.customEncryptionMap = null;
    }

    public PasswordDialog(Shell parent, boolean curIsSupportHash) {
        super(parent);
        this.isSupportHash = curIsSupportHash;
        this.wsRuntime = this.getWebSphereRuntime();
        this.customEncryptionMap = null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.passwordDialogTitle);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            try {
                this.encodedPassword = this.password.getEncodedPassword(this.monitor);
                this.encodingMethod = this.password.getPasswordEncoding();
            }
            catch (Exception e) {
                this.setErrorMessage(e.getLocalizedMessage());
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.passwordDialogLabel);
        this.setTitleImage(Activator.getImage("wizServer"));
        this.setMessage(Messages.passwordDialogMessage);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.minimumWidth = 300;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.password = new PasswordComponent(composite, this.wsRuntime, this.isSupportHash, this.customEncryptionMap);
        this.password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PasswordDialog.this.enableOKButton(PasswordDialog.this.password.validate().getSeverity() != 4);
            }
        });
        ProgressMonitorPart progressMonitor = new ProgressMonitorPart(composite, null);
        data = new GridData(4, 3, true, false);
        data.horizontalSpan = 2;
        progressMonitor.setLayoutData((Object)data);
        this.monitor = progressMonitor;
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.enableOKButton(false);
        return control;
    }

    protected void enableOKButton(boolean value) {
        this.getButton(0).setEnabled(value);
    }

    public String getEncodedPassword() {
        return this.encodedPassword;
    }

    public String getPasswordEncoding() {
        return this.encodingMethod;
    }

    public int openWithRuntimeCheck() {
        if (this.wsRuntime == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.title, (String)Messages.passwordDialogNoRuntime);
            return 1;
        }
        return super.open();
    }

    private WebSphereRuntime getWebSphereRuntime() {
        WebSphereRuntime[] webSphereRuntimes = WebSphereUtil.getWebSphereRuntimes();
        if (webSphereRuntimes.length > 0) {
            return webSphereRuntimes[0];
        }
        return null;
    }
}

