/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.marker;

import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.config.VariableDialog;
import com.ibm.ws.st.ui.internal.marker.AbstractMarkerResolution;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class QuickFixCreateVariable
extends AbstractMarkerResolution {
    private final String variableName;

    public QuickFixCreateVariable(String name) {
        this.variableName = name;
    }

    public String getLabel() {
        return NLS.bind((String)Messages.createVariableQuickFix, (Object[])new String[]{this.variableName});
    }

    public void run(IMarker marker) {
        IFile resource = this.getResource(marker);
        if (resource == null) {
            return;
        }
        String value = this.getVariableValue();
        if (value == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)6, "Quick fix for create variable failed. The value for the variable '" + this.variableName + "' is null.", null);
            }
            this.showErrorMessage();
            return;
        }
        ConfigurationFile configFile = this.getConfigFile((IResource)resource);
        if (configFile == null) {
            return;
        }
        if (configFile.addVariable(this.variableName, value)) {
            try {
                configFile.save(null);
            }
            catch (IOException e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)6, "Quick fix for create variable '" + this.variableName + "'failed. Error trying to save configuration file: " + configFile.getURI(), e);
                }
                this.showErrorMessage();
            }
        } else {
            if (Trace.ENABLED) {
                Trace.trace((byte)6, "Quick fix for create variable failed. Error adding variable '" + this.variableName + "' to configuration: " + configFile.getURI(), null);
            }
            this.showErrorMessage();
        }
    }

    private String getVariableValue() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        VariableDialog dialog = new VariableDialog(shell, this.variableName);
        dialog.open();
        return dialog.getValue();
    }

    @Override
    protected String getErrorMessage() {
        return Messages.createVariableFailedMessage;
    }
}

