/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.marker;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.config.AddSecurityElementsDialog;
import com.ibm.ws.st.ui.internal.marker.AbstractMarkerResolution;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class QuickFixAddSecurityElements
extends AbstractMarkerResolution {
    public String getLabel() {
        return Messages.addRequiredServerConfigQuickFix;
    }

    public void run(IMarker marker) {
        IFile resource = this.getResource(marker);
        if (resource == null) {
            return;
        }
        ConfigurationFile configFile = this.getConfigFile((IResource)resource);
        if (configFile == null) {
            return;
        }
        WebSphereServerInfo wsInfo = configFile.getWebSphereServer();
        boolean securityEnabled = marker.getAttribute("appSecurityEnabled", false);
        Shell shell = Display.getDefault().getActiveShell();
        AddSecurityElementsDialog dialog = null;
        if (wsInfo != null) {
            dialog = new AddSecurityElementsDialog(shell, wsInfo, securityEnabled);
        } else {
            UserDirectory userDirectory = configFile.getUserDirectory();
            if (userDirectory != null) {
                WebSphereRuntime wsRuntime = userDirectory.getWebSphereRuntime();
                dialog = new AddSecurityElementsDialog(shell, wsRuntime, configFile, securityEnabled);
            }
            if (dialog == null) {
                this.showErrorMessage();
                return;
            }
        }
        if (dialog.open() == 0) {
            try {
                configFile.save(null);
            }
            catch (IOException e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)6, "Add security elements quick fix failed. Error trying to update configuration: " + configFile.getURI(), e);
                }
                this.showErrorMessage();
            }
        }
    }

    @Override
    protected String getErrorMessage() {
        return Messages.addRequiredServerConfigFailedMsg;
    }
}

