/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.repository.IProduct;
import com.ibm.ws.st.core.internal.repository.ISource;
import com.ibm.ws.st.core.internal.repository.License;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.download.AbstractProduct;
import com.ibm.ws.st.ui.internal.download.DownloadHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.ManifestElement;

public class LocalProduct
extends AbstractProduct {
    private static final String RUNTIME_MARKER = "wlp/lib/versions/WebSphereApplicationServer.properties";
    private static final String OPEN_RUNTIME_MARKER = "wlp/lib/versions/openliberty.properties";
    private static final String ASSET_MANAGER = "wlp/bin/installUtility.bat";
    private static final String APPLIES_TO = "Applies-To";
    private static final String PACKAGE_TYPE = "Archive-Content-Type";
    private static final String PROVIDE_FEATURE = "Provide-Feature";
    private static final String SUBSYTEM_APPLIES_TO = "IBM-AppliesTo";
    private static final String SUBSYTEM_TYPE = "Subsystem-Type";
    private static final String SUBSYTEM_SYMBOLIC_NAME = "Subsystem-SymbolicName";
    private static final String SUBSYTEM_CONTENT = "Subsystem-Content";
    private static final String DEFAULT_PRODUCT_ID = "com.ibm.websphere.appserver";
    private final LocalSource source;
    private License license;

    public static LocalProduct create(String path) {
        File archiveFile = new File(path);
        if (!archiveFile.exists()) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        ArrayList<Map<String, String>> productList = new ArrayList<Map<String, String>>();
        if (LocalProduct.isCoreLibertyArchive(archiveFile)) {
            LocalProduct.getCoreProperties(archiveFile, properties, productList);
        } else {
            LocalProduct.getAddOnProperties(archiveFile, properties, productList);
        }
        if (properties.isEmpty() || productList.isEmpty()) {
            return null;
        }
        return new LocalProduct(archiveFile, properties, productList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isCoreLibertyArchive(File archiveFile) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(archiveFile);
            boolean bl = !LocalProduct.getRuntimeMarkers(zipFile).isEmpty();
            return bl;
        }
        catch (IOException e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Problem reading archive: " + archiveFile, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static List<ZipEntry> getRuntimeMarkers(ZipFile zipFile) {
        ArrayList<ZipEntry> markers = new ArrayList<ZipEntry>();
        ZipEntry entry = zipFile.getEntry(RUNTIME_MARKER);
        if (entry != null) {
            markers.add(entry);
        }
        if ((entry = zipFile.getEntry(OPEN_RUNTIME_MARKER)) != null) {
            markers.add(entry);
        }
        return markers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getCoreProperties(File archiveFile, Map<String, String> coreProp, List<Map<String, String>> productList) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(archiveFile);
            ZipEntry entry = zipFile.getEntry(ASSET_MANAGER);
            String onPremise = entry == null ? "false" : "true";
            String provideFeature = LocalProduct.getCoreFeatures(archiveFile);
            coreProp.put("name", archiveFile.getName());
            coreProp.put("description", archiveFile.getAbsolutePath());
            coreProp.put("type", "install");
            coreProp.put("onPremise", onPremise);
            if (provideFeature != null) {
                coreProp.put("provideFeature", provideFeature);
            }
            List<ZipEntry> markers = LocalProduct.getRuntimeMarkers(zipFile);
            for (ZipEntry marker : markers) {
                InputStream is = null;
                try {
                    is = zipFile.getInputStream(marker);
                    Properties prop = new Properties();
                    prop.load(is);
                    HashMap<String, String> productProp = new HashMap<String, String>();
                    productProp.put("productId", prop.getProperty("com.ibm.websphere.productId"));
                    productProp.put("productVersion", prop.getProperty("com.ibm.websphere.productVersion"));
                    productProp.put("productInstallType", prop.getProperty("com.ibm.websphere.productInstallType"));
                    productProp.put("productEdition", prop.getProperty("com.ibm.websphere.productEdition"));
                    productProp.put("licenseType", prop.getProperty("com.ibm.websphere.productLicenseType", "ILAN"));
                    productList.add(productProp);
                }
                finally {
                    try {
                        if (is == null) continue;
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (IOException e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Problem reading archive: " + archiveFile, e);
            }
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static String getCoreFeatures(File archiveFile) {
        String provideFeature;
        block7: {
            String archivePath;
            block6: {
                archivePath = archiveFile.getAbsolutePath();
                provideFeature = null;
                try {
                    Attributes manAttrs = FileUtil.getJarManifestAttributes((String)archivePath);
                    if (manAttrs != null) {
                        provideFeature = manAttrs.getValue(PROVIDE_FEATURE);
                    }
                }
                catch (IOException e) {
                    if (!Trace.ENABLED) break block6;
                    Trace.trace((byte)1, "Failed to get provide features properties in " + archivePath, e);
                }
            }
            try {
                if (provideFeature == null) {
                    provideFeature = LocalProduct.getPublicFeatures(archiveFile);
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block7;
                Trace.trace((byte)1, "Failed to get installed features in " + archivePath, e);
            }
        }
        return provideFeature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPublicFeatures(File archiveFile) throws ZipException, IOException {
        StringBuilder sb = new StringBuilder();
        ZipFile jar = null;
        try {
            boolean isMultiple = false;
            jar = new ZipFile(archiveFile);
            Enumeration<? extends ZipEntry> enu = jar.entries();
            while (enu.hasMoreElements()) {
                ZipEntry entry = enu.nextElement();
                String name = entry.getName().toLowerCase();
                if (entry.isDirectory() || !name.startsWith("wlp/lib/features") || !name.endsWith(".mf")) continue;
                InputStream in = null;
                try {
                    in = jar.getInputStream(entry);
                    HashMap props = new HashMap();
                    FileUtil.readSubsystem((InputStream)in, props);
                    String content = (String)props.get(SUBSYTEM_SYMBOLIC_NAME);
                    ManifestElement[] elements = ManifestElement.parseHeader((String)SUBSYTEM_SYMBOLIC_NAME, (String)content);
                    if (elements == null) continue;
                    String visibility = elements[0].getAttribute("visibility");
                    if (visibility == null) {
                        visibility = elements[0].getDirective("visibility");
                    }
                    if (!"public".equals(visibility)) continue;
                    if (isMultiple) {
                        sb.append(',');
                    } else {
                        isMultiple = true;
                    }
                    sb.append(elements[0].getValue());
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) continue;
                    Trace.trace((byte)1, "Could not process manifest file" + entry.getName(), e);
                }
                finally {
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        finally {
            block24: {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e) {
                        if (!Trace.ENABLED) break block24;
                        Trace.trace((byte)1, "Trouble closing zip file", e);
                    }
                }
            }
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    private static void getAddOnProperties(File archiveFile, Map<String, String> addOnProp, List<Map<String, String>> productList) {
        String requireFeature;
        String provideFeature;
        String type;
        String appliesTo;
        String archivePath;
        block16: {
            archivePath = archiveFile.getAbsolutePath();
            appliesTo = null;
            type = null;
            provideFeature = null;
            requireFeature = null;
            try {
                Attributes manAttrs = FileUtil.getJarManifestAttributes((String)archivePath);
                if (manAttrs != null) {
                    appliesTo = manAttrs.getValue(APPLIES_TO);
                    type = manAttrs.getValue(PACKAGE_TYPE);
                    provideFeature = manAttrs.getValue(PROVIDE_FEATURE);
                } else {
                    Map props = FileUtil.getJarSubSystemProperties((String)archivePath);
                    if (props != null) {
                        String content;
                        ManifestElement[] elements;
                        appliesTo = (String)props.get(SUBSYTEM_APPLIES_TO);
                        if (appliesTo == null) {
                            appliesTo = DEFAULT_PRODUCT_ID;
                        }
                        if ("osgi.subsystem.feature".equals(props.get(SUBSYTEM_TYPE))) {
                            type = "feature";
                        }
                        if ((elements = ManifestElement.parseHeader((String)SUBSYTEM_SYMBOLIC_NAME, (String)(content = (String)props.get(SUBSYTEM_SYMBOLIC_NAME)))) != null) {
                            provideFeature = elements[0].getValue();
                        }
                        if ((elements = ManifestElement.parseHeader((String)SUBSYTEM_CONTENT, (String)(content = (String)props.get(SUBSYTEM_CONTENT)))) != null) {
                            StringBuilder sb = new StringBuilder();
                            boolean isFirstTime = true;
                            for (ManifestElement e : elements) {
                                if (!"osgi.subsystem.feature".equals(e.getAttribute("type"))) continue;
                                if (!isFirstTime) {
                                    sb.append(',');
                                }
                                sb.append(e.getValue());
                                isFirstTime = false;
                            }
                            if (sb.length() > 0) {
                                requireFeature = sb.toString();
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block16;
                Trace.trace((byte)1, "Failed to get header properties in " + archivePath, e);
            }
        }
        addOnProp.put("name", archiveFile.getName());
        addOnProp.put("description", archivePath);
        if (appliesTo != null) {
            addOnProp.put("appliesTo", appliesTo);
        }
        if (type != null) {
            addOnProp.put("type", type);
        }
        if (provideFeature != null) {
            addOnProp.put("provideFeature", provideFeature);
        }
        if (requireFeature != null) {
            addOnProp.put("requireFeature", requireFeature);
        }
        HashMap productProps = new HashMap();
        productList.add(productProps);
    }

    private LocalProduct(File file, Map<String, String> properties, List<Map<String, String>> productList) {
        super(properties, productList);
        this.source = new LocalSource(file);
    }

    public IProduct.ProductType getProductType() {
        return IProduct.ProductType.LOCAL_TYPE;
    }

    public long getSize() {
        return this.source.getSize();
    }

    public License getLicense(IProgressMonitor monitor) throws IOException {
        if (this.license == null) {
            this.license = DownloadHelper.getLicense(this.source.getFile());
        }
        return this.license;
    }

    public String getSiteName() {
        return "Local";
    }

    public ISource getSource() {
        return this.source;
    }

    protected static class LocalSource
    implements ISource {
        private final File file;

        protected LocalSource(File file) {
            this.file = file;
        }

        public String getLocation() {
            return this.file.getAbsolutePath();
        }

        public long getSize() {
            if (this.file.exists()) {
                return this.file.length();
            }
            return -1L;
        }

        protected File getFile() {
            return this.file;
        }
    }
}

