/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.repository.License;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.download.AbstractDownloadComposite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class LicenseComposite
extends AbstractDownloadComposite {
    protected static final String PAGE_NAME = "license";
    protected Table licenseTable;
    protected Browser licenseBrowser;
    protected Button accept;
    protected Button decline;
    protected boolean browserAvailable;
    protected Text licenseText;

    public LicenseComposite(Composite parent, Map<String, Object> map, AbstractDownloadComposite.IContainer container, AbstractDownloadComposite.IMessageHandler handler) {
        super(parent, map, container, handler);
        container.setTitle(Messages.wizLicenseTitle);
        container.setDescription(Messages.wizLicenseDescription);
        this.createControl();
    }

    protected void createControl() {
        this.setLayout(new LicenseLayout());
        this.licenseTable = new Table((Composite)this, 68100);
        this.licenseTable.setHeaderVisible(false);
        this.licenseTable.setLinesVisible(false);
        new TableColumn(this.licenseTable, 0);
        this.licenseTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] selections = LicenseComposite.this.licenseTable.getSelection();
                if (selections.length == 0) {
                    if (LicenseComposite.this.browserAvailable) {
                        LicenseComposite.this.licenseBrowser.setText("");
                    } else {
                        LicenseComposite.this.licenseText.setText("");
                    }
                    return;
                }
                TableItem item = selections[0];
                if (LicenseComposite.this.browserAvailable) {
                    LicenseComposite.this.licenseBrowser.setText((String)item.getData());
                } else {
                    LicenseComposite.this.licenseText.setText((String)item.getData());
                }
            }
        });
        try {
            this.licenseBrowser = new Browser((Composite)this, 2048);
            this.licenseBrowser.setFont(this.getFont());
            this.licenseBrowser.setJavascriptEnabled(false);
            this.licenseBrowser.addLocationListener((LocationListener)new LocationAdapter(){

                public void changing(LocationEvent event) {
                    if (event.location.startsWith("http://www.ibm.com")) {
                        event.doit = false;
                    }
                }
            });
            this.browserAvailable = true;
        }
        catch (SWTError swtError) {
            this.licenseText = new Text((Composite)this, 2632);
            this.licenseText.setBackground(this.getDisplay().getSystemColor(25));
            this.browserAvailable = false;
        }
        this.accept = new Button((Composite)this, 16);
        this.accept.setText(Messages.wizLicenseAccept);
        this.accept.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseComposite.this.map.put("accept", LicenseComposite.this.accept.getSelection());
                LicenseComposite.this.setMessage(null, LicenseComposite.this.accept.getSelection() ? 0 : 3);
            }
        });
        this.decline = new Button((Composite)this, 16);
        this.decline.setText(Messages.wizLicenseDecline);
        Dialog.applyDialogFont((Control)this);
    }

    private void updateLicense() {
        Map licenseMap = (Map)this.map.get(PAGE_NAME);
        if (licenseMap == null || licenseMap.isEmpty()) {
            this.licenseBrowser.setText(Messages.wizLicenseMissing);
            this.accept.setEnabled(false);
            this.decline.setEnabled(false);
            this.setMessage(null, 3);
            return;
        }
        this.licenseTable.removeAll();
        Collection licenses = licenseMap.values();
        ArrayList<String> finalLicenseList = new ArrayList<String>(licenses.size());
        int count = 0;
        for (License license : licenses) {
            String licenseTextValue = this.browserAvailable ? LicenseComposite.convertToHTML(license.getText()) : LicenseComposite.convertToText(license.getText());
            if (finalLicenseList.contains(licenseTextValue)) continue;
            TableItem item = new TableItem(this.licenseTable, 0);
            item.setImage(Activator.getImage(PAGE_NAME));
            String licenseName = license.getName();
            if (licenseName == null) {
                item.setText(NLS.bind((String)Messages.licenseAgreementLabel, (Object)String.valueOf(++count)));
            } else {
                item.setText(licenseName);
            }
            item.setData((Object)licenseTextValue);
            finalLicenseList.add(licenseTextValue);
        }
        this.accept.setEnabled(true);
        this.decline.setEnabled(true);
        this.licenseTable.setSelection(0);
        if (this.browserAvailable) {
            this.licenseBrowser.setText((String)this.licenseTable.getItem(0).getData());
        } else {
            this.licenseText.setText((String)this.licenseTable.getItem(0).getData());
        }
        if (finalLicenseList.size() == 1) {
            this.licenseTable.setEnabled(false);
            this.licenseTable.setVisible(false);
        } else {
            this.licenseTable.setEnabled(true);
            this.licenseTable.setVisible(true);
        }
        this.licenseTable.getParent().layout(true);
        boolean accepted = Boolean.TRUE.equals(this.map.get("accept"));
        this.accept.setSelection(accepted);
        this.decline.setSelection(!accepted);
        this.setMessage(null, accepted ? 0 : 3);
    }

    private static String convertToHTML(String s) {
        if (s.startsWith("<") || s.contains("<br") || s.contains("<p") || s.contains("<div")) {
            return s;
        }
        return s.replace("\r\n", "<br>\n");
    }

    private static String convertToText(String value) {
        int bodyEnd;
        String valueLowerCase = value.toLowerCase();
        int bodyStart = valueLowerCase.indexOf("<body>");
        if (bodyStart != -1 && (bodyEnd = valueLowerCase.lastIndexOf("</body>")) > bodyStart) {
            return LicenseComposite.removeTags(value.substring(bodyStart + 6, bodyEnd));
        }
        return LicenseComposite.removeTags(value);
    }

    private static String removeTags(String value) {
        return value.replaceAll("\\<.*?>", "").trim();
    }

    @Override
    public void enter() {
        this.updateLicense();
    }

    @Override
    public void performCancel(IProgressMonitor monitor) throws CoreException {
    }

    static class LicenseLayout
    extends Layout {
        private static final int INDENT = 15;
        private static final int SPACING = 5;
        private static final int MARGIN = 5;

        LicenseLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            int wHint2 = wHint;
            int hHint2 = hHint;
            if (wHint2 < 200) {
                wHint2 = 200;
            }
            if (hHint2 < 300) {
                hHint2 = 300;
            }
            return new Point(wHint2, hHint2);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point p2 = children[2].computeSize(-1, -1, flushCache);
            Point p3 = children[3].computeSize(-1, -1, flushCache);
            Rectangle r = composite.getClientArea();
            r.x += 5;
            r.y += 5;
            r.width -= 10;
            r.height -= 10;
            children[3].setBounds(r.x + 15, r.y + r.height - p3.y, r.width - 15, p3.y);
            children[2].setBounds(r.x + 15, r.y + r.height - p3.y - p2.y - 5, r.width - 15, p2.y);
            if (children[0].isEnabled()) {
                Table t = (Table)children[0];
                TableColumn col = t.getColumn(0);
                col.setWidth(r.width - t.getBorderWidth() * 2);
                int ty = Math.min(t.getItemCount(), 4) * t.getItemHeight() + t.getBorderWidth() * 2;
                children[1].setBounds(r.x, r.y + ty + 5, r.width, r.height - ty - p2.y - p3.y - 20);
                children[0].setBounds(r.x, r.y, r.width, ty);
            } else {
                children[1].setBounds(r.x, r.y, r.width, r.height - p2.y - p3.y - 15);
            }
        }
    }
}

