/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.repository.IProduct;
import com.ibm.ws.st.core.internal.repository.ISite;
import com.ibm.ws.st.core.internal.repository.License;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.ContentAssistCombo;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.SWTUtil;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.download.AbstractDownloadComposite;
import com.ibm.ws.st.ui.internal.download.AddonUtil;
import com.ibm.ws.st.ui.internal.download.DownloadHelper;
import com.ibm.ws.st.ui.internal.download.IRuntimeHandler;
import com.ibm.ws.st.ui.internal.download.LocalProduct;
import com.ibm.ws.st.ui.internal.download.SiteHelper;
import com.ibm.ws.st.ui.internal.download.ValidationResult;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.PasswordAuthentication;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DownloaderComposite
extends AbstractDownloadComposite {
    public static final String PREF_ARCHIVES = "archives";
    protected boolean downloadSupported = SiteHelper.downloadAndInstallSupported();
    protected IProduct coreProduct;
    protected boolean noAccess = false;
    protected boolean isLocalCoreArchive = true;
    protected ContentAssistCombo archive;
    protected ContentAssistCombo destinationDir;
    protected Combo combo;
    protected Table table;
    protected Label description;
    protected Group authenticationComp;
    protected Label userLabel;
    protected Text user;
    protected boolean userTouched;
    protected Label passwordLabel;
    protected Text password;
    protected Button unzipButton;
    protected Button browse;
    protected Button connect;
    protected Label downloadLicenseLabel;
    protected LocalProduct localCoreArchive = null;
    protected String localArchiveName = null;
    protected ISite currentSite = null;
    protected ISite[] runtimeSites;
    protected Map<String, ISite> runtimeSiteMap = new HashMap<String, ISite>();
    protected Map<ISite, PasswordAuthentication> siteAuthentication = new HashMap<ISite, PasswordAuthentication>();
    protected boolean isLicenseDownloadFailed = false;
    protected boolean isLicenseDownloadRequired = false;
    protected String archiveSource = null;
    protected IRuntimeHandler runtimeHandler;
    protected boolean updating;

    public DownloaderComposite(Composite parent, Map<String, Object> map, AbstractDownloadComposite.IContainer container, AbstractDownloadComposite.IMessageHandler handler, IRuntimeHandler runtimeHandler, String archiveSource) {
        super(parent, map, container, handler);
        container.setTitle(Messages.wizInstallTitle);
        container.setDescription(Messages.wizInstallDescription);
        this.runtimeSites = SiteHelper.getPredefinedRuntimeSites();
        this.runtimeHandler = runtimeHandler;
        this.archiveSource = archiveSource;
        for (ISite site : this.runtimeSites) {
            this.runtimeSiteMap.put(site.getName(), site);
        }
        map.put("siteAuthentication", this.siteAuthentication);
        this.createControl();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.wizInstallDestinationLabel);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Composite destinationGroup = this.createLocationBrowseComposite(this);
        this.destinationDir = new ContentAssistCombo(destinationGroup, new RuntimeLocationContentProvider());
        this.destinationDir.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.destinationDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DownloaderComposite.this.updating) {
                    return;
                }
                DownloaderComposite.this.runtimeHandler.setLocation((IPath)new Path(DownloaderComposite.this.destinationDir.getText()));
                DownloaderComposite.this.validate();
            }
        });
        Button destinationBrowse = SWTUtil.createButton(destinationGroup, Messages.browse);
        destinationBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DirectoryDialog dialog = new DirectoryDialog(DownloaderComposite.this.getShell());
                dialog.setMessage(Messages.runtimeInstallMessage);
                dialog.setFilterPath(DownloaderComposite.this.destinationDir.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    DownloaderComposite.this.destinationDir.setTextAndSuggest(selectedDirectory);
                }
            }
        });
        if (this.downloadSupported) {
            this.createArchiveAndDownload();
        } else {
            this.createArchive();
        }
    }

    protected void createArchive() {
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.wizInstallArchiveLabel);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Composite archiveGroup = this.createLocationBrowseComposite(this);
        this.createArchiveControl(archiveGroup, 0);
        this.isLicenseDownloadRequired = false;
        Dialog.applyDialogFont((Control)this);
        this.destinationDir.setFocus();
    }

    protected void createArchiveAndDownload() {
        Label lineLabel = new Label((Composite)this, 258);
        lineLabel.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        lineLabel.setVisible(false);
        this.unzipButton = new Button((Composite)this, 16);
        this.unzipButton.setText(Messages.wizInstallArchive);
        GridData data = new GridData(16384, 0x1000000, false, false);
        data.horizontalSpan = 2;
        this.unzipButton.setLayoutData((Object)data);
        this.unzipButton.setSelection(this.isLocalCoreArchive);
        this.createArchiveControl(this, 20);
        Button downloadButton = new Button((Composite)this, 16);
        downloadButton.setText(Messages.wizDownloadMessage);
        data = new GridData(16384, 0x1000000, false, false);
        data.horizontalSpan = 2;
        downloadButton.setLayoutData((Object)data);
        this.currentSite = SiteHelper.getDefaultAddOnSite();
        if (this.runtimeSites.length > 1) {
            this.combo = new Combo((Composite)this, 0x800808);
            data = new GridData(4, 1, true, false);
            data.horizontalIndent = 20;
            data.horizontalSpan = 2;
            this.combo.setLayoutData((Object)data);
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ISite newSite = DownloaderComposite.this.runtimeSiteMap.get(DownloaderComposite.this.combo.getText());
                    if (newSite == DownloaderComposite.this.currentSite) {
                        return;
                    }
                    DownloaderComposite.this.currentSite = newSite;
                    DownloaderComposite.this.coreProduct = null;
                    DownloaderComposite.this.description.setText("");
                    if (DownloaderComposite.this.currentSite.isAuthenticationRequired() && !DownloaderComposite.this.currentSite.isAuthenticated()) {
                        DownloaderComposite.this.table.removeAll();
                        DownloaderComposite.this.description.setText("");
                        DownloaderComposite.this.authenticationComp.setVisible(true);
                        DownloaderComposite.this.authenticationComp.setText(DownloaderComposite.this.currentSite.getName());
                        if (!DownloaderComposite.this.userTouched) {
                            String lastUser = Activator.getPreference("download.user." + DownloaderComposite.this.currentSite.getName(), null);
                            if (lastUser != null) {
                                DownloaderComposite.this.user.setText(lastUser);
                            } else {
                                DownloaderComposite.this.user.setText("");
                            }
                            DownloaderComposite.this.password.setText("");
                            DownloaderComposite.this.userTouched = false;
                        }
                    } else {
                        DownloaderComposite.this.authenticationComp.setVisible(false);
                        DownloaderComposite.this.updateTable();
                    }
                    DownloaderComposite.this.validate();
                }
            });
            for (ISite site : this.runtimeSites) {
                this.combo.add(site.getName());
            }
            this.combo.setText(this.currentSite.getName());
        }
        this.table = new Table((Composite)this, 68100);
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(false);
        data = new GridData(4, 4, true, true);
        data.horizontalIndent = 20;
        data.horizontalSpan = 2;
        data.minimumHeight = 100;
        this.table.setLayoutData((Object)data);
        this.table.setFont(this.getFont());
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object selection;
                TableItem[] sel = DownloaderComposite.this.table.getSelection();
                Object object = selection = sel != null && sel.length == 1 ? sel[0].getData() : null;
                if (selection != null) {
                    DownloaderComposite.this.coreProduct = (IProduct)selection;
                    DownloaderComposite.this.description.setText(DownloaderComposite.this.coreProduct.getDescription());
                } else {
                    DownloaderComposite.this.coreProduct = null;
                    DownloaderComposite.this.description.setText("");
                }
                DownloaderComposite.this.isLicenseDownloadRequired = true;
                DownloaderComposite.this.validate();
            }
        });
        this.description = new Label((Composite)this, 64);
        data = new GridData(4, 0x1000000, true, false);
        data.heightHint = 60;
        data.horizontalSpan = 2;
        data.horizontalIndent = 20;
        this.description.setLayoutData((Object)data);
        this.authenticationComp = new Group((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        this.authenticationComp.setLayout((Layout)layout);
        data = new GridData(4, 128, true, false);
        data.horizontalSpan = 2;
        data.horizontalIndent = 20;
        this.authenticationComp.setLayoutData((Object)data);
        this.userLabel = new Label((Composite)this.authenticationComp, 0);
        this.userLabel.setText(Messages.user);
        this.userLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.user = new Text((Composite)this.authenticationComp, 2048);
        this.user.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.user.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                DownloaderComposite.this.userTouched = true;
                DownloaderComposite.this.enableConnectIfValid();
            }
        });
        this.passwordLabel = new Label((Composite)this.authenticationComp, 0);
        this.passwordLabel.setText(Messages.password);
        this.passwordLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.password = new Text((Composite)this.authenticationComp, 2048);
        this.password.setEchoChar('*');
        this.password.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                DownloaderComposite.this.enableConnectIfValid();
            }
        });
        this.connect = new Button((Composite)this.authenticationComp, 8);
        this.connect.setText(Messages.connect);
        this.connect.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 2, 1));
        this.connect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (DownloaderComposite.this.performAuthentication(DownloaderComposite.this.user.getText(), DownloaderComposite.this.password.getText())) {
                    DownloaderComposite.this.updateTable();
                    DownloaderComposite.this.authenticationComp.setVisible(false);
                    DownloaderComposite.this.validate();
                }
            }
        });
        this.unzipButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DownloaderComposite.this.unzipButtonSelected();
                DownloaderComposite.this.validate();
            }
        });
        this.downloadLicenseLabel = new Label((Composite)this, 0);
        this.downloadLicenseLabel.setText(Messages.taskDownloadLicense);
        this.downloadLicenseLabel.setVisible(false);
        this.unzipButtonSelected();
        if (this.archiveSource != null) {
            downloadButton.setEnabled(false);
        }
        this.isLicenseDownloadRequired = !this.archive.getText().isEmpty();
        Dialog.applyDialogFont((Control)this);
        this.table.setFocus();
        if (this.currentSite.isAuthenticationRequired()) {
            this.authenticationComp.setVisible(true);
            this.authenticationComp.setText(this.currentSite.getName());
        } else {
            this.authenticationComp.setVisible(false);
            this.updateTable();
        }
    }

    protected Composite createLocationBrowseComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 1, true, false);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected void createArchiveControl(Composite parent, int indent) {
        ArchiveContentProvider contentProvider = new ArchiveContentProvider();
        this.archive = new ContentAssistCombo(parent, contentProvider);
        if (this.archiveSource != null) {
            this.archive.setText(this.archiveSource);
            this.addToMapList(PREF_ARCHIVES, this.archiveSource);
        } else {
            String[] items = contentProvider.getSuggestions("", true);
            if (items != null) {
                for (String s : items) {
                    if (!new File(s).exists()) continue;
                    this.archive.setText(s);
                    this.addToMapList(PREF_ARCHIVES, s);
                    break;
                }
            }
        }
        GridData data = new GridData(4, 2, true, false);
        data.horizontalIndent = indent;
        this.archive.setLayoutData(data);
        this.archive.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DownloaderComposite.this.addToMapList(DownloaderComposite.PREF_ARCHIVES, DownloaderComposite.this.archive.getText());
                if (DownloaderComposite.this.downloadSupported) {
                    DownloaderComposite.this.isLicenseDownloadRequired = true;
                }
                DownloaderComposite.this.validate();
            }
        });
        this.browse = SWTUtil.createButton(parent, Messages.browseButtonAcc);
        ((GridData)this.browse.getLayoutData()).verticalAlignment = 2;
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                FileDialog dialog = new FileDialog(DownloaderComposite.this.getShell());
                dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
                dialog.setFileName(DownloaderComposite.this.archive.getText());
                String file = dialog.open();
                if (file != null) {
                    DownloaderComposite.this.archive.setText(file);
                }
            }
        });
    }

    void unzipButtonSelected() {
        this.isLocalCoreArchive = this.unzipButton.getSelection();
        this.archive.setEnabled(this.isLocalCoreArchive);
        this.browse.setEnabled(this.isLocalCoreArchive);
        if (this.combo != null) {
            this.combo.setEnabled(!this.isLocalCoreArchive);
        }
        this.table.setEnabled(!this.isLocalCoreArchive);
        this.description.setEnabled(!this.isLocalCoreArchive);
        this.authenticationComp.setEnabled(!this.isLocalCoreArchive);
        this.userLabel.setEnabled(!this.isLocalCoreArchive);
        this.user.setEnabled(!this.isLocalCoreArchive);
        this.passwordLabel.setEnabled(!this.isLocalCoreArchive);
        this.password.setEnabled(!this.isLocalCoreArchive);
        this.enableConnectIfValid();
        if (this.isLocalCoreArchive) {
            if (this.table.getSelectionCount() > 0) {
                this.table.deselectAll();
            }
            this.description.setText("");
        } else {
            this.coreProduct = null;
        }
    }

    void enableConnectIfValid() {
        this.connect.setEnabled(!this.isLocalCoreArchive && !this.user.getText().isEmpty() && !this.password.getText().isEmpty());
    }

    protected void updateTable() {
        this.table.removeAll();
        this.noAccess = false;
        TableItem updateItem = new TableItem(this.table, 0);
        updateItem.setText(Messages.wizDownloadConnecting);
        Thread thread = new Thread("Checking available repositories"){

            @Override
            public void run() {
                List productList = DownloaderComposite.this.currentSite.getCoreProducts((IProgressMonitor)new NullProgressMonitor());
                for (final IProduct p : productList) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (DownloaderComposite.this.table.isDisposed()) {
                                return;
                            }
                            int count = DownloaderComposite.this.table.getItemCount();
                            TableItem item = new TableItem(DownloaderComposite.this.table, 0, count - 1);
                            item.setImage(Activator.getImage("runtime"));
                            item.setText(p.getName());
                            item.setData((Object)p);
                        }
                    });
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (DownloaderComposite.this.table.isDisposed()) {
                            return;
                        }
                        int count = DownloaderComposite.this.table.getItemCount();
                        DownloaderComposite.this.table.remove(count - 1);
                        if (count == 1) {
                            DownloaderComposite.this.noAccess = true;
                            DownloaderComposite.this.validate();
                        }
                    }
                });
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    protected void validate() {
        ValidationResult result = this.runtimeHandler.validateRuntime(true);
        if (result.getLevel() != 0) {
            this.setMessage(result.getMessage(), result.getLevel());
        }
        if (this.isLocalCoreArchive) {
            String archiveName = this.archive.getText();
            this.coreProduct = null;
            if (archiveName != null && !archiveName.trim().isEmpty()) {
                File f = new File(archiveName);
                if (!f.exists() || !f.getName().endsWith(".jar") && !f.getName().endsWith(".zip")) {
                    this.setMessage(Messages.errorInvalidArchive, 3);
                    return;
                }
                if (!archiveName.equals(this.localArchiveName)) {
                    this.localArchiveName = archiveName;
                    this.localCoreArchive = LocalProduct.create(archiveName);
                }
                if (this.localCoreArchive == null || this.localCoreArchive.getType() != IProduct.Type.INSTALL) {
                    this.setMessage(Messages.errorInvalidCoreArchive, 3);
                    return;
                }
                this.coreProduct = this.localCoreArchive;
            }
        } else if (this.noAccess) {
            this.setMessage(Messages.errorCouldNotConnect, 3);
            return;
        }
        if (this.coreProduct != null && this.coreProduct != this.map.get("coreManager")) {
            this.map.put("coreManager", this.coreProduct);
            this.map.put("core", this.coreProduct.getRuntimeInfo());
            if (this.isLocalCoreArchive) {
                this.map.remove("runtimeSite");
            } else {
                this.map.put("runtimeSite", this.currentSite);
            }
            this.map.remove("accept");
            this.isLicenseDownloadFailed = false;
        }
        if (this.destinationDir.getText().isEmpty()) {
            this.setMessage(Messages.wizInstallDestinationNotSet, 3);
            return;
        }
        String error = DownloadHelper.validateTargetRuntimeLocation(this.destinationDir.getText());
        if (error != null) {
            this.setMessage(error, 3);
            return;
        }
        if (this.coreProduct == null) {
            this.setMessage(Messages.wizInstallArchiveNotSet, 3);
            return;
        }
        if (this.isLicenseDownloadRequired) {
            this.downloadLicense();
            this.setMessage(null, 3);
            return;
        }
        if (this.isLicenseDownloadFailed) {
            this.setMessage(NLS.bind((String)Messages.wizLicenseError, (Object)this.coreProduct.getName()), 3);
            return;
        }
        this.setMessage(null, 0);
    }

    @Override
    public void exit() {
        ArrayList<IProduct> selectedList = (ArrayList<IProduct>)this.map.get("selectedDownloaders");
        if (selectedList == null) {
            selectedList = new ArrayList<IProduct>();
            this.map.put("selectedDownloaders", selectedList);
        } else {
            selectedList.clear();
        }
        IProduct coreManager = (IProduct)this.map.get("coreManager");
        if (coreManager != null) {
            selectedList.add(coreManager);
        }
    }

    @Override
    public void performCancel(IProgressMonitor monitor) throws CoreException {
    }

    protected boolean performAuthentication(String user, String password) {
        final PasswordAuthentication authentication = this.getAuthentication(this.currentSite, user, password);
        if (authentication == null) {
            return false;
        }
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(Messages.taskAuthenticating, 200);
                        try {
                            if (!DownloaderComposite.this.currentSite.authenticate(authentication, (IProgressMonitor)new SubProgressMonitor(monitor, 100))) {
                                throw new InvocationTargetException(new Exception(Messages.errorAuthenticationFailed));
                            }
                            Activator.setPreference("download.user." + DownloaderComposite.this.currentSite.getName(), authentication.getUserName());
                        }
                        catch (SocketException e) {
                            if (Trace.ENABLED) {
                                Trace.trace((byte)1, "Error authenticating", e);
                            }
                            if (!DownloadHelper.isSSLWorking()) {
                                throw new InvocationTargetException(new Exception(Messages.errorSSLSocketFailed));
                            }
                            throw new InvocationTargetException(e);
                        }
                        catch (IOException e) {
                            if (Trace.ENABLED) {
                                Trace.trace((byte)1, "Error authenticating", e);
                            }
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e) {
            this.setMessage(e.getCause().getLocalizedMessage(), 3);
            return false;
        }
        return true;
    }

    private PasswordAuthentication getAuthentication(ISite site, String user, String password) {
        PasswordAuthentication authentication = this.siteAuthentication.get(site);
        if (authentication != null && user.equals(authentication.getUserName()) && password.equals(new String(authentication.getPassword()))) {
            return authentication;
        }
        authentication = new PasswordAuthentication(user, password.toCharArray());
        this.siteAuthentication.put(site, authentication);
        return authentication;
    }

    protected void downloadLicense() {
        if (this.coreProduct == null) {
            return;
        }
        this.isLicenseDownloadFailed = true;
        this.isLicenseDownloadRequired = false;
        this.downloadLicenseLabel.setVisible(true);
        Thread downloadThread = new Thread(Messages.taskDownloadLicense){

            @Override
            public void run() {
                Map<IProduct, License> licenseMap = (Map<IProduct, License>)DownloaderComposite.this.map.get("license");
                if (licenseMap != null) {
                    licenseMap.clear();
                }
                try {
                    License license = DownloaderComposite.this.coreProduct.getLicense((IProgressMonitor)new NullProgressMonitor());
                    if (license != null) {
                        if (licenseMap == null) {
                            licenseMap = AddonUtil.createLicenseMap();
                            DownloaderComposite.this.map.put("license", licenseMap);
                        }
                        licenseMap.put(DownloaderComposite.this.coreProduct, license);
                    }
                    DownloaderComposite.this.isLicenseDownloadFailed = false;
                }
                catch (IOException e) {
                    try {
                        Trace.logError("Error getting license for " + DownloaderComposite.this.coreProduct.getName(), e);
                    }
                    catch (Throwable throwable) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (DownloaderComposite.this.downloadLicenseLabel.isDisposed()) {
                                    return;
                                }
                                DownloaderComposite.this.downloadLicenseLabel.setVisible(false);
                                DownloaderComposite.this.validate();
                            }
                        });
                        throw throwable;
                    }
                    Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                }
                Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
            }
        };
        downloadThread.setDaemon(true);
        downloadThread.start();
    }

    void addToMapList(String mapKey, String value) {
        ArrayList<String> list = (ArrayList<String>)this.map.get(mapKey);
        if (list == null) {
            list = new ArrayList<String>();
            this.map.put(mapKey, list);
        } else {
            list.clear();
        }
        list.add(value);
    }

    @Override
    public void enter() {
        this.destinationDir.setFocus();
    }

    protected class RuntimeLocationContentProvider
    extends ContentAssistCombo.ContentProvider {
        protected RuntimeLocationContentProvider() {
        }

        @Override
        public String[] getSuggestions(String hint, boolean showAll) {
            List<String> previousLocations = Activator.getPreferenceList(DownloaderComposite.this.runtimeHandler.getRuntimeTypeId() + ".folder");
            if (hint == null || hint.isEmpty()) {
                return previousLocations.toArray(new String[previousLocations.size()]);
            }
            ArrayList<String> suggestions = new ArrayList<String>();
            List suggestedPaths = WebSphereRuntime.findValidLocations((IPath)new Path(hint));
            if (suggestedPaths != null) {
                for (IPath path : suggestedPaths) {
                    try {
                        suggestions.add(path.toFile().getCanonicalPath());
                    }
                    catch (IOException e) {
                        suggestions.add(path.toOSString());
                    }
                }
            }
            for (String previousLocation : previousLocations) {
                Path previousPath = new Path(previousLocation);
                if (suggestedPaths != null && this.matchPathsByFile((IPath)previousPath, suggestedPaths) || !showAll && !DownloaderComposite.this.destinationDir.matches(previousPath.toPortableString())) continue;
                suggestions.add(previousPath.toOSString());
            }
            return suggestions.toArray(new String[suggestions.size()]);
        }

        private boolean matchPathsByFile(IPath thePath, List<IPath> pathList) {
            for (IPath item : pathList) {
                if (!item.toFile().equals(thePath.toFile())) continue;
                return true;
            }
            return false;
        }
    }

    protected class ArchiveContentProvider
    extends ContentAssistCombo.ContentProvider {
        protected ArchiveContentProvider() {
        }

        @Override
        public String[] getSuggestions(String hint, boolean showAll) {
            ArrayList<String> items = new ArrayList<String>();
            items.addAll(Activator.getPreferenceList(DownloaderComposite.PREF_ARCHIVES));
            List<File> files = DownloadHelper.getArchives();
            if (files != null && !files.isEmpty()) {
                int size = files.size();
                for (int i = 0; i < size; ++i) {
                    items.add(files.get(i).getAbsolutePath());
                }
            }
            items.addAll(Activator.getPreferenceList("package.path"));
            ArrayList<String> suggestions = new ArrayList<String>();
            for (String s : items) {
                boolean found = false;
                for (String t : suggestions) {
                    if (!t.equalsIgnoreCase(s)) continue;
                    found = true;
                }
                if (found || !showAll && !DownloaderComposite.this.archive.matches(s)) continue;
                suggestions.add(s);
            }
            return suggestions.toArray(new String[suggestions.size()]);
        }
    }
}

