/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.repository.IProduct;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.download.AddonUtil;
import com.ibm.ws.st.ui.internal.download.ConfigSnippetWizardFragment;
import com.ibm.ws.st.ui.internal.download.DownloadHelper;
import com.ibm.ws.st.ui.internal.download.LicenseWizardFragment;
import com.ibm.ws.st.ui.internal.download.SiteHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class ConfigSnippetWizardContainer
extends WizardFragment {
    private List<WizardFragment> cachedList;

    protected void createChildFragments(List<WizardFragment> list) {
        if (this.cachedList == null) {
            this.cachedList = new ArrayList<WizardFragment>();
            this.cachedList.add(new ConfigSnippetWizardFragment());
            this.cachedList.add(new LicenseWizardFragment());
        }
        list.addAll(this.cachedList);
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        String propsURL;
        Map map = (Map)this.getTaskModel().getObject("addonMap");
        if (map == null) {
            return;
        }
        List selectedList = (List)map.get("selectedDownloaders");
        if (selectedList.isEmpty()) {
            return;
        }
        WebSphereServerInfo server = (WebSphereServerInfo)this.getTaskModel().getObject("server");
        if (!this.preFinish(selectedList, server)) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IRuntime runtime = (IRuntime)this.getTaskModel().getObject("runtime");
        WebSphereRuntime wsRuntime = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
        int totalTicks = 100;
        int metadataTicks = wsRuntime != null && AddonUtil.isRefreshMetadataRequired(selectedList) ? 20 : 0;
        monitor.beginTask(Messages.jobInstallingRuntime, totalTicks);
        List authList = (List)map.get("productAuthentication");
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("runtimeLocation", new Path((String)map.get("folder")));
        settings.put("vmInstall", wsRuntime == null ? JavaRuntime.getDefaultVMInstall() : wsRuntime.getVMInstall());
        settings.put("server", server);
        if (SiteHelper.isProxyNeeded() && (propsURL = SiteHelper.getRepoPropertiesURL()) != null) {
            settings.put("repoPropsLocation", propsURL);
        }
        Map<IProduct, IStatus> result = DownloadHelper.install(selectedList, authList, settings, (IProgressMonitor)new SubProgressMonitor(monitor, totalTicks - metadataTicks));
        if (wsRuntime != null && result.containsValue(Status.OK_STATUS)) {
            if (metadataTicks > 0) {
                AddonUtil.refreshMetadata(wsRuntime, (IProgressMonitor)new SubProgressMonitor(monitor, metadataTicks));
            }
            wsRuntime.refresh();
        }
        AddonUtil.refreshServerFolder(server);
        AddonUtil.showResult(null, result);
        monitor.done();
    }

    private boolean preFinish(List<IProduct> selection, WebSphereServerInfo server) {
        ConfigurationFile serverConfig = server.getConfigRoot();
        IPath configDir = serverConfig.getPath().removeLastSegments(1);
        final StringBuilder sb = new StringBuilder();
        for (IProduct p : selection) {
            int index;
            String fileName;
            File configSnippetFile;
            String location;
            if (p.getType() != IProduct.Type.CONFIG_SNIPPET || (location = p.getSource().getLocation()) == null || !(configSnippetFile = configDir.append(fileName = (index = (location = location.replace('\\', '/')).lastIndexOf(47)) == -1 ? location.trim() : location.substring(index + 1, location.length()).trim()).toFile()).exists()) continue;
            sb.append(configSnippetFile.getAbsolutePath() + "\n");
        }
        if (sb.length() == 0) {
            return true;
        }
        final boolean[] result = new boolean[]{false};
        final boolean[] done = new boolean[]{false};
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = MessageDialog.openQuestion(null, (String)Messages.wizInstallAddonTitle, (String)NLS.bind((String)Messages.overwriteExistingFiles, (Object)sb.toString()));
                done[0] = true;
            }
        });
        while (!done[0]) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return result[0];
    }
}

