/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.repository.AbstractInstaller;
import com.ibm.ws.st.core.internal.repository.IProduct;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.download.DownloadHelper;
import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ConfigSnippetInstaller
extends AbstractInstaller {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus install(IProduct product, PasswordAuthentication pa, Map<String, Object> settings, IProgressMonitor monitor2) {
        WebSphereServerInfo server = (WebSphereServerInfo)settings.get("server");
        if (server == null) {
            return new Status(4, "com.ibm.ws.st.ui", 0, Messages.errorServerMissing, (Throwable)new IOException(Messages.errorServerMissing));
        }
        IProgressMonitor monitor = monitor2;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        File configFile = null;
        File tempConfig = null;
        boolean success = false;
        try {
            monitor.beginTask(Messages.jobInstallingRuntime, 100);
            String configFileName = this.getConfigFileName(product);
            if (configFileName == null) {
                Status status = new Status(4, "com.ibm.ws.st.ui", 0, Messages.errorServerConfigMissing, (Throwable)new IOException(Messages.errorServerConfigMissing));
                return status;
            }
            ConfigurationFile serverConfig = server.getConfigRoot();
            IPath configDir = serverConfig.getPath().removeLastSegments(1);
            configFile = configDir.append(configFileName).toFile();
            if (configFile.exists()) {
                tempConfig = new File(configFile.getAbsolutePath() + ".tmp");
                if (!configFile.renameTo(new File(configFile.getAbsolutePath() + ".tmp"))) {
                    Status status = new Status(4, "com.ibm.ws.st.ui", NLS.bind((String)Messages.errorBackupFile, (Object)configFile.getAbsolutePath()), null);
                    return status;
                }
            }
            monitor.subTask(Messages.taskConnecting);
            monitor.worked(10);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            DownloadHelper.download(product, configFile, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.install2(product.getName(), serverConfig, configDir, configFileName, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
            success = true;
        }
        catch (Exception e) {
            Status status = new Status(4, "com.ibm.ws.st.ui", 0, e.getLocalizedMessage(), (Throwable)e);
            return status;
        }
        finally {
            if (success) {
                if (tempConfig != null && tempConfig.exists()) {
                    tempConfig.delete();
                }
            } else {
                if (configFile != null && configFile.exists()) {
                    configFile.delete();
                }
                if (tempConfig != null && tempConfig.exists()) {
                    tempConfig.renameTo(configFile);
                }
            }
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private String getConfigFileName(IProduct p) {
        String location = p.getSource().getLocation();
        if (location == null) {
            return null;
        }
        int index = (location = location.replace('\\', '/')).lastIndexOf(47);
        return index == -1 ? location.trim() : location.substring(index + 1, location.length()).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install2(String productName, ConfigurationFile serverConfig, IPath configDir, String configFileName, IProgressMonitor monitor) throws IOException {
        try {
            monitor.beginTask(productName, 100);
            monitor.subTask(productName);
            monitor.worked(25);
            boolean includeExists = false;
            for (ConfigurationFile config : serverConfig.getAllIncludedFiles()) {
                if (!config.getPath().toOSString().equals(configDir.append(configFileName).toOSString())) continue;
                includeExists = true;
                break;
            }
            monitor.worked(25);
            if (!includeExists) {
                serverConfig.addInclude(false, configFileName);
                serverConfig.save((IProgressMonitor)new SubProgressMonitor(monitor, 40));
            }
        }
        finally {
            monitor.done();
        }
    }
}

