/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.SchemaUtil;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.config.ConfigUIUtils;
import com.ibm.ws.st.ui.internal.config.ConfigVarComputer;
import com.ibm.ws.st.ui.internal.config.IContentAssistProposal;
import com.ibm.ws.st.ui.internal.config.IContentAssistProposalProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDEnumerationFacet;

public abstract class ControlModifiersBase {
    protected static final IContentAssistProposal[] NO_PROPOSALS = new IContentAssistProposal[0];

    protected static void addItem(StringBuilder builder, List<StyleRange> styles, String label, String value, boolean addNewline) {
        int offset = builder.length();
        builder.append(label);
        builder.append("  ");
        styles.add(new StyleRange(offset, label.length(), null, null, 1));
        builder.append(value);
        if (addNewline) {
            builder.append("\n");
        }
    }

    public static class MultiProposalProvider
    implements IContentAssistProposalProvider {
        private final IContentAssistProposalProvider[] providers;

        public MultiProposalProvider(IContentAssistProposalProvider ... providers) {
            this.providers = providers;
        }

        @Override
        public IContentAssistProposal[] getProposals(String text, int startOffset, int endOffset) {
            ArrayList<IContentAssistProposal> allProposals = new ArrayList<IContentAssistProposal>();
            for (IContentAssistProposalProvider provider : this.providers) {
                IContentAssistProposal[] proposals = provider.getProposals(text, startOffset, endOffset);
                allProposals.addAll(Arrays.asList(proposals));
            }
            if (allProposals.isEmpty()) {
                allProposals.add(new LabelProposal(Messages.contentAssistEmpty));
            }
            return allProposals.toArray(new IContentAssistProposal[allProposals.size()]);
        }
    }

    public static class EnumProposal
    implements IContentAssistProposal {
        XSDEnumerationFacet enumFacet;
        boolean isDefault;
        int cursorPos;

        public EnumProposal(XSDEnumerationFacet enumFacet, boolean isDefault, int cursorPos) {
            this.enumFacet = enumFacet;
            this.isDefault = isDefault;
            this.cursorPos = cursorPos;
        }

        @Override
        public String getLabel() {
            return this.enumFacet.getLexicalValue();
        }

        @Override
        public Image getImage() {
            if (this.isDefault) {
                return Activator.getImage("enumeratorDefault");
            }
            return Activator.getImage("enumerator");
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public boolean hasDetails() {
            return true;
        }

        @Override
        public void createDetails(Composite parent) {
            StyledText text = new StyledText(parent, 576);
            text.setLayoutData((Object)new GridData(1808));
            text.setBackground(parent.getBackground());
            text.setForeground(parent.getForeground());
            ArrayList<StyleRange> styles = new ArrayList<StyleRange>(2);
            StringBuilder builder = new StringBuilder();
            ControlModifiersBase.addItem(builder, styles, Messages.contentAssistValueLabel, this.enumFacet.getLexicalValue(), true);
            String description = SchemaUtil.getDocumentation((XSDAnnotation)this.enumFacet.getAnnotation());
            if (description != null) {
                ControlModifiersBase.addItem(builder, styles, Messages.contentAssistDescriptionLabel, description, true);
            }
            text.setText(builder.toString());
            for (StyleRange style : styles) {
                text.setStyleRange(style);
            }
            Point parentSize = parent.getSize();
            Point textSize = text.computeSize(parentSize.x, -1, true);
            text.getVerticalBar().setVisible(parentSize.y <= textSize.y);
        }

        @Override
        public String getText() {
            return this.enumFacet.getLexicalValue();
        }

        @Override
        public int getCursorPosition() {
            return this.cursorPos;
        }
    }

    public static class EnumProposalProvider
    implements IContentAssistProposalProvider {
        private final CMAttributeDeclaration attrDecl;
        private final Map<String, XSDEnumerationFacet> enumMap;
        private final List<String> values;

        public EnumProposalProvider(CMAttributeDeclaration attrDecl, Map<String, XSDEnumerationFacet> enumMap) {
            this.attrDecl = attrDecl;
            this.enumMap = enumMap;
            this.values = new ArrayList<String>(enumMap.keySet());
        }

        @Override
        public IContentAssistProposal[] getProposals(String text, int startOffset, int endOffset) {
            String match = text.substring(0, startOffset);
            List<String> valueMatches = ConfigUIUtils.getSortedMatches(match, this.values);
            String defaultValue = this.attrDecl.getDefaultValue();
            ArrayList<EnumProposal> proposals = new ArrayList<EnumProposal>(valueMatches.size());
            for (String value : valueMatches) {
                EnumProposal proposal = new EnumProposal(this.enumMap.get(value), value.equals(defaultValue), value.length());
                proposals.add(proposal);
            }
            return proposals.toArray(new IContentAssistProposal[proposals.size()]);
        }
    }

    public static class VarContentProposal
    implements IContentAssistProposal {
        String varName;
        String typeName;
        String fullText;
        int cursorPos;
        ConfigVars vars;

        public VarContentProposal(String varName, String typeName, String fullText, int cursorPos, ConfigVars vars) {
            this.varName = varName;
            this.typeName = typeName;
            this.fullText = fullText;
            this.cursorPos = cursorPos;
            this.vars = vars;
        }

        @Override
        public String getLabel() {
            return this.varName;
        }

        @Override
        public Image getImage() {
            return Activator.getImage("variableRef");
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public boolean hasDetails() {
            return true;
        }

        @Override
        public void createDetails(Composite parent) {
            StyledText text = new StyledText(parent, 64);
            text.setLayoutData((Object)new GridData(1808));
            text.setBackground(parent.getBackground());
            text.setForeground(parent.getForeground());
            ArrayList<StyleRange> styles = new ArrayList<StyleRange>(3);
            StringBuilder builder = new StringBuilder();
            ControlModifiersBase.addItem(builder, styles, Messages.contentAssistVariableLabel, this.varName, true);
            ControlModifiersBase.addItem(builder, styles, Messages.contentAssistTypeLabel, this.typeName, true);
            ControlModifiersBase.addItem(builder, styles, Messages.contentAssistValueLabel, this.vars.getValue(this.varName), false);
            text.setText(builder.toString());
            for (StyleRange style : styles) {
                text.setStyleRange(style);
            }
        }

        @Override
        public String getText() {
            return this.fullText;
        }

        @Override
        public int getCursorPosition() {
            return this.cursorPos;
        }
    }

    public static class LabelProposal
    implements IContentAssistProposal {
        private final String label;

        public LabelProposal(String label) {
            this.label = label;
        }

        @Override
        public String getLabel() {
            return "-- " + this.label + " --";
        }

        @Override
        public Image getImage() {
            return null;
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public boolean hasDetails() {
            return false;
        }

        @Override
        public void createDetails(Composite parent) {
        }

        @Override
        public String getText() {
            return null;
        }

        @Override
        public int getCursorPosition() {
            return 0;
        }
    }

    public static class VariableProposalProvider
    implements IContentAssistProposalProvider {
        private final ConfigVarComputer configVarComputer;
        private final String type;
        private final boolean singleEntry;

        public VariableProposalProvider(ConfigVarComputer configVarComputer, String type, boolean singleEntry) {
            this.configVarComputer = configVarComputer;
            this.type = type;
            this.singleEntry = singleEntry;
        }

        @Override
        public IContentAssistProposal[] getProposals(String text, int startOffset, int endOffset) {
            VarContentProposal proposal;
            String str;
            ConfigVars configVars = this.configVarComputer.getConfigVars();
            String startStr = text.substring(0, startOffset);
            String endStr = "";
            String match = "";
            int start = startStr.lastIndexOf("${");
            int end = startStr.lastIndexOf("}");
            if (start >= 0 && end < start) {
                match = startStr.substring(start += 2);
                startStr = startStr.substring(0, start);
                end = text.indexOf("}", startOffset);
                endStr = end >= 0 ? text.substring(end) : "}" + text.substring(startOffset);
            } else if (startOffset > 0 && text.charAt(startOffset - 1) == '$') {
                match = "";
                startStr = startStr + "{";
                endStr = "}" + text.substring(endOffset);
            } else {
                if (!(!this.singleEntry || startStr.isEmpty() && text.substring(endOffset).isEmpty())) {
                    return NO_PROPOSALS;
                }
                match = "";
                startStr = startStr + "${";
                endStr = "}" + text.substring(endOffset);
            }
            List names = configVars.getGlobalVars(this.type, true, false);
            List<String> varNames = ConfigUIUtils.getSortedMatches(match, names);
            ArrayList<IContentAssistProposal> proposals = new ArrayList<IContentAssistProposal>(varNames.size());
            String typeName = configVars.getTypeName(this.type);
            for (String varName : varNames) {
                str = startStr + varName + endStr;
                proposal = new VarContentProposal(varName, typeName, str, startStr.length() + varName.length() + 1, configVars);
                proposals.add(proposal);
            }
            if (!configVars.isGlobalScope() && !(varNames = ConfigUIUtils.getSortedMatches(match, names = configVars.getScopedVars(this.type, false, false))).isEmpty()) {
                proposals.add(new LabelProposal(Messages.contentAssistImplicitLocalLabel));
                for (String varName : varNames) {
                    str = startStr + varName + endStr;
                    proposal = new VarContentProposal(varName, typeName, str, startStr.length() + varName.length() + 1, configVars);
                    proposals.add(proposal);
                }
            }
            return proposals.toArray(new IContentAssistProposal[proposals.size()]);
        }
    }
}

