/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.core.internal.config.SchemaUtil;
import com.ibm.ws.st.ui.internal.Messages;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractChainableDialog
extends TitleAreaDialog {
    protected Document doc;
    protected URI docURI;
    protected UserDirectory userDir;
    protected Rectangle parentLocation = null;
    protected String[] tags;
    protected String[] labels;

    public AbstractChainableDialog(Shell parent, Document doc, URI docURI, UserDirectory userDir, String[] tags, String[] labels) {
        super(parent);
        this.doc = doc;
        this.docURI = docURI;
        this.userDir = userDir;
        this.tags = (String[])tags.clone();
        this.labels = (String[])labels.clone();
    }

    public void setParentLocation(Rectangle location) {
        this.parentLocation = location;
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.parentLocation != null) {
            return new Point(this.parentLocation.x + 10, this.parentLocation.y + 10);
        }
        return super.getInitialLocation(initialSize);
    }

    public abstract String[] getIds();

    public abstract List<Element> getElements();

    protected String[] getIds(String elemName) {
        if (this.doc == null || this.docURI == null || this.userDir == null) {
            return new String[0];
        }
        WebSphereServerInfo serverInfo = ConfigUtils.getServer((URI)this.docURI);
        return DOMUtils.getIds((Document)this.doc, (URI)this.docURI, (WebSphereServerInfo)serverInfo, (UserDirectory)this.userDir, (String)elemName);
    }

    protected String getRefString(String[] ids) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String id : ids) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(id);
        }
        return builder.toString();
    }

    public static String[] arrayAppend(String[] array, String newItem) {
        String[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = newItem;
        return newArray;
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.minimumWidth = 300;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        return composite;
    }

    protected void createBreadcrumb(Composite composite) {
        if (this.labels.length < 3) {
            return;
        }
        String breadcrumb = this.getBreadcrumb();
        String msg = NLS.bind((String)Messages.chainableConfigContext, (Object)breadcrumb);
        StyledText text = new StyledText(composite, 0);
        text.setBackground(composite.getBackground());
        text.setText(msg);
        text.setToolTipText(breadcrumb);
        StyleRange style = new StyleRange();
        style.start = 0;
        style.length = msg.length();
        style.fontStyle = 2;
        text.setStyleRange(style);
        GridData data = new GridData(1, 1, false, false);
        data.horizontalSpan = 3;
        text.setLayoutData((Object)data);
    }

    protected String getBreadcrumb() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String label : this.labels) {
            if (first) {
                first = false;
            } else {
                builder.append(" -> ");
            }
            builder.append(label);
        }
        return builder.toString();
    }

    protected static String getLabel(Document doc, String[] tags, URI docURI, String defaultLabel) {
        String label = SchemaUtil.getLabel((Document)doc, (String[])tags, (URI)docURI);
        if (label == null) {
            label = defaultLabel;
        }
        return label;
    }
}

