/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.ui.internal.actions.AbstractProviderAction;
import com.ibm.ws.st.ui.internal.actions.AbstractUtilityUIEnablementExtension;
import com.ibm.ws.st.ui.internal.actions.BaseLibertyUtilityUIEnablement;
import com.ibm.ws.st.ui.internal.actions.UtilityUIEnablementExtensionFactory;
import java.util.Iterator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;

public abstract class WebSphereUtilityAction
extends AbstractProviderAction {
    protected WebSphereServerInfo server;
    protected WebSphereServer wsServer;
    protected BaseLibertyUtilityUIEnablement baseEnablement = null;

    public WebSphereUtilityAction(String name, Shell shell, ISelectionProvider selProvider) {
        super(name, shell, selProvider);
    }

    @Override
    public boolean modifySelection(Iterator<?> iterator) {
        this.server = null;
        Object obj = iterator.next();
        this.server = obj instanceof WebSphereServerInfo ? (WebSphereServerInfo)obj : (WebSphereServerInfo)Platform.getAdapterManager().getAdapter(obj, WebSphereServerInfo.class);
        if (this.server == null) {
            this.setEnabled(false);
        }
        this.wsServer = WebSphereUtil.getWebSphereServer((WebSphereServerInfo)this.server);
        return this.selectionChanged(iterator);
    }

    @Override
    public abstract boolean selectionChanged(Iterator<?> var1);

    public boolean isUtilityRemoteSupported() {
        return true;
    }

    protected boolean notifyUtilityDisabled(String serverType, String utilityType) {
        AbstractUtilityUIEnablementExtension utilityClass = UtilityUIEnablementExtensionFactory.getServerUtilityUIEnablementOperation(this.wsServer.getServerType());
        if (utilityClass != null) {
            return utilityClass.notifyUtilityDisabled(this.getId(), this.wsServer, this, this.shell, serverType, utilityType);
        }
        return false;
    }

    protected boolean isDisableUtilityPrompted() {
        if (this.wsServer != null && !this.wsServer.isLocalSetup()) {
            if (!this.isUtilityRemoteSupported()) {
                return this.wsServer.getDisableUtilityPromptPref("utilityNotSupportedPrompt");
            }
            if (!this.wsServer.getIsRemoteServerStartEnabled()) {
                return this.wsServer.getDisableUtilityPromptPref("remoteSettingsDisabledPrompt");
            }
        }
        return false;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public WebSphereServer getServer() {
        return this.wsServer;
    }
}

