/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.actions.ConfigSnippetAction;
import com.ibm.ws.st.ui.internal.actions.DumpAction;
import com.ibm.ws.st.ui.internal.actions.NewConfigDropinAction;
import com.ibm.ws.st.ui.internal.actions.NewExtendedConfigAction;
import com.ibm.ws.st.ui.internal.actions.PackageAction;
import com.ibm.ws.st.ui.internal.actions.PluginConfigAction;
import com.ibm.ws.st.ui.internal.actions.SSLCertificateAction;
import com.ibm.ws.st.ui.internal.actions.WebSphereUtilityAction;
import com.ibm.ws.st.ui.internal.download.SiteHelper;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class UtilityActionProvider
extends CommonActionProvider {
    public static final String UTILITY_MENU_PATH = "utility";
    protected NewExtendedConfigAction[] createConfigActions = new NewExtendedConfigAction[2];
    protected NewExtendedConfigAction[] newJVMOptionsActions = new NewExtendedConfigAction[4];
    protected PackageAction packageAction;
    protected PluginConfigAction pluginConfigAction;
    protected DumpAction dumpAction;
    protected SSLCertificateAction generateSSLAction;
    protected ConfigSnippetAction configSnippetAction;
    protected NewConfigDropinAction[] newConfigDropinActions = new NewConfigDropinAction[2];

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        Shell shell = aSite.getViewSite().getShell();
        StructuredViewer viewer = aSite.getStructuredViewer();
        StructuredViewer selectionProvider = aSite.getStructuredViewer();
        this.createConfigActions[0] = new NewExtendedConfigAction("bootstrap.properties", (ISelectionProvider)selectionProvider, viewer);
        this.createConfigActions[1] = new NewExtendedConfigAction("server.env", (ISelectionProvider)selectionProvider, viewer);
        this.newConfigDropinActions[0] = new NewConfigDropinAction(NewConfigDropinAction.DropinType.DEFAULTS, (ISelectionProvider)selectionProvider, viewer);
        this.newConfigDropinActions[1] = new NewConfigDropinAction(NewConfigDropinAction.DropinType.OVERRIDES, (ISelectionProvider)selectionProvider, viewer);
        this.newJVMOptionsActions[0] = new NewExtendedConfigAction("jvm.options", (ISelectionProvider)selectionProvider, viewer, "${server.config.dir}");
        this.newJVMOptionsActions[1] = new NewExtendedConfigAction("jvm.options", (ISelectionProvider)selectionProvider, viewer, "${wlp.install.dir}/usr/shared");
        this.newJVMOptionsActions[2] = new NewExtendedConfigAction("jvm.options", (ISelectionProvider)selectionProvider, viewer, "${server.config.dir}/configDropins/defaults");
        this.newJVMOptionsActions[3] = new NewExtendedConfigAction("jvm.options", (ISelectionProvider)selectionProvider, viewer, "${server.config.dir}/configDropins/overrides");
        this.packageAction = new PackageAction(shell, (ISelectionProvider)selectionProvider);
        this.pluginConfigAction = new PluginConfigAction(shell, (ISelectionProvider)selectionProvider);
        this.dumpAction = new DumpAction(shell, (ISelectionProvider)selectionProvider);
        this.generateSSLAction = new SSLCertificateAction(shell, (ISelectionProvider)selectionProvider);
        this.configSnippetAction = new ConfigSnippetAction(shell, (ISelectionProvider)selectionProvider);
    }

    public void fillContextMenu(IMenuManager menu) {
        IMenuManager utilityMenu;
        IMenuManager newMenu = menu.findMenuUsingPath("org.eclipse.wst.server.ui.internal.cnf.newMenuId");
        if (newMenu != null) {
            MenuManager configMenu = new MenuManager(Messages.menuNewExtendedConfig, Activator.getImageDescriptor("bootstrap.properties"), "extendedConfig");
            for (int i = 0; i < this.createConfigActions.length; ++i) {
                configMenu.add((IAction)this.createConfigActions[i]);
            }
            MenuManager subConfigMenu = new MenuManager("jvm.options", Activator.getImageDescriptor("bootstrap.properties"), "jvm.options");
            for (int i = 0; i < this.newJVMOptionsActions.length; ++i) {
                subConfigMenu.add((IAction)this.newJVMOptionsActions[i]);
            }
            configMenu.add((IContributionItem)subConfigMenu);
            newMenu.add((IContributionItem)configMenu);
            MenuManager configDropinsMenu = new MenuManager(Messages.menuNewConfigDropin, Activator.getImageDescriptor("configFile"), "configDropins");
            for (int i = 0; i < this.newConfigDropinActions.length; ++i) {
                if (!this.newConfigDropinActions[i].isApplicable()) continue;
                configDropinsMenu.add((IAction)this.newConfigDropinActions[i]);
            }
            newMenu.add((IContributionItem)configDropinsMenu);
        }
        if ((utilityMenu = menu.findMenuUsingPath(UTILITY_MENU_PATH)) == null) {
            utilityMenu = new MenuManager(Messages.menuUtilities, UTILITY_MENU_PATH);
        }
        this.addAction(utilityMenu, this.generateSSLAction);
        this.addAction(utilityMenu, this.pluginConfigAction);
        utilityMenu.add((IContributionItem)new GroupMarker("packageserver"));
        this.addAction(utilityMenu, this.packageAction);
        utilityMenu.add((IContributionItem)new Separator());
        this.addAction(utilityMenu, this.dumpAction);
        if (SiteHelper.downloadAndInstallSupported()) {
            utilityMenu.add((IContributionItem)new Separator());
            this.addAction(utilityMenu, this.configSnippetAction);
        }
        menu.appendToGroup("additions", (IContributionItem)utilityMenu);
    }

    private void addAction(IMenuManager utilityMenu, WebSphereUtilityAction action) {
        WebSphereServer wsServer = action.getServer();
        if (wsServer == null || !wsServer.isLocalSetup() && !action.isUtilityRemoteSupported()) {
            return;
        }
        utilityMenu.add((IAction)action);
    }
}

