/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.core.internal.URIUtil;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.ConfigurationFolder;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.RuntimeExplorer;
import com.ibm.ws.st.ui.internal.Trace;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.wst.server.core.IServer;
import org.w3c.dom.Element;

public class NavigatorDropAdapter
extends CommonDropAdapterAssistant {
    protected URI sourceURI;
    protected URI sourceSharedURI;
    protected ConfigurationFile targetFile;
    protected UserDirectory targetUserDirectory;
    protected ConfigurationFolder targetFolder;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        ISelection s;
        this.targetFile = null;
        this.targetUserDirectory = null;
        this.targetFolder = null;
        this.sourceURI = null;
        this.sourceSharedURI = null;
        if (target instanceof IServer) {
            IServer server = (IServer)target;
            WebSphereServer wsServer = (WebSphereServer)server.loadAdapter(WebSphereServer.class, null);
            if (wsServer != null) {
                this.targetFile = wsServer.getConfiguration();
            }
        } else if (target instanceof Element) {
            Element element = (Element)target;
            String uri = (String)element.getOwnerDocument().getUserData("uri");
            if (uri != null) {
                this.targetFile = ConfigUtils.getConfigFile((String)uri);
            }
        } else if (target instanceof RuntimeExplorer.Node) {
            RuntimeExplorer.Node node = (RuntimeExplorer.Node)target;
            if (RuntimeExplorer.NodeType.SHARED_CONFIGURATIONS.equals((Object)node.getType())) {
                this.targetUserDirectory = node.getUserDirectory();
            }
        } else if (target instanceof ConfigurationFolder) {
            this.targetFolder = (ConfigurationFolder)target;
            this.targetUserDirectory = this.targetFolder.getUserDirectory();
        } else if (target instanceof ConfigurationFile) {
            this.targetFile = (ConfigurationFile)target;
        }
        if (this.targetFile == null && this.targetUserDirectory == null) {
            return Status.CANCEL_STATUS;
        }
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType) && !(s = LocalSelectionTransfer.getTransfer().getSelection()).isEmpty() && s instanceof IStructuredSelection) {
            IFile file;
            IStructuredSelection sel = (IStructuredSelection)s;
            Object obj = sel.getFirstElement();
            if (obj instanceof Element) {
                Element element = (Element)obj;
                ConfigurationFile configFile = null;
                String uri = (String)element.getOwnerDocument().getUserData("uri");
                if (uri != null) {
                    configFile = ConfigUtils.getConfigFile((String)uri);
                }
                if (configFile == null) return Status.CANCEL_STATUS;
                this.sourceURI = configFile.getURI();
                if (ConfigurationFile.LOCATION_TYPE.SHARED == configFile.getLocationType()) {
                    this.sourceSharedURI = configFile.getUserDirectory().getSharedConfigURI();
                }
            } else if (obj instanceof ConfigurationFile) {
                ConfigurationFile configFile = (ConfigurationFile)obj;
                this.sourceURI = configFile.getURI();
                if (ConfigurationFile.LOCATION_TYPE.SHARED == configFile.getLocationType()) {
                    this.sourceSharedURI = configFile.getUserDirectory().getSharedConfigURI();
                }
            } else if (obj instanceof IFile && ConfigUtils.isServerConfigFile((IFile)(file = (IFile)obj))) {
                this.sourceURI = file.getLocation().toFile().toURI();
                int index = this.sourceURI.toString().indexOf("shared/config");
                if (index > 0) {
                    this.sourceSharedURI = this.sourceURI;
                }
            }
        }
        if (this.sourceURI == null) {
            return Status.CANCEL_STATUS;
        }
        if (this.targetFile == null || !this.targetFile.getURI().equals(this.sourceURI)) return Status.OK_STATUS;
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        try {
            if (this.targetUserDirectory != null) {
                return this.addSharedConfigFile();
            }
            return this.addIncludeElement();
        }
        catch (Exception e) {
            Trace.logError("Error dropping configuration file: " + this.sourceURI, e);
            return new Status(4, "com.ibm.ws.st.ui", "Error dropping configuration file", (Throwable)e);
        }
    }

    private IStatus addIncludeElement() throws IOException {
        WebSphereServerInfo[] servers;
        ConfigurationFile[] included;
        for (ConfigurationFile icf : included = this.targetFile.getAllIncludedFiles()) {
            if (!icf.getURI().equals(this.sourceURI)) continue;
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.title, (String)NLS.bind((String)Messages.errorAlreadyIncluded, (Object)this.sourceURI.toASCIIString()));
            return Status.CANCEL_STATUS;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.title, (String)Messages.taskAddInclude)) {
            return Status.CANCEL_STATUS;
        }
        String includeString = null;
        if (ConfigurationFile.LOCATION_TYPE.SHARED != this.targetFile.getLocationType() && this.sourceSharedURI != null && this.targetFile.getUserDirectory().getSharedConfigURI().equals(this.sourceSharedURI)) {
            URI relative = URIUtil.canonicalRelativize((URI)this.sourceSharedURI, (URI)this.sourceURI);
            includeString = "${shared.config.dir}/" + relative.toASCIIString();
        } else {
            URI targetURI = this.targetFile.getURI();
            URI relative = URIUtil.canonicalRelativize((URI)targetURI, (URI)this.sourceURI);
            if (!relative.isAbsolute()) {
                includeString = relative.toASCIIString();
            } else {
                includeString = this.sourceURI.getPath();
                if (System.getProperty("os.name").toLowerCase().contains("windows") && includeString.startsWith("/")) {
                    includeString = includeString.substring(1);
                }
            }
        }
        WebSphereServerInfo wsServer = null;
        for (WebSphereServerInfo server : servers = WebSphereUtil.getWebSphereServerInfos()) {
            ConfigurationFile configFile = server.getConfigurationFileFromURI(this.targetFile.getURI());
            if (configFile == null) continue;
            wsServer = server;
        }
        if (wsServer != null) {
            wsServer.updateCache();
        }
        this.targetFile.addInclude(false, includeString);
        this.targetFile.save(null);
        if (wsServer != null) {
            wsServer.updateCache();
        }
        return Status.OK_STATUS;
    }

    private IStatus addSharedConfigFile() throws MalformedURLException {
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.title, (String)Messages.taskAddSharedConfigFile)) {
            return this.targetUserDirectory.addSharedConfigFile(this.targetFolder, this.sourceURI.toURL());
        }
        return Status.CANCEL_STATUS;
    }
}

