/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.liberty.gradle.servertype.internal;

import com.ibm.ws.st.core.internal.PublishUnit;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.ConfigurationType;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.ILibertyBuildPluginImpl;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.LibertyBuildPluginConfiguration;
import com.ibm.ws.st.liberty.buildplugin.integration.manager.internal.AbstractLibertyProjectMapping;
import com.ibm.ws.st.liberty.buildplugin.integration.servertype.internal.AbstractLibertyBuildPluginJEEPublisher;
import com.ibm.ws.st.liberty.gradle.internal.LibertyGradle;
import com.ibm.ws.st.liberty.gradle.internal.LibertyGradleConstants;
import com.ibm.ws.st.liberty.gradle.internal.Messages;
import com.ibm.ws.st.liberty.gradle.internal.Trace;
import com.ibm.ws.st.liberty.gradle.manager.internal.LibertyGradleProjectMapping;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;

public class LibertyGradleJEEPublisher
extends AbstractLibertyBuildPluginJEEPublisher {
    public ILibertyBuildPluginImpl getBuildPluginImpl() {
        return LibertyGradle.getInstance();
    }

    public void postPublishApplication(int kind, PublishUnit app, MultiStatus status, IProgressMonitor monitor) {
        String type;
        WebSphereServer wsServer = this.getWebSphereServer();
        if (wsServer != null && "LibertyGradle".equals(type = wsServer.getServerType())) {
            super.postPublishApplication(kind, app, status, monitor);
        }
    }

    public void publishModuleAndChildren(int kind, PublishUnit unit, MultiStatus mStatus, IProgressMonitor monitor) {
        String type;
        WebSphereServer wsServer = this.getWebSphereServer();
        if (wsServer != null && "LibertyGradle".equals(type = wsServer.getServerType()) && unit != null) {
            IModule module = unit.getModule()[0];
            IProject moduleProject = module.getProject();
            AbstractLibertyProjectMapping.ProjectMapping mapping = LibertyGradleProjectMapping.getInstance().getMapping(moduleProject.getName());
            if (mapping != null && mapping.getServerID().equals(wsServer.getServer().getId())) {
                LibertyBuildPluginConfiguration config = LibertyGradle.getLibertyGradleProjectConfiguration(moduleProject, monitor);
                String looseConfigValue = config.getConfigValue(ConfigurationType.looseApplication);
                boolean isLC = Boolean.parseBoolean(looseConfigValue);
                int publishUnitKind = unit.getDeltaKind();
                String parentId = config.getConfigValue(ConfigurationType.aggregatorParentId);
                String parentPath = config.getConfigValue(ConfigurationType.aggregatorParentBasedir);
                if (!(isLC || parentId == null || parentPath == null || 1 != publishUnitKind && 2 != publishUnitKind)) {
                    this.publishOnParent(wsServer, moduleProject, config, LibertyGradleConstants.ASSEMBLE_INSTALL_APPS_TASKS, kind, unit, mStatus, monitor);
                    String pathToPublishedModule = this.getPathToPublishedModule(config);
                    if (!pathToPublishedModule.equals("")) {
                        this.getChangedResourceList().add(pathToPublishedModule);
                        try {
                            this.notifyUpdatedApplicationResourcesViaJMX();
                        }
                        catch (Exception e) {
                            Trace.logError("Failed to notify app update via jmx", e);
                        }
                    }
                    return;
                }
            }
            super.publishModuleAndChildren(kind, unit, mStatus, monitor);
        }
    }

    protected void publishOnParent(WebSphereServer wsServer, IProject moduleProject, LibertyBuildPluginConfiguration config, String[] tasks, int kind, PublishUnit unit, MultiStatus mStatus, IProgressMonitor monitor) {
        Path gradleCommandLocation = null;
        String parentPath = config.getConfigValue(ConfigurationType.aggregatorParentBasedir);
        if (parentPath != null) {
            if (!new File(parentPath).exists()) {
                mStatus.add((IStatus)new Status(4, "com.ibm.ws.st.liberty.gradle", NLS.bind((String)Messages.errorParentPOMLocationDoesNotExist, (Object)parentPath)));
                return;
            }
        } else {
            return;
        }
        gradleCommandLocation = new Path(parentPath);
        LibertyGradle.runGradleTask((IPath)gradleCommandLocation, tasks, null, monitor);
        wsServer.ensureLocalConnectorAndAppMBeanConfig(monitor);
    }

    protected IStatus publishModule(int kind, PublishUnit publishUnit, IProgressMonitor monitor) {
        IProject moduleProject;
        IModule module;
        String type;
        WebSphereServer wsServer = this.getWebSphereServer();
        WebSphereServerBehaviour wsBehaviour = this.getWebSphereServerBehaviour();
        if (wsServer != null && wsBehaviour != null && "LibertyGradle".equals(type = wsServer.getServerType()) && publishUnit != null && !(module = publishUnit.getModule()[0]).isExternal() && (moduleProject = module.getProject()) != null) {
            AbstractLibertyProjectMapping.ProjectMapping mapping = LibertyGradleProjectMapping.getInstance().getMapping(moduleProject.getName());
            if (mapping != null && mapping.getServerID().equals(wsServer.getServer().getId())) {
                if (wsServer.isLooseConfigEnabled()) {
                    super.publishModule(kind, publishUnit, monitor);
                } else {
                    File f;
                    int publishUnitKind;
                    LibertyBuildPluginConfiguration config = LibertyGradle.getLibertyGradleProjectConfiguration(moduleProject, monitor);
                    String serverDir = config.getConfigValue(ConfigurationType.serverDirectory);
                    String appsDir = config.getConfigValue(ConfigurationType.appsDirectory);
                    String appName = config.getConfigValue(ConfigurationType.applicationFilename);
                    Trace.trace((byte)0, "serverDir: " + serverDir + " appsDir:" + appsDir + " appName:" + appName);
                    String pathToPublishedModule = "";
                    if (serverDir != null && appsDir != null && appName != null) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append(serverDir);
                        buffer.append("/");
                        buffer.append(appsDir);
                        buffer.append("/");
                        buffer.append(appName);
                        pathToPublishedModule = buffer.toString();
                    }
                    if (1 == (publishUnitKind = publishUnit.getDeltaKind()) || 2 == publishUnitKind) {
                        if (serverDir == null || appsDir == null || appName == null) {
                            LibertyGradle.runGradleTask(moduleProject.getLocation(), LibertyGradleConstants.ASSEMBLE_INSTALL_APPS_TASKS, null, monitor);
                        } else {
                            LibertyGradle.runGradleTask(moduleProject.getLocation(), LibertyGradleConstants.ASSEMBLE_INSTALL_APPS_TASKS, null, monitor);
                            wsServer.ensureLocalConnectorAndAppMBeanConfig(monitor);
                            this.getChangedResourceList().add(pathToPublishedModule);
                        }
                    } else if (3 == publishUnitKind && (f = new File(pathToPublishedModule)).exists() && !f.delete()) {
                        Trace.trace((byte)1, "Failed to cleanup published module");
                    }
                }
                if (3 == publishUnit.getDeltaKind()) {
                    this.removePublishedAppFiles(publishUnit, true, new MultiStatus("com.ibm.ws.st.liberty.gradle", 0, null, null), monitor);
                }
            } else if (this.getBuildPluginImpl().isDependencyModule(moduleProject, wsServer.getServer())) {
                if (wsServer.isLooseConfigEnabled()) {
                    super.publishModule(kind, publishUnit, monitor);
                } else {
                    IProject mappedProject = LibertyGradle.getMappedProject(wsServer.getServer());
                    LibertyBuildPluginConfiguration config = LibertyGradle.getLibertyGradleProjectConfiguration(mappedProject, monitor);
                    String parentId = config.getConfigValue(ConfigurationType.aggregatorParentId);
                    String parentBaseDir = config.getConfigValue(ConfigurationType.aggregatorParentBasedir);
                    if (parentId != null && parentBaseDir != null) {
                        Path parentPath = new Path(parentBaseDir);
                        if (!parentPath.toFile().exists()) {
                            return new Status(4, "com.ibm.ws.st.liberty.gradle", "The parent project could not be found " + parentId + " : " + parentBaseDir);
                        }
                        LibertyGradle.runGradleTask(moduleProject.getLocation(), LibertyGradleConstants.ASSEMBLE_INSTALL_APPS_TASKS, null, monitor);
                    }
                    LibertyGradle.runGradleTask(mappedProject.getLocation(), LibertyGradleConstants.ASSEMBLE_INSTALL_APPS_TASKS, null, monitor);
                    wsServer.ensureLocalConnectorAndAppMBeanConfig(monitor);
                }
            }
        }
        return Status.OK_STATUS;
    }

    public void prePublishApplication(int kind, PublishUnit app, MultiStatus status, IProgressMonitor monitor) {
        String type;
        WebSphereServer wsServer = this.getWebSphereServer();
        if (wsServer != null && "LibertyGradle".equals(type = wsServer.getServerType())) {
            super.prePublishApplication(kind, app, status, monitor);
        }
    }
}

