/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.liberty.gradle.internal;

import com.ibm.ws.st.liberty.buildplugin.integration.internal.ConfigurationType;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.ILibertyBuildPluginImpl;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.IProjectInspector;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.LibertyBuildPluginConfiguration;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.Trace;
import com.ibm.ws.st.liberty.buildplugin.integration.manager.internal.AbstractLibertyProjectMapping;
import com.ibm.ws.st.liberty.gradle.internal.LibertyGradleConstants;
import com.ibm.ws.st.liberty.gradle.manager.internal.GradleProjectInspector;
import com.ibm.ws.st.liberty.gradle.manager.internal.LibertyGradleProjectMapping;
import com.ibm.ws.st.liberty.gradle.manager.internal.LibertyManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.ResultHandler;

public class LibertyGradle
implements ILibertyBuildPluginImpl {
    private static LibertyGradle instance = new LibertyGradle();

    private LibertyGradle() {
    }

    public static ILibertyBuildPluginImpl getInstance() {
        return instance;
    }

    public static boolean isGradleProject(IProject project, IProgressMonitor monitor) {
        return instance.getProjectInspector(project, monitor).isGradleProject();
    }

    public static LibertyBuildPluginConfiguration getLibertyGradleProjectConfiguration(IProject project, IProgressMonitor monitor) {
        return instance.getProjectInspector(project, monitor).getBuildPluginConfiguration(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runGradleTask(IPath workingDir, final String[] tasks, String[] args, IProgressMonitor monitor) {
        boolean isSuccessful = true;
        final ArrayList<String> arguments = args != null ? Arrays.asList(args) : new ArrayList<String>();
        LibertyGradle.addArgs(arguments, LibertyGradleConstants.SKIP_TESTS_ARGS);
        LibertyGradle.addArgs(arguments, LibertyGradleConstants.SKIP_LIBERTY_PKG_ARGS);
        if (Trace.ENABLED) {
            Trace.trace((byte)0, (String)("Running gradle tasks: " + Arrays.toString(tasks) + ", with arguments: " + arguments));
        }
        try (ProjectConnection connection = null;){
            final Boolean[] result = new Boolean[1];
            CancellationTokenSource cancelTokenSrc = GradleConnector.newCancellationTokenSource();
            GradleConnector connector = GradleConnector.newConnector();
            String override = System.getProperty("GRADLE_VERSION_OVERRIDE");
            if (override != null) {
                connector.useGradleVersion(override);
            }
            connector = connector.forProjectDirectory(new File(workingDir.toOSString()));
            connection = connector.connect();
            BuildLauncher build = connection.newBuild();
            build.forTasks(tasks);
            build.withArguments(arguments.toArray(new String[arguments.size()]));
            build.withCancellationToken(cancelTokenSrc.token());
            ResultHandler<Void> handler = new ResultHandler<Void>(){

                public void onComplete(Void arg0) {
                    result[0] = Boolean.TRUE;
                }

                public void onFailure(GradleConnectionException e) {
                    result[0] = Boolean.FALSE;
                    Trace.logError((String)("The gradle command failed for tasks: " + Arrays.toString(tasks) + ", and arguments: " + arguments), (Throwable)e);
                }
            };
            build.run((ResultHandler)handler);
            while (result[0] == null && !monitor.isCanceled()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (monitor.isCanceled()) {
                cancelTokenSrc.cancel();
                boolean bl = false;
                return bl;
            }
            if (result[0] != null) {
                isSuccessful = result[0];
            }
        }
        return isSuccessful;
    }

    private static void addArgs(List<String> argumentList, String ... argsToAdd) {
        for (String arg : argsToAdd) {
            argumentList.add(arg);
        }
    }

    public static Set<String> getTrackedProjects() {
        return LibertyGradleProjectMapping.getInstance().getMappedProjectSet();
    }

    public static IProject getMappedProject(IServer server) {
        if (server == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, (String)"The server argument is null.");
            }
            return null;
        }
        return LibertyGradleProjectMapping.getInstance().getMappedProject(server);
    }

    public static IServer getMappedServer(String projectName) {
        AbstractLibertyProjectMapping.ProjectMapping mapping = LibertyGradleProjectMapping.getInstance().getMapping(projectName);
        if (mapping == null || mapping.getServerID() == null) {
            return null;
        }
        return ServerCore.findServer((String)mapping.getServerID());
    }

    private GradleProjectInspector getProjectInspector(IProject project, IProgressMonitor monitor) {
        return new GradleProjectInspector(project);
    }

    public boolean isSupportedProject(IProject project, IProgressMonitor monitor) {
        return instance.getProjectInspector(project, monitor).isSupportedProject(monitor);
    }

    public void updateSrcConfig(IProject project, LibertyBuildPluginConfiguration config, IProgressMonitor monitor) {
        String[] tasks = new String[]{"libertyCreate"};
        IPath location = project.getLocation();
        LibertyGradle.runGradleTask(location, tasks, null, monitor);
    }

    public LibertyBuildPluginConfiguration getLibertyBuildPluginConfiguration(IProject project, IProgressMonitor monitor) {
        return LibertyGradle.getLibertyGradleProjectConfiguration(project, monitor);
    }

    public String getRelativeBuildPluginConfigurationFileLocation() {
        return "/build/liberty-plugin-config.xml";
    }

    public IStatus preServerSetup(IProject project, LibertyBuildPluginConfiguration config, IPath serverPath, IProgressMonitor monitor) {
        String parentId = config.getConfigValue(ConfigurationType.aggregatorParentId);
        String parentBaseDir = config.getConfigValue(ConfigurationType.aggregatorParentBasedir);
        List profiles = config.getActiveBuildProfiles();
        if (parentId != null && parentBaseDir != null) {
            Path parentPath = new Path(parentBaseDir);
            if (!parentPath.toFile().exists()) {
                return new Status(4, "com.ibm.ws.st.liberty.buildplugin.integration", "The parent project could not be found " + parentId + " : " + parentBaseDir);
            }
            LibertyGradle.runGradleTask((IPath)parentPath, LibertyGradleConstants.ASSEMBLE_INSTALL_APPS_TASKS, null, monitor);
        }
        if (!serverPath.toFile().exists()) {
            LibertyGradle.runGradleTask(project.getLocation(), LibertyGradleConstants.ASSEMBLE_INSTALL_APPS_TASKS, null, monitor);
        }
        return Status.OK_STATUS;
    }

    public String getServerType() {
        return "LibertyGradle";
    }

    public boolean isDependencyModule(IProject moduleProject, IServer server) {
        IProject project = LibertyGradle.getMappedProject(server);
        if (project != null) {
            try {
                IModule[] modules;
                GradleProjectInspector pi = new GradleProjectInspector(project);
                for (IModule m : modules = pi.getProjectModules()) {
                    if (!m.getProject().equals(moduleProject)) continue;
                    return true;
                }
            }
            catch (Exception e) {
                Trace.logError((String)("Liberty Gradle module lookup hit an error for project " + project.getName()), (Throwable)e);
            }
        }
        return false;
    }

    public AbstractLibertyProjectMapping getMappingHandler() {
        return LibertyGradleProjectMapping.getInstance();
    }

    public IProjectInspector getProjectInspector(IProject project) {
        return new GradleProjectInspector(project);
    }

    public void triggerAddRuntimeAndServer(IProject project, IProgressMonitor monitor) {
        LibertyManager.getInstance().triggerAddProject(project, monitor);
    }
}

