/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xwt.dde.internal.viewers;

import com.ibm.xwt.dde.DDEPlugin;
import com.ibm.xwt.dde.internal.actions.MoveAction;
import com.ibm.xwt.dde.internal.customization.CustomizationManager;
import com.ibm.xwt.dde.internal.messages.Messages;
import com.ibm.xwt.dde.internal.util.ModelUtil;
import com.ibm.xwt.dde.internal.viewers.DDEViewer;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Element;

public class TreeItemMenuListener
implements IMenuListener {
    private DDEViewer ddeViewer;
    private CustomizationManager.Customization customization;
    private IEditorPart editorPart;

    public TreeItemMenuListener(DDEViewer ddeViewer, CustomizationManager.Customization customization, IEditorPart editorPart) {
        this.ddeViewer = ddeViewer;
        this.customization = customization;
        this.editorPart = editorPart;
    }

    public void menuAboutToShow(IMenuManager manager) {
        IStructuredSelection structuredSelection;
        ISelection selection = this.ddeViewer.getTreeViewer().getSelection();
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).getFirstElement() instanceof Element) {
            Element element = (Element)structuredSelection.getFirstElement();
            this.fillContextMenu(manager, element);
            manager.add((IContributionItem)new GroupMarker("additions"));
        }
    }

    private void fillContextMenu(IMenuManager manager, Element element) {
        List insertActions;
        if (!this.ddeViewer.isReadOnlyMode() && this.ddeViewer.getTreeViewer().getTree().getSelection().length == 1 && (insertActions = ModelUtil.getInsertActions(element, this.customization, this.ddeViewer, this.editorPart)).size() > 0) {
            MenuManager insertSubMenu = new MenuManager(Messages.ADD_WITH_MNEMONIC, DDEPlugin.getDefault().getImageDescriptor("icons/add.gif"), null);
            Action[] insertActionsArray = insertActions.toArray(new Action[insertActions.size()]);
            Comparator comparator = new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    Action a = (Action)arg0;
                    Action b = (Action)arg1;
                    return Collator.getInstance().compare(a.getText(), b.getText());
                }
            };
            Arrays.sort(insertActionsArray, comparator);
            for (int i = 0; i < insertActionsArray.length; ++i) {
                insertSubMenu.add((IAction)insertActionsArray[i]);
            }
            manager.add((IContributionItem)insertSubMenu);
        }
        Action deletionAction = new Action(){

            public void run() {
                TreeItemMenuListener.this.ddeViewer.performDelete();
            }
        };
        boolean enableRemove = true;
        TreeItem[] treeItems = this.ddeViewer.getTreeViewer().getTree().getSelection();
        for (int i = 0; i < treeItems.length && enableRemove; ++i) {
            Object object = treeItems[i].getData();
            if (!(object instanceof Element)) continue;
            Element currentElement = (Element)object;
            enableRemove = ModelUtil.canDeleteElement(currentElement, this.customization, this.editorPart);
        }
        deletionAction.setEnabled(enableRemove);
        deletionAction.setImageDescriptor(DDEPlugin.getDefault().getImageDescriptor("icons/remove.gif"));
        deletionAction.setText(Messages.REMOVE_WITH_MNEMONIC);
        Separator separator = new Separator();
        MoveAction moveUpAction = new MoveAction(this.ddeViewer, true);
        MoveAction moveDownAction = new MoveAction(this.ddeViewer, false);
        if (this.ddeViewer.isReadOnlyMode()) {
            deletionAction.setEnabled(false);
            moveUpAction.setEnabled(false);
            moveDownAction.setEnabled(false);
        }
        manager.add((IAction)deletionAction);
        manager.add((IContributionItem)separator);
        manager.add((IAction)moveUpAction);
        manager.add((IAction)moveDownAction);
    }
}

