/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xwt.dde.editor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ReadOnlyFileStorage
implements IStorage {
    private final File file;
    private InputStream stream = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadOnlyFileStorage(File input) {
        this.file = input;
        FileInputStream fis = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int length;
            fis = new FileInputStream(this.file);
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) > 0) {
                bos.write(buffer, 0, length);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.stream = new ByteArrayInputStream(bos.toByteArray());
        }
    }

    public Object getAdapter(Class arg0) {
        return null;
    }

    public InputStream getContents() throws CoreException {
        return this.stream;
    }

    public IPath getFullPath() {
        return new Path(this.file.getAbsolutePath());
    }

    public String getName() {
        return this.file.getName();
    }

    public boolean isReadOnly() {
        return true;
    }
}

