/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xwt.dde.editor;

import com.ibm.xwt.dde.internal.customization.CustomizationManager;
import com.ibm.xwt.dde.internal.util.ModelUtil;
import com.ibm.xwt.dde.internal.validation.ValidationManager;
import com.ibm.xwt.dde.internal.viewers.DDEViewerDelegate;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.ui.internal.tabletree.IDesignViewer;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DDEMultiPageEditorPart
extends XMLMultiPageEditorPart {
    public static int DESIGN_VIEW_PAGE = 0;
    public static int SOURCE_VIEW_PAGE = 1;
    private DDEViewerDelegate ddeViewerDelegate;
    private IAnnotationModelListener annotationModelListener;
    private ActivationListener activationListener;
    private boolean pageCreationInProgress = false;

    public DDEMultiPageEditorPart() {
        this.noToolbar();
    }

    public void setSelection(String path, String namespaceData) {
        Document document = this.ddeViewerDelegate.getDocument();
        NodeList nodeList = ModelUtil.runXPathAgainstDocument(document, path, namespaceData);
        if (nodeList != null && nodeList.getLength() > 0) {
            Node node = nodeList.item(0);
            StructuredSelection selection = new StructuredSelection((Object)node);
            if (this.getActivePage() == DESIGN_VIEW_PAGE) {
                this.ddeViewerDelegate.setSelection((ISelection)selection, true);
            } else {
                StructuredTextEditor structuredTextEditor;
                ISelectionProvider selectionProvider;
                Object object = this.getAdapter(ITextEditor.class);
                if (object instanceof StructuredTextEditor && (selectionProvider = (structuredTextEditor = (StructuredTextEditor)object).getSelectionProvider()) != null) {
                    selectionProvider.setSelection((ISelection)selection);
                }
            }
        }
    }

    public Element getDocumentElement() {
        return this.ddeViewerDelegate.getDocument().getDocumentElement();
    }

    public void setSelection(Node node) {
        StructuredSelection selection = new StructuredSelection((Object)node);
        if (this.getActivePage() == DESIGN_VIEW_PAGE) {
            this.ddeViewerDelegate.setSelection((ISelection)selection, true);
        } else {
            StructuredTextEditor structuredTextEditor;
            ISelectionProvider selectionProvider;
            Object object = this.getAdapter(ITextEditor.class);
            if (object instanceof StructuredTextEditor && (selectionProvider = (structuredTextEditor = (StructuredTextEditor)object).getSelectionProvider()) != null) {
                selectionProvider.setSelection((ISelection)selection);
            }
        }
    }

    public int getEditorActivePage() {
        return this.getActivePage();
    }

    public boolean isDesignPageActiveAndInFocus() {
        if (this.ddeViewerDelegate != null) {
            return this.ddeViewerDelegate.isDesignViewActive();
        }
        return false;
    }

    public void setEditorActivePage(int page) {
        if (page != this.getActivePage()) {
            if (page == DESIGN_VIEW_PAGE) {
                this.setActivePage(0);
            } else {
                this.setActivePage(1);
            }
        }
    }

    protected void createPages() {
        this.pageCreationInProgress = true;
        super.createPages();
        Object object = this.getAdapter(ITextEditor.class);
        if (object instanceof StructuredTextEditor) {
            StructuredTextEditor structuredTextEditor = (StructuredTextEditor)object;
            IActionBars actionBars = ((IEditorSite)this.getSite()).getActionBars();
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, structuredTextEditor.getAction(ITextEditorActionConstants.UNDO));
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, structuredTextEditor.getAction(ITextEditorActionConstants.REDO));
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.REVERT_TO_SAVED, structuredTextEditor.getAction(ITextEditorActionConstants.REVERT_TO_SAVED));
            IAnnotationModel annotationModel = structuredTextEditor.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
            this.annotationModelListener = new IAnnotationModelListener(){

                public void modelChanged(IAnnotationModel model) {
                    DDEMultiPageEditorPart.this.ddeViewerDelegate.updateErrorsFromAnnotationModel(model);
                }
            };
            annotationModel.addAnnotationModelListener(this.annotationModelListener);
        }
        this.pageCreationInProgress = false;
    }

    public void refresh() {
        this.ddeViewerDelegate.refresh(true);
    }

    public void refreshDocumentValidation() {
        this.ddeViewerDelegate.getValidationManager().validateDocument();
    }

    public void resetCustomizations() {
        CustomizationManager.getInstance().resetCustomizations();
        this.ddeViewerDelegate.activateDesignView();
        this.ddeViewerDelegate.refresh(true);
    }

    public void showCustomizedTitle() {
        String editorTitle;
        CustomizationManager.Customization customization = CustomizationManager.getInstance().getCustomization(this.getSite().getId());
        if (customization != null && (editorTitle = customization.getEditorTitle()) != null) {
            this.setPartName(editorTitle);
        }
    }

    protected IDesignViewer createDesignPage() {
        CustomizationManager.Customization customization = CustomizationManager.getInstance().getCustomization(this.getSite().getId());
        this.showCustomizedTitle();
        this.ddeViewerDelegate = new DDEViewerDelegate(this.getContainer(), customization, (IEditorPart)this);
        this.activationListener = new ActivationListener(this.getSite().getWorkbenchWindow().getPartService());
        return this.ddeViewerDelegate;
    }

    protected void pageChange(int newPageIndex) {
        if (!this.pageCreationInProgress) {
            super.pageChange(newPageIndex);
            if (this.getActivePage() == DESIGN_VIEW_PAGE) {
                this.ddeViewerDelegate.activateDesignView();
            } else {
                this.ddeViewerDelegate.deActivateDesignView();
            }
        } else {
            this.activateSite();
        }
    }

    public ValidationManager getValidationManager() {
        return this.ddeViewerDelegate.getValidationManager();
    }

    public void dispose() {
        this.ddeViewerDelegate.dispose();
        Object object = this.getAdapter(ITextEditor.class);
        if (object instanceof StructuredTextEditor) {
            StructuredTextEditor structuredTextEditor = (StructuredTextEditor)object;
            IAnnotationModel annotationModel = structuredTextEditor.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
            annotationModel.removeAnnotationModelListener(this.annotationModelListener);
        }
        if (this.activationListener != null) {
            this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this.activationListener);
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.activationListener);
        }
        super.dispose();
        this.ddeViewerDelegate = null;
    }

    public boolean validateEditorInput() {
        Object object = this.getAdapter(ITextEditor.class);
        if (object instanceof StructuredTextEditor) {
            StructuredTextEditor structuredTextEditor = (StructuredTextEditor)object;
            structuredTextEditor.safelySanityCheckState(this.getEditorInput());
            return structuredTextEditor.validateEditorInputState();
        }
        return true;
    }

    public Composite getFormHeadComposite() {
        return this.ddeViewerDelegate.getFormHeadComposite();
    }

    class ActivationListener
    implements IPartListener,
    IWindowListener {
        public ActivationListener(IPartService partService) {
            partService.addPartListener((IPartListener)this);
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        }

        public void partActivated(IWorkbenchPart part) {
            if (((Object)((Object)DDEMultiPageEditorPart.this)).equals(part) && DDEMultiPageEditorPart.this.getActivePage() == DESIGN_VIEW_PAGE) {
                DDEMultiPageEditorPart.this.ddeViewerDelegate.activateDesignView();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (((Object)((Object)DDEMultiPageEditorPart.this)).equals(part) && DDEMultiPageEditorPart.this.getActivePage() == DESIGN_VIEW_PAGE) {
                DDEMultiPageEditorPart.this.ddeViewerDelegate.deActivateDesignView();
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }
}

