/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.docker.ui.internal.wizard;

import com.ibm.ws.st.common.core.ext.internal.setuphandlers.IPlatformHandler;
import com.ibm.ws.st.common.core.ext.internal.util.BaseDockerContainer;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.config.ServerEnv;
import com.ibm.ws.st.docker.ui.internal.Trace;
import java.io.File;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;

public class LibertyDockerUtil {
    protected static final String OS_NAME = "osName";
    protected static final String DOCKER_MACHINE_TYPE = "dockerMachineType";
    protected static final String DOCKER_MACHINE = "dockerMachine";
    protected static final String DOCKER_CONTAINER = "dockerContainer";
    protected static final String DOCKER_IMAGE = "dockerImage";
    protected static final String LIBERTY_SERVER_NAME = "libertyServerName";
    protected static final String HOSTNAME = "hostname";
    protected static final String LIBERTY_HTTPS_PORT = "libertyHttpsPort";
    public static final String LIBERTY_RUNTIME_INSTALL_PATH = "LibertyRuntimeInstallPath";
    public static final String LIBERTY_SERVER_CONFIG_PATH = "libertyServerConfigPath";
    public static final String DROPINS_DIR = "configDropins";
    public static final String DEFAULTS_DIR = "defaults";

    public static boolean isLibertyContainer(BaseDockerContainer container) {
        try {
            List processes = container.getContainerProcesses();
            for (BaseDockerContainer.DockerProcess process : processes) {
                for (String cmdItem : process.getCommand()) {
                    if (!cmdItem.contains("ws-server.jar")) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            Trace.logError("Could not get liberty container processes.", e);
        }
        return false;
    }

    protected static Map<String, String> getLibertyServerInfoMap(BaseDockerContainer container, WebSphereServer server) {
        String wlpUserDir;
        String serverConfigPath;
        String serverName;
        HashMap<String, String> libertyServerInfo;
        block27: {
            block26: {
                String installPath;
                block25: {
                    libertyServerInfo = new HashMap<String, String>();
                    installPath = "/opt/ibm/wlp";
                    serverName = "defaultServer";
                    try {
                        if (!container.directoryExists(installPath)) {
                            String olInstallPath = "/opt/ol/wlp";
                            if (container.directoryExists(olInstallPath)) {
                                installPath = olInstallPath;
                            } else {
                                Trace.logError("The expected install path for the runtime does not exist in the container.", null);
                            }
                        }
                    }
                    catch (Exception e) {
                        Trace.logError("Could not determine if the expected runtime install path exists", e);
                    }
                    try {
                        List command = container.getCommand();
                        if (command.size() >= 3 && ((String)command.get(0)).endsWith("server")) {
                            String exec = (String)command.get(0);
                            IPlatformHandler.ExecutionOutput result = container.dockerExec("which " + exec);
                            if (result.getReturnCode() == 0) {
                                String execPath = result.getOutput().trim();
                                int index = execPath.indexOf("/bin/server");
                                if (index > 0) {
                                    installPath = execPath.substring(0, index);
                                } else if (Trace.ENABLED) {
                                    Trace.logError("The executable component of the container command does not end in /bin/server as expected: " + execPath + ".  Using the default install path: " + installPath, null);
                                }
                                serverName = (String)command.get(command.size() - 1);
                            } else if (Trace.ENABLED) {
                                Trace.logError("Failed to get the path for the 'server' command: " + result.getOutput(), null);
                            }
                        } else if (Trace.ENABLED) {
                            Trace.logError("Container command did not match expected format: " + LibertyDockerUtil.mergeStrings(command) + ". Using the default install path and server name.", null);
                        }
                    }
                    catch (ConnectException e) {
                        if (!Trace.ENABLED) break block25;
                        Trace.logError("Failed to get the container command in order to extract the install path and server name, using the defaults.", e);
                    }
                }
                libertyServerInfo.put(LIBERTY_RUNTIME_INSTALL_PATH, installPath);
                libertyServerInfo.put(LIBERTY_SERVER_NAME, serverName);
                serverConfigPath = installPath + "/usr/servers/" + serverName;
                wlpUserDir = null;
                try {
                    String sourcePath = installPath + "/" + "etc" + "/" + "server.env";
                    if (container.fileExists(sourcePath) && server != null) {
                        IPath destinationPath = server.getWebSphereServerBehaviour().getTempDirectory().append("server.env");
                        container.copyOut(sourcePath, destinationPath.toOSString());
                        File destinationFile = new File(destinationPath.toOSString());
                        ServerEnv serverEnv = new ServerEnv(destinationFile, null);
                        wlpUserDir = serverEnv.getValue("WLP_USER_DIR");
                        if (!destinationFile.delete() && Trace.ENABLED) {
                            Trace.trace((byte)1, "Failed to delete the temporary server.env file: " + destinationFile.getAbsolutePath(), null);
                        }
                    }
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block26;
                    Trace.logError("Failed to read the ${wlp.install.dir}/etc/server.env file in order to extract the user directory.", e);
                }
            }
            if (wlpUserDir == null) {
                try {
                    List env = container.getEnv();
                    String start = "WLP_USER_DIR=";
                    for (String varDef : env) {
                        if (!varDef.startsWith(start)) continue;
                        wlpUserDir = varDef.substring(start.length());
                    }
                }
                catch (ConnectException e) {
                    if (!Trace.ENABLED) break block27;
                    Trace.logError("Failed to get the container env in order to extract the user directory, using the default.", e);
                }
            }
        }
        if (wlpUserDir != null && !wlpUserDir.isEmpty()) {
            serverConfigPath = wlpUserDir + "/servers/" + serverName;
        }
        libertyServerInfo.put(LIBERTY_SERVER_CONFIG_PATH, serverConfigPath);
        return libertyServerInfo;
    }

    protected static String getImageName(BaseDockerContainer container) {
        String imageName = null;
        try {
            imageName = container.getImageName();
        }
        catch (ConnectException e1) {
            Trace.logError("Failed to get the image name for container: " + container.getContainerName(), null);
        }
        return imageName;
    }

    public static Map<String, String> getServiceInfo(BaseDockerContainer container, WebSphereServer server, String host, String port) {
        Map<String, String> libertyServerInfo = LibertyDockerUtil.getLibertyServerInfoMap(container, server);
        HashMap<String, String> serviceInfo = new HashMap<String, String>();
        serviceInfo.put(DOCKER_MACHINE_TYPE, container.getDockerMachine().getMachineType().name());
        serviceInfo.put(DOCKER_MACHINE, container.getDockerMachine().getMachineName());
        serviceInfo.put(DOCKER_CONTAINER, container.getContainerName());
        serviceInfo.put(DOCKER_IMAGE, LibertyDockerUtil.getImageName(container));
        serviceInfo.put(LIBERTY_RUNTIME_INSTALL_PATH, libertyServerInfo.get(LIBERTY_RUNTIME_INSTALL_PATH));
        serviceInfo.put(LIBERTY_SERVER_NAME, libertyServerInfo.get(LIBERTY_SERVER_NAME));
        serviceInfo.put(LIBERTY_SERVER_CONFIG_PATH, libertyServerInfo.get(LIBERTY_SERVER_CONFIG_PATH));
        serviceInfo.put(HOSTNAME, host);
        serviceInfo.put(LIBERTY_HTTPS_PORT, port);
        return serviceInfo;
    }

    private static String mergeStrings(List<String> list) {
        StringBuilder builder = new StringBuilder();
        boolean start = true;
        for (String item : list) {
            if (start) {
                start = false;
            } else {
                builder.append(" ");
            }
            builder.append(item);
        }
        return builder.toString();
    }
}

