/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.jmx;

import com.ibm.ws.st.core.internal.ApplicationNotificationListener;
import com.ibm.ws.st.core.internal.ConfigurationListener;
import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.jmx.JMXConnectionException;
import com.ibm.ws.st.core.internal.security.LibertySecurityHelper;
import com.ibm.ws.st.core.internal.security.LibertyX509TrustManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.eclipse.core.runtime.IPath;

public class JMXConnection {
    private static final String CONNECTOR_ADDRESS_FILE_NAME = "com.ibm.ws.jmx.local.address";
    private static final String OSGI_FRAMEWORK_MBEAN_NAME = "osgi.core:type=framework,*";
    private static final String GEN_PLUGIN_CONFIG_OBJECT_NAME = "WebSphere:name=com.ibm.ws.jmx.mbeans.generatePluginConfig";
    private static final String APP_MANAGEMENT_MBEAN_NAME = "WebSphere:service=com.ibm.websphere.application.ApplicationMBean,name=";
    private static final String FILE_SERVICE_MBEAN_NAME = "WebSphere:feature=restConnector,type=FileService,name=FileService";
    private static final String FILE_TRANSFER_MBEAN_NAME = "WebSphere:feature=restConnector,type=FileTransfer,name=FileTransfer";
    private static final String HTTP_ENDPOINT_SSL_MBEAN_NAME = "WebSphere:feature=channelfw,type=endpoint,name=defaultHttpEndpoint-ssl";
    private static final String HTTP_ENDPOINT_MBEAN_NAME = "WebSphere:feature=channelfw,type=endpoint,name=defaultHttpEndpoint";
    protected MBeanServerConnection mbsc = null;
    protected IPath serverWorkAreaPath = null;
    protected JMXConnector connector = null;
    protected String host;
    protected String port;
    protected String user;
    protected String password;

    public JMXConnection(IPath serverWorkAreaPath) {
        if (serverWorkAreaPath == null) {
            throw new IllegalArgumentException("Path to server cannot be null");
        }
        this.serverWorkAreaPath = serverWorkAreaPath;
    }

    public JMXConnection(String host, String port, String user, String password) {
        if (host == null) {
            throw new IllegalArgumentException("Hostname cannot be null");
        }
        if (port == null) {
            throw new IllegalArgumentException("Port cannot be null");
        }
        if (user == null) {
            throw new IllegalArgumentException("User name cannot be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        String hostName = FileUtil.getStringWithoutBrackets(host);
        try {
            InetAddress addr = InetAddress.getByName(hostName);
            if (addr instanceof Inet6Address) {
                hostName = "[" + hostName + "]";
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.host = hostName;
        this.port = port;
        this.user = user;
        this.password = password;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public void connect(long timeout, long interval) throws JMXConnectionException {
        JMXConnectionException connectException = null;
        for (long time = 0L; time < timeout; time += interval) {
            try {
                this.connect();
                connectException = null;
                break;
            }
            catch (JMXConnectionException e) {
                connectException = e;
                continue;
            }
        }
        if (connectException != null) {
            throw connectException;
        }
    }

    public void connect() throws JMXConnectionException {
        long time0 = System.currentTimeMillis();
        Throwable cause = null;
        try {
            if (this.connector == null) {
                JMXConnector jMXConnector = this.connector = this.isLocalConnection() ? this.getLocalConnector() : this.getRemoteConnector();
            }
            if (this.connector != null) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)5, "JMX Connector: " + this.connector);
                }
                this.mbsc = this.connector.getMBeanServerConnection();
            }
            if (this.mbsc != null) {
                if (Trace.ENABLED) {
                    Trace.tracePerf("Time to establish JMX", System.currentTimeMillis() - time0);
                }
                return;
            }
        }
        catch (Throwable t) {
            cause = t;
            try {
                if (Trace.ENABLED) {
                    Trace.trace((byte)5, "JMX connection failed.", t);
                }
                if (this.connector != null) {
                    this.connector.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connector = null;
        }
        this.disconnect();
        throw new JMXConnectionException(cause);
    }

    private JMXConnector getLocalConnector() throws Exception {
        IPath addressFilePath = this.serverWorkAreaPath.append(CONNECTOR_ADDRESS_FILE_NAME);
        File file = addressFilePath.toFile();
        boolean exist = file.exists();
        if (!exist) {
            long time = System.currentTimeMillis();
            for (int i = 100; !exist && i > 0; --i) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                exist = file.exists();
            }
            if (Trace.ENABLED) {
                Trace.tracePerf("Time to obtain JMX address", time);
            }
        }
        if (exist) {
            String connectorAddr = null;
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(addressFilePath.toFile()));
                connectorAddr = br.readLine();
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (connectorAddr != null) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)5, "JMX connector address:  " + connectorAddr);
                }
                JMXServiceURL url = new JMXServiceURL(connectorAddr);
                return JMXConnectorFactory.connect(url);
            }
            Trace.logError("JMXConnection: JMX connector address is null.  The file is " + file.getAbsolutePath(), null);
        } else {
            Trace.logError("JMXConnection: JMX address file doesn't exist: " + file.getAbsolutePath(), null);
        }
        return null;
    }

    private JMXConnector getRemoteConnector() throws Exception {
        String connectorAddr = "service:jmx:rest://" + this.host + ":" + this.port + "/IBMJMXConnectorREST";
        if (Trace.ENABLED) {
            Trace.trace((byte)5, "JMX connector address:  " + connectorAddr);
        }
        JMXServiceURL url = new JMXServiceURL(connectorAddr);
        SSLContext sc = LibertySecurityHelper.getSSLContext();
        TrustManager[] tm = new TrustManager[]{new LibertyX509TrustManager()};
        sc.init(null, tm, new SecureRandom());
        HashMap<String, Object> environment = new HashMap<String, Object>();
        environment.put("com.ibm.ws.jmx.connector.client.CUSTOM_SSLSOCKETFACTORY", sc.getSocketFactory());
        environment.put("com.ibm.ws.jmx.connector.client.disableURLHostnameVerification", Boolean.TRUE);
        environment.put("jmx.remote.protocol.provider.pkgs", "com.ibm.ws.jmx.connector.client");
        environment.put("jmx.remote.credentials", new String[]{this.user, this.password});
        environment.put("com.ibm.ws.jmx.connector.client.rest.maxServerWaitTime", new Integer(10000));
        return JMXConnectorFactory.connect(url, environment);
    }

    private Object invoke(String objectName, String operation, Object[] params, String[] signature) throws Exception {
        return this.invoke(new ObjectName(objectName), operation, params, signature);
    }

    private Object invoke(ObjectName objectName, String operation, Object[] params, String[] signature) throws Exception {
        if (this.mbsc == null) {
            throw new JMXConnectionException();
        }
        try {
            return this.mbsc.invoke(objectName, operation, params, signature);
        }
        catch (ConnectException e) {
            Trace.trace((byte)5, "Failed JMX operation '" + operation + "' on objectName '" + objectName + "'", e);
            throw new JMXConnectionException();
        }
        catch (Exception e) {
            Trace.trace((byte)5, "Failed JMX operation '" + operation + "' on objectName '" + objectName + "'", e);
            throw e;
        }
    }

    public void stop() throws Exception {
        if (Trace.ENABLED) {
            Trace.trace((byte)5, "Stopping server");
        }
        if (this.mbsc == null) {
            throw new JMXConnectionException();
        }
        Set<ObjectName> objNames = this.mbsc.queryNames(new ObjectName(OSGI_FRAMEWORK_MBEAN_NAME), null);
        if (objNames == null || objNames.isEmpty()) {
            throw new Exception("MBean object name query failed for pattern: osgi.core:type=framework,*");
        }
        if (objNames.size() > 1 && Trace.ENABLED) {
            Trace.trace((byte)1, "Found more than one mbean match for pattern: osgi.core:type=framework,*");
        }
        this.invoke(objNames.iterator().next(), "shutdownFramework", null, null);
    }

    public String[] getVMArgs() throws Exception {
        if (Trace.ENABLED) {
            Trace.trace((byte)5, "Stopping server");
        }
        if (this.mbsc == null) {
            throw new JMXConnectionException();
        }
        ObjectName objName = new ObjectName("java.lang:type=Runtime");
        return (String[])this.mbsc.getAttribute(objName, "InputArguments");
    }

    public int getDebugPortNum() throws Exception {
        int index;
        String[] vmArgs = this.getVMArgs();
        if (vmArgs == null) {
            return -1;
        }
        String debugArgs = null;
        int debugPort = -1;
        for (int i = 0; i < vmArgs.length; ++i) {
            String args = vmArgs[i];
            if (!args.contains("-agentlib:jdwp=")) continue;
            debugArgs = args;
            break;
        }
        if (debugArgs != null && (index = debugArgs.indexOf("address=")) != -1) {
            int colonIndex;
            String debugPortNumStr = debugArgs.substring(index + 8);
            int spaceIndex = debugPortNumStr.indexOf(" ");
            if (spaceIndex != -1) {
                debugPortNumStr = debugPortNumStr.substring(0, spaceIndex);
            }
            if ((colonIndex = debugPortNumStr.indexOf(58)) != -1) {
                debugPortNumStr = debugPortNumStr.substring(colonIndex + 1, debugPortNumStr.length());
            }
            try {
                debugPort = Integer.parseInt(debugPortNumStr);
            }
            catch (Exception e) {
                Trace.trace((byte)1, "Couldn't parse debug port number", e);
            }
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)5, "Remote Server is listening on socket:" + debugPort);
        }
        return debugPort;
    }

    public int getRemoteSecureHTTPPort() throws Exception {
        if (this.mbsc == null) {
            this.connect();
        }
        int httpPort = 0;
        Set<ObjectName> objNames = this.mbsc.queryNames(new ObjectName(HTTP_ENDPOINT_SSL_MBEAN_NAME), null);
        if (objNames == null) {
            throw new Exception("MBean object name query failed for pattern: WebSphere:feature=channelfw,type=endpoint,name=defaultHttpEndpoint-ssl*");
        }
        for (ObjectName defaultSecureHTTPEndPoint : objNames) {
            httpPort = (Integer)this.mbsc.getAttribute(defaultSecureHTTPEndPoint, "Port");
        }
        return httpPort;
    }

    public int getRemoteUnsecureHTTPPort() throws Exception {
        if (this.mbsc == null) {
            this.connect();
        }
        int httpPort = 0;
        Set<ObjectName> objNames = this.mbsc.queryNames(new ObjectName(HTTP_ENDPOINT_MBEAN_NAME), null);
        if (objNames == null) {
            throw new Exception("MBean object name query failed for pattern: WebSphere:feature=channelfw,type=endpoint,name=defaultHttpEndpoint*");
        }
        for (ObjectName defaultUnsecureHTTPEndPoint : objNames) {
            httpPort = (Integer)this.mbsc.getAttribute(defaultUnsecureHTTPEndPoint, "Port");
        }
        return httpPort;
    }

    public boolean isMBeanExists(String objectName) throws Exception {
        if (this.mbsc == null) {
            throw new JMXConnectionException();
        }
        Set<ObjectName> objNames = this.mbsc.queryNames(new ObjectName(objectName), null);
        return objNames != null && !objNames.isEmpty();
    }

    public List<String> getAllApplicationNames() throws Exception {
        if (this.mbsc == null) {
            throw new JMXConnectionException();
        }
        Set<ObjectName> objNames = this.mbsc.queryNames(new ObjectName("WebSphere:service=com.ibm.websphere.application.ApplicationMBean,name=*"), null);
        if (objNames == null) {
            throw new Exception("MBean object name query failed for pattern: WebSphere:service=com.ibm.websphere.application.ApplicationMBean,name=*");
        }
        if (objNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> appList = new ArrayList<String>();
        for (ObjectName name : objNames) {
            String appName = name.getKeyProperty("name");
            if (appName == null) continue;
            appList.add(appName);
        }
        return appList;
    }

    public void notifyFileChanges(Collection<String> added, Collection<String> changed, Collection<String> removed) throws Exception {
        if (Trace.ENABLED) {
            Trace.trace((byte)5, "Notify the server of added, changed and removed files");
            this.traceNotifyFileChanges("Added files", added);
            this.traceNotifyFileChanges("Changed files", changed);
            this.traceNotifyFileChanges("Removed files", removed);
        }
        String[] signature = new String[]{"java.util.Collection", "java.util.Collection", "java.util.Collection"};
        Object[] params = new Collection[]{added, changed, removed};
        this.invoke("WebSphere:service=com.ibm.ws.kernel.filemonitor.FileNotificationMBean", "notifyFileChanges", params, signature);
    }

    private void traceNotifyFileChanges(String title, Collection<String> files) {
        if (files != null) {
            Trace.trace((byte)5, title + ": " + files);
        }
    }

    public void generateDefaultPluginConfig() throws Exception {
        if (Trace.ENABLED) {
            Trace.trace((byte)5, "Generating default plugin config");
        }
        this.invoke(GEN_PLUGIN_CONFIG_OBJECT_NAME, "generateDefaultPluginConfig", null, null);
    }

    public void generatePluginConfig(String path, String serverName) throws Exception {
        if (Trace.ENABLED) {
            Trace.trace((byte)5, "Generating plugin config");
        }
        Object[] params = new String[]{path, serverName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        this.invoke(GEN_PLUGIN_CONFIG_OBJECT_NAME, "generatePluginConfig", params, signature);
    }

    public void startApplication(String applicationName) throws Exception {
        if (Trace.ENABLED) {
            Trace.trace((byte)5, "Start application: " + applicationName);
        }
        this.invoke(APP_MANAGEMENT_MBEAN_NAME + applicationName, "start", null, null);
    }

    public void stopApplication(String applicationName) throws Exception {
        if (Trace.ENABLED) {
            Trace.trace((byte)5, "Stop application: " + applicationName);
        }
        this.invoke(APP_MANAGEMENT_MBEAN_NAME + applicationName, "stop", null, null);
    }

    public void restartApplication(String applicationName) throws Exception {
        if (Trace.ENABLED) {
            Trace.trace((byte)5, "Restart application: " + applicationName);
        }
        this.invoke(APP_MANAGEMENT_MBEAN_NAME + applicationName, "restart", null, null);
    }

    public void downloadFile(String remoteFile, String destinationFile) throws Exception {
        if (this.isLocalConnection()) {
            throw new UnsupportedOperationException("Downloading files is only supported by the REST connector");
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)5, "Downloading remote file: " + remoteFile + " to " + destinationFile);
        }
        Object[] params = new String[]{remoteFile, destinationFile};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        this.invoke(FILE_TRANSFER_MBEAN_NAME, "downloadFile", params, signature);
    }

    public void uploadFile(File localFile, String destinationFile, boolean expand) throws Exception {
        if (this.isLocalConnection()) {
            throw new UnsupportedOperationException("Uploading files is only supported by the REST connector");
        }
        String path = null;
        if (localFile != null) {
            path = localFile.getAbsolutePath();
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)5, "Uploading file: " + path + " to " + destinationFile);
        }
        Object[] params = new Object[]{path, destinationFile, expand};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.Boolean"};
        this.invoke(FILE_TRANSFER_MBEAN_NAME, "uploadFile", params, signature);
    }

    public void deleteFile(String remoteSourceFile) throws Exception {
        if (this.isLocalConnection()) {
            throw new UnsupportedOperationException("Deleting files is only supported by the REST connector");
        }
        String file = remoteSourceFile;
        if (Trace.ENABLED) {
            Trace.trace((byte)5, "Deleting remote file: " + file);
        }
        Object[] params = new Object[]{file};
        String[] signature = new String[]{"java.lang.String"};
        this.invoke(FILE_TRANSFER_MBEAN_NAME, "deleteFile", params, signature);
    }

    public Object getMetadata(String path, String requestOptions) throws Exception {
        if (this.isLocalConnection()) {
            throw new UnsupportedOperationException("Querying the server is only supported by the REST connector");
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)5, "Querying server for path : " + path + " with request options " + requestOptions);
        }
        Object[] params = new String[]{path, requestOptions};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        return this.invoke(FILE_SERVICE_MBEAN_NAME, "getMetaData", params, signature);
    }

    public CompositeData[] getDirectoryEntries(String directory, boolean recursive, String requestOptions) throws Exception {
        if (this.isLocalConnection()) {
            throw new UnsupportedOperationException("Querying the server is only supported by the REST connector");
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)5, "Getting directory entries for: " + directory + " with request options " + requestOptions + " and isRecursive=" + recursive);
        }
        Object[] params = new Object[]{directory, recursive, requestOptions};
        String[] signature = new String[]{"java.lang.String", "boolean", "java.lang.String"};
        return (CompositeData[])this.invoke(FILE_SERVICE_MBEAN_NAME, "getDirectoryEntries", params, signature);
    }

    public void addAppListener(ApplicationNotificationListener appListener) throws Exception {
        if (this.mbsc == null) {
            throw new JMXConnectionException();
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)8, "Adding app listener for " + appListener.getAppName());
        }
        this.mbsc.addNotificationListener(new ObjectName(APP_MANAGEMENT_MBEAN_NAME + appListener.getAppName()), appListener, null, null);
        if (Trace.ENABLED) {
            Trace.trace((byte)8, "App listener successfully added for " + appListener.getAppName());
        }
    }

    public void removeAppListener(ApplicationNotificationListener appListener) throws Exception {
        if (this.mbsc == null) {
            throw new JMXConnectionException();
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)8, "Removing app listener for " + appListener.getAppName());
        }
        this.mbsc.removeNotificationListener(new ObjectName(APP_MANAGEMENT_MBEAN_NAME + appListener.getAppName()), appListener);
        if (Trace.ENABLED) {
            Trace.trace((byte)8, "App listener successfully removed for " + appListener.getAppName());
        }
    }

    public void addConfigListener(ConfigurationListener configListener) throws Exception {
        if (this.mbsc == null) {
            throw new JMXConnectionException();
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)8, "Adding config listener");
        }
        this.mbsc.addNotificationListener(new ObjectName("WebSphere:name=com.ibm.websphere.runtime.update.RuntimeUpdateNotificationMBean"), configListener, configListener.getFilter(), null);
        if (Trace.ENABLED) {
            Trace.trace((byte)8, "Config listener successfully added");
        }
    }

    public void removeConfigListener(ConfigurationListener configListener) throws Exception {
        if (this.mbsc == null) {
            throw new JMXConnectionException();
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)8, "Removing config listener");
        }
        this.mbsc.removeNotificationListener(new ObjectName("WebSphere:name=com.ibm.websphere.runtime.update.RuntimeUpdateNotificationMBean"), configListener, configListener.getFilter(), null);
        if (Trace.ENABLED) {
            Trace.trace((byte)8, "Config listener successfully removed");
        }
    }

    public String getAppState(String appName) throws Exception {
        if (this.mbsc == null) {
            throw new JMXConnectionException();
        }
        return (String)this.mbsc.getAttribute(new ObjectName(APP_MANAGEMENT_MBEAN_NAME + appName), "State");
    }

    public Object getMBeanAttribute(String objectName, String attribute) throws Exception {
        if (this.mbsc == null) {
            throw new JMXConnectionException();
        }
        return this.mbsc.getAttribute(new ObjectName(objectName), attribute);
    }

    public List<String> getAPISPIJars() throws Exception {
        if (this.mbsc == null) {
            throw new JMXConnectionException();
        }
        ArrayList<String> allDevFiles = new ArrayList<String>();
        String srcDir = "${wlp.install.dir}/dev";
        String requestOption = "a";
        Boolean recursive = Boolean.TRUE;
        String[] signature = new String[]{"java.lang.String", "boolean", "java.lang.String"};
        Object[] params = new Object[]{srcDir, recursive, requestOption};
        Object ret = this.mbsc.invoke(new ObjectName(FILE_SERVICE_MBEAN_NAME), "getDirectoryEntries", params, signature);
        if (ret instanceof CompositeData[]) {
            CompositeData[] retList;
            for (CompositeData fileMetaData : retList = (CompositeData[])ret) {
                if (fileMetaData.get("directory").equals(Boolean.TRUE)) continue;
                String filePath = (String)fileMetaData.get("fileName");
                allDevFiles.add(filePath);
            }
        }
        return allDevFiles;
    }

    public Integer getMBeanCount() throws Exception {
        if (this.mbsc == null) {
            throw new JMXConnectionException();
        }
        return this.mbsc.getMBeanCount();
    }

    public void disconnect() {
        this.mbsc = null;
        try {
            if (this.connector != null) {
                this.connector.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connector = null;
    }

    public boolean isLocalConnection() {
        return this.serverWorkAreaPath != null;
    }

    public boolean appMBeanExists(String moduleName) {
        block3: {
            try {
                List<String> apps = this.getAllApplicationNames();
                if (apps != null) {
                    return apps.contains(moduleName);
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block3;
                Trace.trace((byte)5, "Problem looking for MBean application", e);
            }
        }
        return false;
    }

    public boolean isConnected() {
        if (this.connector == null) {
            return false;
        }
        try {
            this.connector.connect();
        }
        catch (IOException e) {
            Trace.trace((byte)5, "JMXConnection could not be established.", e);
            return false;
        }
        return true;
    }
}

