/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config;

import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.config.ConfigurationFolder;
import com.ibm.ws.st.core.internal.config.IConfigurationElement;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;

public class ConfigurationDropinsFolder
extends ConfigurationFolder {
    private ConfigurationFolder defaultsFolder = null;
    private ConfigurationFolder overridesFolder = null;

    public ConfigurationDropinsFolder(UserDirectory userDir, IPath path, IFolder folder) {
        super(userDir, path, folder);
    }

    @Override
    public String getName() {
        return Messages.serverConfigurationDropins;
    }

    @Override
    public synchronized IConfigurationElement[] getChildren() {
        this.refresh(false);
        ArrayList<ConfigurationFolder> folders = new ArrayList<ConfigurationFolder>();
        if (this.defaultsFolder != null) {
            folders.add(this.defaultsFolder);
        }
        if (this.overridesFolder != null) {
            folders.add(this.overridesFolder);
        }
        return folders.toArray(new IConfigurationElement[folders.size()]);
    }

    @Override
    public synchronized boolean refresh(boolean force) {
        IFolder folder;
        boolean changed = false;
        IPath path = this.getPath().append("defaults");
        File dir = path.toFile();
        if (dir.exists() && this.defaultsFolder == null) {
            changed = true;
            folder = this.getFolder();
            if (folder != null) {
                folder = folder.getFolder("defaults");
            }
            this.defaultsFolder = new ConfigurationFolder(this.getUserDirectory(), path, folder);
        } else if (!dir.exists() && this.defaultsFolder != null) {
            changed = true;
            this.defaultsFolder = null;
        } else if (this.defaultsFolder != null && force && this.defaultsFolder.refresh(true)) {
            changed = true;
        }
        path = this.getPath().append("overrides");
        dir = path.toFile();
        if (dir.exists() && this.overridesFolder == null) {
            changed = true;
            folder = this.getFolder();
            if (folder != null) {
                folder = folder.getFolder("overrides");
            }
            this.overridesFolder = new ConfigurationFolder(this.getUserDirectory(), path, folder);
        } else if (!dir.exists() && this.overridesFolder != null) {
            changed = true;
            this.overridesFolder = null;
        } else if (this.overridesFolder != null && force && this.overridesFolder.refresh(true)) {
            changed = true;
        }
        return changed;
    }
}

