/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.FeatureResolverWrapper;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereRuntimeClasspathHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.server.core.IRuntime;

public class WebSphereRuntimeTargetedProject
implements IFacetedProjectListener {
    private IProject project = null;
    private IFacetedProject facetedProject = null;
    private volatile boolean isRefreshing;
    private final ClasspathEntriesCache classpathEntriesCache;
    Set<String> features = null;

    public WebSphereRuntimeTargetedProject(IProject project) {
        this.project = project;
        try {
            this.facetedProject = ProjectFacetsManager.create((IProject)project);
            this.facetedProject.addListener((IFacetedProjectListener)this, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.POST_INSTALL, IFacetedProjectEvent.Type.POST_UNINSTALL, IFacetedProjectEvent.Type.POST_VERSION_CHANGE});
        }
        catch (CoreException e) {
            Trace.logError("Error creating faceted project for project " + project.getName(), e);
        }
        this.classpathEntriesCache = new ClasspathEntriesCache();
    }

    public WebSphereRuntime getRuntime() {
        IRuntime runtime;
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime rt;
        WebSphereRuntime wr = null;
        if (this.facetedProject != null && (rt = this.facetedProject.getPrimaryRuntime()) != null && (runtime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)rt)) != null) {
            wr = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
        }
        return wr;
    }

    public Map<String, Set<String>> getConflictedFeatures() {
        WebSphereRuntime wr = this.getRuntime();
        WebSphereRuntimeClasspathHelper helper = wr.getClasspathHelper();
        Map<String, Set<String>> featuresWithConflictMap = helper.getFeaturesWithConflicts();
        Set<String> featuresWithConconflict = featuresWithConflictMap.keySet();
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (String feature : this.getFeatures()) {
            if (!featuresWithConconflict.contains(feature)) continue;
            result.put(feature, featuresWithConflictMap.get(feature));
        }
        return result;
    }

    public Set<String> getFeatures() {
        if (this.features == null) {
            if (this.isRefreshing && Trace.ENABLED) {
                Trace.trace((byte)0, "The project " + this.project.getName() + " is refreshing but features are " + this.features);
            }
            return new HashSet<String>();
        }
        return this.features;
    }

    public void refresh() {
        this.isRefreshing = true;
        try {
            Set<String> result = this.findFeatures(this.project, null);
            this.features = Collections.unmodifiableSet(result);
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Found features for project " + this.project.getName() + " " + this.features);
            }
        }
        finally {
            this.isRefreshing = false;
        }
    }

    public void refresh(boolean refreshInBackgound) {
        if (!refreshInBackgound) {
            this.refresh();
        } else {
            final IProject tmpProject = this.project;
            Job job = new Job("Updating liberty runtime features for project: " + tmpProject.getName()){

                protected IStatus run(IProgressMonitor progressMonitor) {
                    block2: {
                        WebSphereRuntimeTargetedProject.this.refresh();
                        try {
                            tmpProject.refreshLocal(2, progressMonitor);
                        }
                        catch (Exception e) {
                            if (!Trace.ENABLED) break block2;
                            Trace.trace((byte)0, "Error while trying to refresh: " + e.getMessage());
                        }
                    }
                    return new Status(0, "com.ibm.ws.st.core", "Updated features for project " + tmpProject.getName());
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    private Set<String> findFeatures(IProject project, IProgressMonitor progressMonitor) {
        WebSphereRuntime wr = this.getRuntime();
        if (wr != null) {
            List<String> features = FeatureResolverWrapper.findFeatures(project, wr, true, progressMonitor);
            return new HashSet<String>(features);
        }
        return Collections.emptySet();
    }

    public Set<String> getConflictedJars() {
        HashSet<String> conflictedJars = new HashSet<String>();
        HashSet<String> jarsUsedByReqFeatures = new HashSet<String>();
        Set<String> featuresRequiredByProject = this.getFeatures();
        WebSphereRuntime wr = this.getRuntime();
        if (wr == null) {
            return conflictedJars;
        }
        WebSphereRuntimeClasspathHelper cpHelper = wr.getClasspathHelper();
        for (String featureRequired : featuresRequiredByProject) {
            Set<String> jarsPerFeature = cpHelper.getConflictedJarsPerFeature(featureRequired);
            if (jarsPerFeature != null) {
                conflictedJars.addAll(jarsPerFeature);
            }
            if ((jarsPerFeature = cpHelper.getApiJars(featureRequired)) == null) continue;
            jarsUsedByReqFeatures.addAll(jarsPerFeature);
        }
        conflictedJars.removeAll(jarsUsedByReqFeatures);
        return conflictedJars;
    }

    public void handleEvent(IFacetedProjectEvent event) {
        this.refresh(true);
    }

    public ClasspathEntriesCache getClasspathEntriesCache() {
        return this.classpathEntriesCache;
    }

    class ClasspathEntriesCache {
        private IClasspathEntry[] entries = new IClasspathEntry[0];
        private long lastAccess = System.currentTimeMillis();
        private static final long TIMEOUT = 2000L;

        public IClasspathEntry[] getEntries() {
            long time = System.currentTimeMillis();
            if (time - this.lastAccess > 2000L) {
                this.entries = new IClasspathEntry[0];
            }
            this.lastAccess = time;
            return this.entries;
        }

        public void setEntries(IClasspathEntry[] entries) {
            this.entries = entries;
            this.lastAccess = System.currentTimeMillis();
        }
    }
}

