/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.ServerExtensionWrapper;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.PublishControllerDelegate;

public class WASPublishControllerDelegate
extends PublishControllerDelegate {
    public boolean isPublishRequired(IServer server, IResourceDelta delta) {
        ServerExtensionWrapper[] serverExtensions;
        WebSphereServer wsServer = (WebSphereServer)((Object)server.loadAdapter(WebSphereServer.class, null));
        if (wsServer == null) {
            return true;
        }
        int autoPublishSettings = server.getAttribute("auto-publish-setting", 1);
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "WASPublishControllerDelegate.isPublishRequired autoPublishSettings=" + autoPublishSettings);
        }
        if (autoPublishSettings < 2) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "WASPublishControllerDelegate returning false as autopublish is disabled" + autoPublishSettings);
            }
            return false;
        }
        WebSphereServerBehaviour behaviour = (WebSphereServerBehaviour)((Object)server.loadAdapter(WebSphereServerBehaviour.class, null));
        if (behaviour == null) {
            return true;
        }
        List<IModule[]> fullModules = behaviour.getPublishedModules();
        if (fullModules.isEmpty()) {
            return false;
        }
        IProject project = delta.getResource().getProject();
        if (project == null) {
            return false;
        }
        ArrayList<IModule> modules = new ArrayList<IModule>();
        for (IModule[] fm : fullModules) {
            if (!project.equals(fm[fm.length - 1].getProject())) continue;
            modules.add(fm[fm.length - 1]);
        }
        if (modules.isEmpty()) {
            return false;
        }
        IModule[] mods = modules.toArray(new IModule[modules.size()]);
        block1: for (ServerExtensionWrapper se : serverExtensions = wsServer.getServerExtensions()) {
            for (IModule m : modules) {
                if (!se.supports(m.getModuleType())) continue;
                se.initServer(wsServer);
                boolean publishRequired = se.isPublishRequired(mods, delta);
                if (!publishRequired) continue block1;
                return true;
            }
        }
        return false;
    }
}

