/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.RuntimeFeatureResolver;
import com.ibm.ws.st.core.internal.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IgnoredFeatureConflictMetadataHandler {
    private static final String ELE_CONFLICTS = "conflicts";
    private static final String ELE_CONFLICT = "conflict";
    private static final String ELE_CONFLICT_CHAIN = "conflictChain";
    private static final String ELE_FEATURE = "feature";

    public static void generateMetadataFile(IPath path, Set<RuntimeFeatureResolver.FeatureConflict> knownConflicts) throws ParserConfigurationException, IOException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element conflictsElement = doc.createElement(ELE_CONFLICTS);
        doc.appendChild(conflictsElement);
        for (RuntimeFeatureResolver.FeatureConflict conflict : knownConflicts) {
            Element conflictElement = doc.createElement(ELE_CONFLICT);
            IgnoredFeatureConflictMetadataHandler.addElement(conflictsElement, conflictElement, true, true);
            Element conflictChainA = doc.createElement(ELE_CONFLICT_CHAIN);
            IgnoredFeatureConflictMetadataHandler.addElement(conflictElement, conflictChainA, true, true);
            for (String feature : conflict.getDependencyChainA()) {
                Element featureElement = doc.createElement(ELE_FEATURE);
                IgnoredFeatureConflictMetadataHandler.addElement(conflictChainA, featureElement, true, true);
                Text text = doc.createTextNode(feature);
                featureElement.appendChild(text);
            }
            Element conflictChainB = doc.createElement(ELE_CONFLICT_CHAIN);
            IgnoredFeatureConflictMetadataHandler.addElement(conflictElement, conflictChainB, true, true);
            for (String feature : conflict.getDependencyChainB()) {
                Element featureElement = doc.createElement(ELE_FEATURE);
                IgnoredFeatureConflictMetadataHandler.addElement(conflictChainB, featureElement, true, true);
                Text text = doc.createTextNode(feature);
                featureElement.appendChild(text);
            }
        }
        IgnoredFeatureConflictMetadataHandler.saveDocument(path, doc);
    }

    private static void saveDocument(IPath path, Document d) throws IOException {
        FilterOutputStream w = null;
        try {
            File ignoreFile = path.toFile();
            w = new BufferedOutputStream(new FileOutputStream(ignoreFile));
            IgnoredFeatureConflictMetadataHandler.save(w, d);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getLocalizedMessage());
        }
        finally {
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void save(OutputStream os, Document document) throws IOException {
        StreamResult result = new StreamResult(os);
        DOMSource source = new DOMSource(document);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public static Set<RuntimeFeatureResolver.FeatureConflict> read(File file) throws SAXException, IOException, ParserConfigurationException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        parser.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException e) throws SAXException {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Warning while reading ignored features file.\nReason: " + e.getMessage());
                }
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Error while reading ignored features file.\nReason: " + e.getMessage());
                }
            }

            @Override
            public void error(SAXParseException e) throws SAXException {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Error while reading ignored features file.\nReason: " + e.getMessage());
                }
            }
        });
        Document doc = parser.parse(new InputSource(in));
        HashSet<RuntimeFeatureResolver.FeatureConflict> conflictsSet = new HashSet<RuntimeFeatureResolver.FeatureConflict>();
        Element conflictsElement = doc.getDocumentElement();
        Element conflict = IgnoredFeatureConflictMetadataHandler.getFirstChildElement(conflictsElement);
        while (conflict != null) {
            Element chainAElem = IgnoredFeatureConflictMetadataHandler.getFirstChildElement(conflict);
            List<String> chainA = IgnoredFeatureConflictMetadataHandler.getFeatures(chainAElem);
            Element chainBElem = IgnoredFeatureConflictMetadataHandler.getNextElement(chainAElem);
            List<String> chainB = IgnoredFeatureConflictMetadataHandler.getFeatures(chainBElem);
            conflictsSet.add(new RuntimeFeatureResolver.FeatureConflict(chainA, chainB));
            conflict = IgnoredFeatureConflictMetadataHandler.getNextElement(conflict);
        }
        return conflictsSet;
    }

    private static Element getFirstChildElement(Element element) {
        for (Node currNode = element.getFirstChild(); currNode != null; currNode = currNode.getNextSibling()) {
            if (currNode.getNodeType() != 1) continue;
            return (Element)currNode;
        }
        return null;
    }

    public static List<String> getFeatures(Element chain) {
        ArrayList<String> features = new ArrayList<String>();
        if (chain == null) {
            return features;
        }
        Element fElem = IgnoredFeatureConflictMetadataHandler.getFirstChildElement(chain);
        while (fElem != null) {
            String feature = fElem.getTextContent();
            if (feature != null && !feature.isEmpty() && !features.contains(feature)) {
                features.add(feature);
            }
            fElem = IgnoredFeatureConflictMetadataHandler.getNextElement(fElem);
        }
        return features;
    }

    private static Element getNextElement(Element element) {
        Node node;
        if (element == null) {
            return null;
        }
        for (node = element.getNextSibling(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    private static void addElement(Element parent, Element child, boolean isTopLevel, boolean hasChildren) {
        IgnoredFeatureConflictMetadataHandler.addPreElementText(parent, isTopLevel, hasChildren);
        parent.appendChild(child);
        IgnoredFeatureConflictMetadataHandler.addPostElementText(parent);
    }

    private static void addPreElementText(Element parent, boolean isTopLevel, boolean hasChildren) {
        if (parent == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        if (isTopLevel || !hasChildren) {
            builder.append("\n    ");
        }
        for (Node node = parent.getParentNode(); node != null && node.getNodeType() == 1; node = node.getParentNode()) {
            builder.append("    ");
        }
        Text text = parent.getOwnerDocument().createTextNode(builder.toString());
        parent.appendChild(text);
    }

    private static void addPostElementText(Element parent) {
        if (parent == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        for (Node node = parent.getParentNode(); node != null && node.getNodeType() == 1; node = node.getParentNode()) {
            builder.append("    ");
        }
        Text text = parent.getOwnerDocument().createTextNode(builder.toString());
        parent.appendChild(text);
    }
}

