/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;

public class FileUtil {
    public static final String FILE_URI = "file:/";
    private static final int BUFFER = 65536;
    private static byte[] buf = null;

    public static IStatus move(IPath from, IPath to) throws IOException {
        buf = new byte[65536];
        InputStream in = null;
        OutputStream out = null;
        try {
            File fromFile = from.toFile();
            in = new FileInputStream(fromFile);
            File toFile = to.toFile();
            out = new FileOutputStream(toFile);
            int avail = in.read(buf);
            while (avail > 0) {
                out.write(buf, 0, avail);
                avail = in.read(buf);
            }
            in.close();
            in = null;
            out.close();
            out = null;
            long ts = fromFile.lastModified();
            if (ts != -1L && ts != 0L && !toFile.setLastModified(ts) && Trace.ENABLED) {
                Trace.trace((byte)1, "Could not set last modified on " + toFile.getAbsolutePath());
            }
            if (!fromFile.delete()) {
                Status status = new Status(2, "com.ibm.ws.st.core", NLS.bind((String)Messages.warningFileDelete, (Object)from.toOSString()));
                return status;
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            buf = null;
        }
        return Status.OK_STATUS;
    }

    public static IStatus copy(URL from, IPath to) throws IOException {
        buf = new byte[65536];
        InputStream in = null;
        OutputStream out = null;
        try {
            URLConnection urlConn = from.openConnection();
            in = urlConn.getInputStream();
            File toFile = to.toFile();
            out = new FileOutputStream(toFile);
            int avail = in.read(buf);
            while (avail > 0) {
                out.write(buf, 0, avail);
                avail = in.read(buf);
            }
            in.close();
            in = null;
            out.close();
            out = null;
            long ts = urlConn.getLastModified();
            if (ts != -1L && ts != 0L && !toFile.setLastModified(ts) && Trace.ENABLED) {
                Trace.trace((byte)1, "Could not set last modified on " + toFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            buf = null;
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties(Properties properties, IPath filePath) {
        if (properties == null || filePath == null) {
            return;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(filePath.toFile());
            properties.load(in);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Trace.logError("Could not read the properties file: " + filePath, e);
        }
        catch (Exception e) {
            Trace.logError("Error during processing the properties file: " + filePath, e);
        }
        finally {
            block21: {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        if (!Trace.ENABLED) break block21;
                        Trace.trace((byte)1, "Could not close the properties file: " + filePath, e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCachedProperties(Properties properties, IPath filePath) {
        if (properties == null || filePath == null) {
            return;
        }
        if (!FileUtil.makeDir(filePath.removeLastSegments(1)) && Trace.ENABLED) {
            Trace.trace((byte)1, "Failed to create directory for properties file: " + filePath.toOSString(), null);
        }
        OutputStream out = null;
        try {
            out = new FileOutputStream(new File(filePath.toString()));
            properties.store(out, null);
        }
        catch (Exception e) {
            Trace.logError("Can't write to the properties file:" + filePath, e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    Trace.logError("Can't close the properties file:" + filePath, e);
                }
            }
        }
    }

    public static String genModuleURICacheKey(IModule[] module) {
        StringBuilder key = new StringBuilder();
        if (module != null) {
            for (IModule m : module) {
                key.append(m.getName()).append('/');
            }
        }
        return key.toString();
    }

    public static void deleteDirectory(String dir, boolean recursive) throws IOException {
        boolean isSuccess;
        String[] fileList;
        if (dir == null || dir.length() <= 0) {
            return;
        }
        if (new StringTokenizer(dir.replace(File.separatorChar, '/'), "/").countTokens() < 2) {
            return;
        }
        File fp = new File(dir);
        if (!fp.exists() || !fp.isDirectory()) {
            throw new IOException("Directory does not exist: " + fp.toString());
        }
        if (recursive && (fileList = fp.list()) != null) {
            String curBasePath = dir + File.separator;
            for (int i = 0; i < fileList.length; ++i) {
                File curFp = new File(curBasePath + fileList[i]);
                if (!curFp.exists()) continue;
                if (curFp.isDirectory()) {
                    FileUtil.deleteDirectory(dir + File.separator + fileList[i], recursive);
                    continue;
                }
                if (curFp.delete() || !Trace.ENABLED) continue;
                Trace.trace((byte)1, "Could not delete " + curFp.getName());
            }
        }
        if (!(isSuccess = fp.delete())) {
            throw new IOException("Directory cannot be removed.");
        }
    }

    public static boolean makeDir(IPath path) {
        boolean result = true;
        if (path != null) {
            try {
                File fp = path.toFile();
                if (!fp.exists() || !fp.isDirectory()) {
                    result = fp.mkdirs();
                }
            }
            catch (Exception e) {
                Trace.logError("Failed to create directory: " + path.toOSString(), e);
                result = false;
            }
        }
        return result;
    }

    public static String getJarManifestAttribute(String jarPath, String attribute) throws ZipException, IOException {
        Attributes mainAttr;
        if (jarPath != null && attribute != null && (mainAttr = FileUtil.getJarManifestAttributes(jarPath)) != null) {
            return mainAttr.getValue(attribute);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Attributes getJarManifestAttributes(String jarPath) throws ZipException, IOException {
        if (jarPath != null) {
            File file = new File(jarPath);
            InputStream in = null;
            ZipFile jar = null;
            try {
                jar = new ZipFile(file);
                ZipEntry mf = jar.getEntry("META-INF/MANIFEST.MF");
                if (mf != null) {
                    in = jar.getInputStream(mf);
                    Manifest manifest = new Manifest(in);
                    Attributes attributes = manifest.getMainAttributes();
                    return attributes;
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getJarSubSystemProperties(String jarPath) throws ZipException, IOException {
        if (jarPath != null) {
            File file = new File(jarPath);
            InputStream in = null;
            ZipFile jar = null;
            try {
                jar = new ZipFile(file);
                ZipEntry mf = jar.getEntry("OSGI-INF/SUBSYSTEM.MF");
                if (mf != null) {
                    HashMap<String, String> props = new HashMap<String, String>();
                    in = jar.getInputStream(mf);
                    FileUtil.readSubsystem(in, props);
                    HashMap<String, String> hashMap = props;
                    return hashMap;
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readSubsystem(InputStream is, Map<String, String> props) throws IOException {
        if (is == null) {
            return;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String nextLine = br.readLine();
            while (nextLine != null) {
                int colonI = nextLine.indexOf(58);
                if (colonI == -1 || colonI == 0) {
                    nextLine = br.readLine();
                    continue;
                }
                String hName = nextLine.substring(0, colonI);
                StringBuilder hValue = new StringBuilder();
                if (nextLine.length() > colonI + 1) {
                    String hvPart = nextLine.substring(colonI + 1);
                    hValue.append(hvPart.trim());
                }
                nextLine = br.readLine();
                while (nextLine != null && nextLine.length() > 0 && nextLine.charAt(0) == ' ') {
                    hValue.append(nextLine.trim());
                    nextLine = br.readLine();
                }
                props.put(hName, hValue.toString());
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zipDirectory(File folderToCompress, String destinationZipFile) throws IOException {
        if (folderToCompress == null || destinationZipFile == null) {
            return false;
        }
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            File zipFile = new File(destinationZipFile);
            if (folderToCompress.exists() && folderToCompress.isDirectory()) {
                fos = new FileOutputStream(zipFile);
                zos = new ZipOutputStream(fos);
                FileUtil.addToZipStream(zos, folderToCompress);
                zos.close();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private static void addToZipStream(ZipOutputStream zos, File file) throws IOException {
        FileUtil.addToZipStream(zos, file, file.getAbsolutePath());
    }

    private static void addToZipStream(ZipOutputStream zos, File file, String root) throws IOException {
        byte[] buf = new byte[8192];
        if (file.isFile()) {
            int length;
            String absPath = file.getAbsolutePath();
            String entry = absPath.substring(root.length() + 1, absPath.length());
            entry = entry.replace("\\", "/");
            ZipEntry zipEntry = new ZipEntry(entry);
            zos.putNextEntry(zipEntry);
            FileInputStream fis = new FileInputStream(file);
            while ((length = fis.read(buf)) > 0) {
                zos.write(buf, 0, length);
            }
            fis.close();
            zos.closeEntry();
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                FileUtil.addToZipStream(zos, f, root);
            }
        }
    }

    public static boolean isAbsolutePath(String path) {
        String pattern = "^(?i)[a-z]:[\\\\/].*";
        return path.matches(pattern) || path.startsWith("/");
    }

    public static void deleteFile(File file) {
        if (file.exists() && !file.delete() && Trace.ENABLED) {
            Throwable t = new Throwable();
            t.fillInStackTrace();
            Trace.trace((byte)1, "Unable to delete " + file.toString(), t);
        }
    }

    public static File[] getSortedFiles(File dir, boolean ignoreCase) {
        try {
            if (dir == null || !dir.isDirectory()) {
                return new File[0];
            }
            File[] files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile();
                }
            });
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return f1.getName().compareToIgnoreCase(f2.getName());
                }
            });
            return files;
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Could not get file list for directory: " + dir, e);
            }
            return new File[0];
        }
    }

    public static String getStringWithoutBrackets(String host) {
        String hostName = host;
        if (hostName.startsWith("[")) {
            hostName = hostName.substring(1, hostName.length());
        }
        if (hostName.endsWith("]")) {
            hostName = hostName.substring(0, hostName.length() - 1);
        }
        return hostName;
    }
}

