/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.common.core.ext.internal.util;

import com.ibm.ws.st.common.core.ext.internal.Messages;
import com.ibm.ws.st.common.core.ext.internal.Trace;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.IPlatformHandler;
import com.ibm.ws.st.common.core.ext.internal.util.AbstractDockerMachine;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class DockerMachine
extends AbstractDockerMachine {
    private final String machineName;

    public DockerMachine(String machineName, IPlatformHandler platformHandler) {
        super(platformHandler);
        this.machineName = machineName;
    }

    @Override
    public boolean isRealMachine() {
        return true;
    }

    @Override
    public AbstractDockerMachine.MachineType getMachineType() {
        return AbstractDockerMachine.MachineType.STANDARD;
    }

    @Override
    public String getMachineName() {
        return this.machineName;
    }

    @Override
    public String getHost() throws Exception {
        IPlatformHandler.ExecutionOutput result = this.platformHandler.executeCommand("docker-machine ip " + this.machineName, DEFAULT_TIMEOUT);
        int exitValue = result.getReturnCode();
        String outputStr = result.getOutput();
        String error = result.getError();
        if (exitValue != 0) {
            Trace.logError("Error getting docker env for machine " + this.machineName + ". Exit value = " + Integer.valueOf(exitValue) + " output: " + outputStr + " error: " + error, null);
            throw new RuntimeException(NLS.bind((String)Messages.errorFailedGettingDockerEnv, (Object[])new String[]{this.machineName, Integer.toString(exitValue), error}));
        }
        String host = outputStr.trim();
        if (Trace.ENABLED) {
            Trace.trace((byte)7, "Host for machine " + this.machineName + " is: " + host);
        }
        return host;
    }

    @Override
    public Map<String, String> getDockerEnv() throws Exception {
        String[] lines;
        IPlatformHandler.ExecutionOutput result = this.platformHandler.executeCommand("docker-machine env --shell cmd " + this.machineName, DEFAULT_TIMEOUT * 2L);
        int exitValue = result.getReturnCode();
        String outputStr = result.getOutput();
        String error = result.getError();
        if (exitValue != 0) {
            Trace.logError("Error getting docker env for machine " + this.machineName + ". Exit value = " + Integer.valueOf(exitValue) + " output: " + outputStr + " error: " + error, null);
            throw new RuntimeException(NLS.bind((String)Messages.errorFailedGettingDockerEnv, (Object[])new String[]{this.machineName, Integer.toString(exitValue), error.trim()}));
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)7, "Environment variables for machine " + this.machineName + " are: " + outputStr);
        }
        HashMap<String, String> env = new HashMap<String, String>();
        for (String line : lines = outputStr.split("[\r,\f,\n]+")) {
            String[] envVar;
            String[] tokens = line.split("[ ,\t]+");
            if (tokens.length != 2 || !"SET".equals(tokens[0]) || (envVar = tokens[1].split("[=]")).length != 2) continue;
            env.put(envVar[0], envVar[1]);
        }
        return env;
    }

    public String toString() {
        return this.machineName;
    }
}

