/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.common.core.ext.internal.setuphandlers;

import com.ibm.ws.st.common.core.ext.internal.Trace;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.AbstractPlatformHandler;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.IPlatformHandler;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.PlatformUtil;
import com.ibm.ws.st.common.core.ext.internal.util.AbstractDockerMachine;
import com.ibm.ws.st.common.core.ext.internal.util.FileUtil;
import com.ibm.ws.st.common.core.ext.internal.util.ProcessHelper;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class LocalHandler
extends AbstractPlatformHandler
implements IPlatformHandler {
    LocalHandler() {
    }

    @Override
    public IPlatformHandler.ExecutionOutput executeCommand(String command) throws Exception {
        IPlatformHandler.ExecutionOutput execOut = this.runCommand(null, command, AbstractDockerMachine.DEFAULT_TIMEOUT, null);
        return execOut;
    }

    @Override
    public IPlatformHandler.ExecutionOutput executeCommand(String command, long timeout) throws Exception {
        IPlatformHandler.ExecutionOutput execOut = this.runCommand(null, command, timeout, null);
        return execOut;
    }

    @Override
    public IPlatformHandler.ExecutionOutput executeCommand(Map<String, String> env, String command, long timeout) throws Exception {
        IPlatformHandler.ExecutionOutput execOut = this.runCommand(env, command, timeout, null);
        return execOut;
    }

    @Override
    public IPlatformHandler.ExecutionOutput executeCommand(Map<String, String> env, String command, long timeout, IProgressMonitor monitor) throws Exception {
        return this.runCommand(env, command, timeout, monitor);
    }

    protected IPlatformHandler.ExecutionOutput runCommand(Map<String, String> cmdEnv, String cmdStr, long timeout, IProgressMonitor progressMonitor) throws Exception {
        ProcessBuilder builder;
        String[] cmd;
        PlatformUtil.OperatingSystem os = this.getOS();
        if (os == PlatformUtil.OperatingSystem.MAC) {
            String macEnvPath = System.getProperty("com.ibm.ws.st.envPath", "/usr/local/bin/");
            StringBuilder path = new StringBuilder(macEnvPath);
            cmd = this.formatCommand(path.append(cmdStr).toString());
            builder = this.createProcessBuilder(cmdEnv, cmd);
            Map<String, String> environment = builder.environment();
            environment.put("PATH", macEnvPath);
        } else {
            cmd = this.formatCommand(cmdStr);
            builder = this.createProcessBuilder(cmdEnv, cmd);
        }
        IProgressMonitor monitor = progressMonitor;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (Trace.ENABLED) {
            StringBuilder sb = new StringBuilder("CMD: ");
            for (String c : cmd) {
                sb.append(c + " ");
            }
            Trace.trace((byte)7, sb.toString());
        }
        Process process = builder.start();
        return ProcessHelper.waitForProcess(process, 100, (float)timeout / 1000.0f, 300, monitor);
    }

    protected ProcessBuilder createProcessBuilder(Map<String, String> cmdEnv, String ... options) {
        ArrayList<String> cmd = new ArrayList<String>();
        for (String option : options) {
            cmd.add(option);
        }
        ProcessBuilder builder = new ProcessBuilder(cmd);
        builder.redirectErrorStream(false);
        if (cmdEnv != null && !cmdEnv.isEmpty()) {
            Map<String, String> env = builder.environment();
            for (Map.Entry<String, String> entry : cmdEnv.entrySet()) {
                env.put(entry.getKey(), entry.getValue());
            }
        }
        return builder;
    }

    private String[] formatCommand(String cmdStr) {
        ArrayList<String> cmdArray = new ArrayList<String>();
        Pattern pattern = Pattern.compile("[^\\s\"]+|\"[^\"]*\"");
        Matcher matcher = pattern.matcher(cmdStr);
        while (matcher.find()) {
            cmdArray.add(matcher.group().replaceAll("^\"|\"$", ""));
        }
        return cmdArray.toArray(new String[cmdArray.size()]);
    }

    @Override
    public void startSession() throws ConnectException {
    }

    @Override
    public boolean directoryExists(String path) throws ConnectException {
        File f = new File(path);
        return f.exists();
    }

    @Override
    public boolean fileExists(String filePath) throws ConnectException {
        File f = new File(filePath);
        return f.exists();
    }

    @Override
    public void createDirectory(String path) throws ConnectException, IOException {
        File f = new File(path);
        f.mkdirs();
    }

    @Override
    public void uploadFile(String sourcePath, String destinationPath) throws ConnectException, IOException {
        Path dest = new Path(destinationPath);
        File file = new File(sourcePath);
        FileUtil.copy(file.toURI().toURL(), (IPath)dest);
    }

    @Override
    public void downloadFile(String sourcePath, String destinationPath) throws ConnectException, IOException {
        Path src = new Path(sourcePath);
        Path dest = new Path(destinationPath);
        FileUtil.copy(src.toFile().toURI().toURL(), (IPath)dest);
    }

    @Override
    public void endSession() throws ConnectException {
    }

    @Override
    public String getEnvValue(String key) throws ConnectException, IOException {
        return System.getProperty(key);
    }

    @Override
    public String getTempDir() throws IOException {
        return this.ensureEndsWithPathSeparator(System.getProperty("java.io.tmpdir"));
    }

    @Override
    public void deleteFile(String path) throws Exception {
        File f = new File(path);
        f.delete();
    }

    @Override
    public PlatformUtil.OperatingSystem getOS() throws ConnectException, IOException {
        String osName = this.getEnvValue("os.name");
        return PlatformUtil.getOS(osName);
    }
}

