/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.jee.core.internal;

import com.ibm.ws.st.core.internal.ApplicationPublisher;
import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.PublishUnit;
import com.ibm.ws.st.jee.core.internal.Messages;
import com.ibm.ws.st.jee.core.internal.SharedLibertyUtils;
import com.ibm.ws.st.jee.core.internal.Trace;
import com.ibm.ws.st.jee.core.internal.UtilitySharedLibInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.PublishHelper;

public class SharedLibPublisher
extends ApplicationPublisher {
    private Properties moduleURICachedMap = null;
    private static String MODULE_URI_CACHE_FILE_NAME = "sharedLibModuleUri.map";

    protected IStatus publishModule(int kind, PublishUnit unit, IProgressMonitor monitor) {
        IModule[] module = unit.getModule();
        int deltaKind = unit.getDeltaKind();
        IPath cacheFilePath = this.getWebSphereServerBehaviour().getTempDirectory().append(MODULE_URI_CACHE_FILE_NAME);
        if (this.moduleURICachedMap == null) {
            this.moduleURICachedMap = new Properties();
            FileUtil.loadProperties((Properties)this.moduleURICachedMap, (IPath)cacheFilePath);
        }
        String cacheKey = FileUtil.genModuleURICacheKey((IModule[])module);
        ArrayList<IStatus> status = new ArrayList<IStatus>();
        if (module.length == 1 && SharedLibertyUtils.isSharedLibrary(module[0]) || deltaKind == 3 && this.moduleURICachedMap.containsKey(cacheKey)) {
            IProject project = module[0].getProject();
            UtilitySharedLibInfo info = SharedLibertyUtils.getUtilPrjSharedLibInfo(project);
            if (deltaKind == 3) {
                String filePath = this.moduleURICachedMap.getProperty(cacheKey);
                Object path = filePath != null ? new Path(filePath) : new Path(info.getLibDir()).append(this.getModuleDeployName(module[0]));
                if (!path.toFile().delete() && Trace.ENABLED) {
                    Trace.trace((byte)1, "Can't delete shared library jar file for " + project.getName());
                }
                this.moduleURICachedMap.remove(cacheKey);
            } else if (deltaKind == 1 || deltaKind == 2 || kind == 4) {
                if (info.getLibId().isEmpty() || info.getLibDir().isEmpty()) {
                    return new Status(4, "com.ibm.ws.st.jee.core", NLS.bind((String)Messages.errorSharedLibProjectInfoIncomplete, (Object)project.getName()));
                }
                PublishHelper helper = new PublishHelper(this.getWebSphereServer().getWorkAreaTempPath().toFile());
                Path path = new Path(info.getLibDir());
                if (!path.toFile().exists() && !path.toFile().mkdirs()) {
                    return new Status(4, "com.ibm.ws.st.jee.core", NLS.bind((String)Messages.errorCreateFolder, (Object)path.toOSString()));
                }
                path = path.append(this.getModuleDeployName(module[0]));
                IModuleResource[] mr = this.getWebSphereServerBehaviour().getResources(module);
                IStatus[] stat = helper.publishZip(mr, (IPath)path, monitor);
                SharedLibPublisher.addArrayToList(status, stat);
                this.moduleURICachedMap.put(cacheKey, path.toOSString());
            }
            FileUtil.saveCachedProperties((Properties)this.moduleURICachedMap, (IPath)cacheFilePath);
        }
        return SharedLibPublisher.combineModulePublishStatus(status, (String)module[module.length - 1].getName());
    }

    private static void addArrayToList(List<IStatus> list, IStatus[] a) {
        if (list == null || a == null || a.length == 0) {
            return;
        }
        int size = a.length;
        for (int i = 0; i < size; ++i) {
            list.add(a[i]);
        }
    }

    protected String getModuleDeployName(IModule module) {
        if (module == null) {
            return null;
        }
        return module.getName() + ".jar";
    }
}

