/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.liberty.buildplugin.integration.xml.internal;

import com.ibm.ws.st.liberty.buildplugin.integration.internal.LibertyBuildPluginConfiguration;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.Trace;
import com.ibm.ws.st.liberty.buildplugin.integration.xml.internal.DOMBasedLibertyBuildPluginConfigurationBuilder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LibertyBuildPluginXMLConfigurationReader {
    private Document document;
    private Element rootElement;
    private long lastModified;

    public LibertyBuildPluginConfiguration load(URI uri) throws IOException {
        InputStream in = null;
        long time = System.currentTimeMillis();
        try {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Loading Liberty plugin configuration file : " + uri.toString());
            }
            File file = new File(uri);
            this.lastModified = file.lastModified();
            in = new BufferedInputStream(new FileInputStream(file));
            this.document = this.documentLoad(in);
            this.rootElement = this.document.getDocumentElement();
            if (this.rootElement == null) {
                throw new IOException("Could not read config file");
            }
            LibertyBuildPluginConfiguration libertyBuildPluginConfiguration = this.loadModel();
            return libertyBuildPluginConfiguration;
        }
        catch (FileNotFoundException e) {
            Trace.logError("Invalid file: " + uri, e);
            throw e;
        }
        catch (IllegalArgumentException e) {
            Trace.logError("Invalid path: " + uri, e);
            throw new IOException("Could not read config file", e);
        }
        catch (IOException e) {
            Trace.logError("Could not load configuration file: " + uri, e);
            throw e;
        }
        catch (Exception e) {
            Trace.logError("Could not load configuration file: " + uri, e);
            throw new IOException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            if (Trace.ENABLED) {
                long t = System.currentTimeMillis() - time;
                Trace.trace((byte)0, "Liberty plugin configuration file load time " + t + "ms");
            }
        }
    }

    private LibertyBuildPluginConfiguration loadModel() throws IOException {
        NodeList children = this.rootElement.getChildNodes();
        if (children == null || children.getLength() == 0) {
            throw new IOException("Liberty build plugin configuration file is invalid.");
        }
        DOMBasedLibertyBuildPluginConfigurationBuilder configBuilder = new DOMBasedLibertyBuildPluginConfigurationBuilder(this.lastModified);
        configBuilder.buildModel(this.rootElement);
        return configBuilder.getModel();
    }

    public Document documentLoad(InputStream in) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        parser.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException e) throws SAXException {
                Trace.trace((byte)1, "Warning while reading configuration file.\nReason: " + e.getMessage());
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                Trace.logError("Error while reading configuration file.", e);
            }

            @Override
            public void error(SAXParseException e) throws SAXException {
                Trace.trace((byte)1, "Error while reading configuration file.\nReason: " + e.getMessage());
            }
        });
        return parser.parse(new InputSource(in));
    }
}

