/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.liberty.buildplugin.integration.internal;

import com.ibm.ws.st.core.internal.LibertyRuntimeProvider;
import com.ibm.ws.st.core.internal.URIUtil;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereRuntimeLocator;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.ConfigurationType;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.ILibertyBuildPluginImpl;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.LibertyBuildPluginConfiguration;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.Trace;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public abstract class AbstractLibertyRuntimeProvider
extends LibertyRuntimeProvider {
    public URI getTargetConfigFileLocation(URI uri, WebSphereServerInfo server) {
        IContainer[] containers;
        if (uri != null && (containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(uri)) != null && containers.length == 1) {
            IContainer container = containers[0];
            IProject project = container.getProject();
            LibertyBuildPluginConfiguration config = this.getBuildPluginConfiguration(project);
            if (config == null) {
                return null;
            }
            WebSphereRuntime webSphereRuntime = this.getWSRuntime(project, config);
            if (webSphereRuntime != server.getWebSphereRuntime()) {
                return null;
            }
            String serverOutputDirectoryValue = config.getConfigValue(ConfigurationType.serverOutputDirectory);
            try {
                Path path = new Path(serverOutputDirectoryValue);
                IPath targetServerConfig = this.getTargetServerConfig((IPath)path);
                IResource findMember = this.convertConfigValueToIResource(targetServerConfig.toFile().toURI(), project);
                if (findMember != null && findMember.exists()) {
                    return findMember.getLocationURI();
                }
                File externalFile = targetServerConfig.toFile();
                return externalFile.toURI();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public WebSphereServerInfo getWebSphereServerInfo(URI uri) {
        try {
            IContainer[] containers;
            if (uri != null && (containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(uri)) != null && containers.length == 1) {
                IContainer container = containers[0];
                IProject project = container.getProject();
                if (!project.isAccessible()) {
                    return null;
                }
                final LibertyBuildPluginConfiguration config = this.getBuildPluginConfiguration(project);
                if (config == null) {
                    return null;
                }
                UserDirectory userDirectory = this.getUserDirectory(project, config);
                if (userDirectory != null) {
                    String serverName = config.getConfigValue(ConfigurationType.serverName);
                    userDirectory.getWebSphereRuntime();
                    final ConfigurationFile cfgFile = new ConfigurationFile(uri, userDirectory);
                    WebSphereServerInfo info = new WebSphereServerInfo(serverName, userDirectory, userDirectory.getWebSphereRuntime()){

                        protected File getBootstrapFile() {
                            File bootstrapFile;
                            File bootstrapFileFromServer = super.getBootstrapFile();
                            String value = config.getConfigValue(ConfigurationType.bootstrapPropertiesFile);
                            if (value != null && (bootstrapFile = new File(value)).exists()) {
                                return bootstrapFile;
                            }
                            return bootstrapFileFromServer;
                        }

                        protected File getServerEnvFile() {
                            File serverEnvFile;
                            File serverEnvFileFromServer = super.getServerEnvFile();
                            String value = config.getConfigValue(ConfigurationType.serverEnv);
                            if (value != null && (serverEnvFile = new File(value)).exists()) {
                                return serverEnvFile;
                            }
                            return serverEnvFileFromServer;
                        }

                        public ConfigurationFile getConfigRoot() {
                            return cfgFile;
                        }
                    };
                    return info;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public IFolder getConfigFolder(IResource resource) {
        block5: {
            IProject project = resource.getProject();
            LibertyBuildPluginConfiguration config = this.getBuildPluginConfiguration(project);
            if (config == null) {
                return null;
            }
            String configDirectory = config.getConfigValue(ConfigurationType.configDirectory);
            if (configDirectory != null) {
                try {
                    Path configDirPath = new Path(configDirectory);
                    IResource configDir = this.convertConfigValueToIResource(configDirPath.toFile().toURI(), project);
                    if (configDir != null && configDir.getType() == 2) {
                        return (IFolder)configDir;
                    }
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block5;
                    Trace.trace((byte)0, "The project is a Gradle or Maven Project with an existing build plugin file, but could not determine the config directory.");
                }
            }
        }
        return null;
    }

    protected abstract ILibertyBuildPluginImpl getBuildPlugin();

    protected abstract IServer getMappedServer(String var1);

    protected LibertyBuildPluginConfiguration getBuildPluginConfiguration(IProject project) {
        ILibertyBuildPluginImpl buildPluginImpl = this.getBuildPlugin();
        if (!buildPluginImpl.isSupportedProject(project, null)) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "The project is a Liberty Build Plugin project, but it does not match the criteria, or, the project is not applicable.  Some features of Liberty Tools such as quick fixes are disabled");
            }
            return null;
        }
        LibertyBuildPluginConfiguration config = buildPluginImpl.getLibertyBuildPluginConfiguration(project, (IProgressMonitor)new NullProgressMonitor());
        if (config == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "The Project is a Liberty Build Project but does not have the liberty-plugin-config.xml file.  Some features of Liberty Tools such as quick fixes are disabled");
            }
            return null;
        }
        return config;
    }

    private UserDirectory getUserDirectory(IProject project, LibertyBuildPluginConfiguration config) {
        String installDir = config.getConfigValue(ConfigurationType.installDirectory);
        WebSphereRuntime wsRuntime = this.getWSRuntime(installDir);
        String userDirVal = config.getConfigValue(ConfigurationType.userDirectory);
        if (userDirVal != null && wsRuntime != null) {
            Path userPath = new Path(userDirVal);
            return new UserDirectory(wsRuntime, (IPath)userPath, project);
        }
        return null;
    }

    private WebSphereRuntime getWSRuntime(IProject project, LibertyBuildPluginConfiguration config) {
        String installDir = config.getConfigValue(ConfigurationType.installDirectory);
        if (installDir == null) {
            return null;
        }
        return this.getWSRuntime(installDir);
    }

    private WebSphereRuntime getWSRuntime(String installDir) {
        IRuntime[] runtimes = ServerCore.getRuntimes();
        Path installDirectory = new Path(installDir);
        IRuntime runtime = null;
        for (IRuntime rt : runtimes) {
            if (!WebSphereUtil.isWebSphereRuntime((IRuntime)rt) || !installDirectory.equals((Object)rt.getLocation())) continue;
            runtime = rt;
        }
        WebSphereRuntime wsRuntime = null;
        if (runtime != null) {
            wsRuntime = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
        } else {
            IRuntimeWorkingCopy runtimeFromDir = WebSphereRuntimeLocator.getRuntimeFromDir((IPath)installDirectory, (IProgressMonitor)new NullProgressMonitor());
            if (runtimeFromDir != null) {
                wsRuntime = (WebSphereRuntime)runtimeFromDir.loadAdapter(WebSphereRuntime.class, null);
            }
        }
        return wsRuntime;
    }

    private IPath getTargetServerConfig(IPath serverOutputDirectory) {
        return serverOutputDirectory.append("server.xml");
    }

    private IResource convertConfigValueToIResource(URI pathURI, IProject project) {
        try {
            URI relativeURI = URIUtil.canonicalRelativize((URI)project.getLocationURI(), (URI)pathURI);
            return project.findMember(relativeURI.getPath());
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Can't find the workspace resource for: " + pathURI.toString());
            }
            return null;
        }
    }
}

